/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.loginmodification;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.api.LoginModificationTask;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.data.LoginModificationResultResponseData;
import com.inet.helpdesk.usersandgroups.UserIterator;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DeleteLoginModificationTask
implements LoginModificationTask {
    @Override
    public String getKey() {
        return "loginmodification.deletelogin";
    }

    @Override
    public String getTitle() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.deletelogin.title", new Object[0]);
    }

    @Override
    public String getDescription() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.deletelogin.description", new Object[0]);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public LoginModificationResultResponseData executeLoginModification(HashMap<String, String> parameters) throws ServerDataException {
        return this.generateResults(UserManager.getInstance(), parameters, true);
    }

    @Override
    public LoginModificationResultResponseData calcLoginModificationResult(HashMap<String, String> parameters) throws ServerDataException {
        return this.generateResults(UserManager.getInstance(), parameters, false);
    }

    protected LoginModificationResultResponseData generateResults(UserManager manager, HashMap<String, String> parameters, boolean asExecutor) {
        String existingDomain = parameters.get("existingDomain");
        HelpDeskMaintenanceServerPlugin.LOGGER.info((Object)("Delete domain \"" + existingDomain + "\" " + (asExecutor ? "Execution" : "Information")));
        DeleteOperator lmda = new DeleteOperator(manager, existingDomain, asExecutor);
        LoginModificationResultResponseData lmrrd = lmda.generateResult();
        lmrrd.setKey(this.getKey());
        if (asExecutor) {
            LocalizedKey[] modifiedElements = new LocalizedKey[]{new LocalizedKey(existingDomain.toUpperCase(), "")};
            lmrrd.setModifiedEntrys(modifiedElements);
        }
        return lmrrd;
    }

    private class DeleteOperator {
        private UserManager manager;
        private boolean asExecutor;
        private String toDeleteDomain;
        private String originalDomain;
        private int loginCount = 0;
        private int activeUsers = 0;
        private int inactiveUsers = 0;

        protected DeleteOperator(UserManager manager, String toDeleteDomain, boolean asExecutor) {
            this.manager = manager;
            this.toDeleteDomain = toDeleteDomain.toUpperCase();
            this.asExecutor = asExecutor;
            this.originalDomain = toDeleteDomain;
            List accountLoginsList = new UserIterator().getUserSystemLogins(manager);
            for (UserIterator.AccountLogins accountLogins : accountLoginsList) {
                this.handleData(accountLogins);
            }
        }

        private void handleData(UserIterator.AccountLogins accountLogins) {
            boolean affected = false;
            UserAccount userAccount = accountLogins.getUserAccount();
            for (UserIterator.LoginData systemLogin : accountLogins.getSystemLogins()) {
                if (!this.toDeleteDomain.equals(systemLogin.getDomain())) continue;
                if (this.asExecutor) {
                    LoginSettings login = userAccount.getLoginSettings().stream().filter(l -> "system".equals(l.getLoginSource()) && systemLogin.getOriginalName().equals(l.getLoginID())).findFirst().get();
                    ArrayList settingsToAdd = new ArrayList();
                    ArrayList<LoginSettings> settingsToRemove = new ArrayList<LoginSettings>();
                    settingsToRemove.add(login);
                    this.manager.updateLoginSettings(userAccount.getID(), settingsToAdd, settingsToRemove);
                }
                ++this.loginCount;
                affected = true;
            }
            if (affected) {
                if (userAccount.isActive()) {
                    ++this.activeUsers;
                } else {
                    ++this.inactiveUsers;
                }
            }
        }

        protected LoginModificationResultResponseData generateResult() {
            LoginModificationResultResponseData result = new LoginModificationResultResponseData();
            ArrayList<String> resultData = new ArrayList<String>();
            resultData.add(HelpDeskMaintenanceServerPlugin.MSG.getMsg(this.asExecutor ? "loginmodification.deletelogin.execution.count" : "loginmodification.deletelogin.information.count", new Object[]{this.loginCount, this.originalDomain}));
            resultData.add(HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.affected.execution.count", new Object[]{this.activeUsers, this.inactiveUsers}));
            result.setResult(resultData);
            return result;
        }
    }
}

