/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.datacare.handler;

import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareDateFormat;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.helpdesk.plugins.maintenance.server.datacare.data.DataCareInitResponseData;
import com.inet.helpdesk.plugins.maintenance.server.datacare.data.DataCareTaskDefinition;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.maintenance.api.MaintenanceHandler;
import com.inet.plugin.ServerPluginManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;

public class DataCareInitHandler
extends MaintenanceHandler<Void, DataCareInitResponseData> {
    public String getMethodName() {
        return "maintenance_datacare_init";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public DataCareInitResponseData invoke(Void input) throws ClientMessageException {
        DataCareInitResponseData response = new DataCareInitResponseData();
        DateFormat formatter = DataCareDateFormat.getDateFormat(ClientLocale.getThreadLocale());
        String localPattern = ((SimpleDateFormat)formatter).toPattern();
        response.setDateFormat(localPattern.toUpperCase());
        @Nonnull List list = ServerPluginManager.getInstance().get(DataCareTask.class);
        ArrayList<DataCareTaskDefinition> definitions = new ArrayList<DataCareTaskDefinition>();
        if (list != null) {
            Collections.sort(list, new Comparator<DataCareTask>(){

                @Override
                public int compare(DataCareTask o1, DataCareTask o2) {
                    int diff = o1.getPriority() - o2.getPriority();
                    if (diff == 0) {
                        return o1.getTitle().compareToIgnoreCase(o2.getTitle());
                    }
                    return diff;
                }
            });
            for (DataCareTask task : list) {
                DataCareTaskDefinition definition = new DataCareTaskDefinition();
                definition.setKey(task.getExtensionName());
                definition.setTitle(task.getTitle());
                definition.setDescription(task.getDescription());
                definition.setParameter(task.getParameter());
                definitions.add(definition);
            }
        }
        response.setTasks(definitions);
        return response;
    }
}

