/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.datacare.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.helpdesk.plugins.maintenance.server.datacare.data.DataCarePreviewRequestData;
import com.inet.helpdesk.plugins.maintenance.server.datacare.data.DataCarePreviewResponseData;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.maintenance.api.MaintenanceHandler;
import com.inet.plugin.ServerPluginManager;

public class DataCarePreviewHandler
extends MaintenanceHandler<DataCarePreviewRequestData, DataCarePreviewResponseData> {
    public String getMethodName() {
        return "maintenance_datacare_getpreview";
    }

    public DataCarePreviewResponseData invoke(DataCarePreviewRequestData input) throws ClientMessageException {
        DataCarePreviewResponseData response = new DataCarePreviewResponseData();
        response.setKey(input.getKey());
        try {
            DataCareTask task = (DataCareTask)ServerPluginManager.getInstance().getSingleInstanceByName(DataCareTask.class, input.getKey(), false);
            response.setPreview(task.getPreview(input.getParams()));
        }
        catch (ServerDataException sde) {
            HelpDeskMaintenanceServerPlugin.LOGGER.error((Throwable)sde);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)sde));
        }
        catch (IllegalStateException e) {
            throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.error.tasknotfound", new Object[0]));
        }
        return response;
    }
}

