/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.Validity;

public class DeltaCertificateDescriptor
extends ASN1Object {
    public static final ASN1ObjectIdentifier deltaCertificateDescriptor = new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.1");
    private final ASN1Integer serialNumber;
    private final AlgorithmIdentifier signature;
    private final X500Name issuer;
    private final Validity validity;
    private final X500Name subject;
    private final SubjectPublicKeyInfo subjectPublicKeyInfo;
    private final Extensions extensions;
    private final ASN1BitString signatureValue;

    public static DeltaCertificateDescriptor getInstance(Object object) {
        if (object instanceof DeltaCertificateDescriptor) {
            return (DeltaCertificateDescriptor)((Object)object);
        }
        if (object != null) {
            return new DeltaCertificateDescriptor(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public static DeltaCertificateDescriptor fromExtensions(Extensions extensions) {
        return DeltaCertificateDescriptor.getInstance(Extensions.getExtensionParsedValue((Extensions)extensions, (ASN1ObjectIdentifier)deltaCertificateDescriptor));
    }

    private DeltaCertificateDescriptor(ASN1Sequence aSN1Sequence) {
        ASN1TaggedObject aSN1TaggedObject;
        ASN1TaggedObject aSN1TaggedObject2;
        ASN1Integer aSN1Integer = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0));
        int n = 1;
        ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(n++);
        AlgorithmIdentifier algorithmIdentifier = null;
        X500Name x500Name = null;
        Validity validity = null;
        X500Name x500Name2 = null;
        while (aSN1Encodable instanceof ASN1TaggedObject) {
            aSN1TaggedObject2 = ASN1TaggedObject.getInstance((Object)aSN1Encodable);
            switch (aSN1TaggedObject2.getTagNo()) {
                case 0: {
                    algorithmIdentifier = AlgorithmIdentifier.getInstance((ASN1TaggedObject)aSN1TaggedObject2, (boolean)true);
                    break;
                }
                case 1: {
                    x500Name = X500Name.getInstance((ASN1TaggedObject)aSN1TaggedObject2, (boolean)true);
                    break;
                }
                case 2: {
                    validity = Validity.getInstance(aSN1TaggedObject2, true);
                    break;
                }
                case 3: {
                    x500Name2 = X500Name.getInstance((ASN1TaggedObject)aSN1TaggedObject2, (boolean)true);
                }
            }
            aSN1Encodable = aSN1Sequence.getObjectAt(n++);
        }
        aSN1TaggedObject2 = SubjectPublicKeyInfo.getInstance((Object)aSN1Encodable);
        aSN1Encodable = aSN1Sequence.getObjectAt(n);
        Extensions extensions = null;
        while (aSN1Encodable instanceof ASN1TaggedObject) {
            aSN1TaggedObject = ASN1TaggedObject.getInstance((Object)aSN1Encodable);
            switch (aSN1TaggedObject.getTagNo()) {
                case 4: {
                    extensions = Extensions.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)true);
                }
            }
            aSN1Encodable = aSN1Sequence.getObjectAt(n++);
        }
        aSN1TaggedObject = DERBitString.getInstance((Object)aSN1Encodable);
        this.serialNumber = aSN1Integer;
        this.signature = algorithmIdentifier;
        this.issuer = x500Name;
        this.validity = validity;
        this.subject = x500Name2;
        this.subjectPublicKeyInfo = aSN1TaggedObject2;
        this.extensions = extensions;
        this.signatureValue = aSN1TaggedObject;
    }

    public DeltaCertificateDescriptor(ASN1Integer aSN1Integer, AlgorithmIdentifier algorithmIdentifier, X500Name x500Name, Validity validity, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo, Extensions extensions, ASN1BitString aSN1BitString) {
        if (aSN1Integer == null) {
            throw new NullPointerException("'serialNumber' cannot be null");
        }
        if (subjectPublicKeyInfo == null) {
            throw new NullPointerException("'subjectPublicKeyInfo' cannot be null");
        }
        if (aSN1BitString == null) {
            throw new NullPointerException("'signatureValue' cannot be null");
        }
        this.serialNumber = aSN1Integer;
        this.signature = algorithmIdentifier;
        this.issuer = x500Name;
        this.validity = validity;
        this.subject = x500Name2;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        this.extensions = extensions;
        this.signatureValue = aSN1BitString;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public ASN1Sequence getValidity() {
        return (ASN1Sequence)this.validity.toASN1Primitive();
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public ASN1BitString getSignatureValue() {
        return this.signatureValue;
    }

    public static DeltaCertificateDescriptor trimDeltaCertificateDescriptor(DeltaCertificateDescriptor deltaCertificateDescriptor, TBSCertificate tBSCertificate, Extensions extensions) {
        ASN1BitString aSN1BitString;
        X500Name x500Name;
        Validity validity;
        X500Name x500Name2;
        ASN1Integer aSN1Integer = deltaCertificateDescriptor.getSerialNumber();
        AlgorithmIdentifier algorithmIdentifier = deltaCertificateDescriptor.getSignature();
        if (algorithmIdentifier != null && algorithmIdentifier.equals((Object)tBSCertificate.getSignature())) {
            algorithmIdentifier = null;
        }
        if ((x500Name2 = deltaCertificateDescriptor.getIssuer()) != null && x500Name2.equals((Object)tBSCertificate.getIssuer())) {
            x500Name2 = null;
        }
        if ((validity = Validity.getInstance(deltaCertificateDescriptor.getValidity())) != null && validity.equals((Object)new Validity(tBSCertificate.getStartDate(), tBSCertificate.getEndDate()))) {
            validity = null;
        }
        if ((x500Name = deltaCertificateDescriptor.getSubject()) != null && x500Name.equals((Object)tBSCertificate.getSubject())) {
            x500Name = null;
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo = deltaCertificateDescriptor.getSubjectPublicKeyInfo();
        Extensions extensions2 = deltaCertificateDescriptor.getExtensions();
        if (extensions2 != null) {
            aSN1BitString = new ExtensionsGenerator();
            Enumeration enumeration = extensions.oids();
            while (enumeration.hasMoreElements()) {
                Extension extension;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                if (DeltaCertificateDescriptor.deltaCertificateDescriptor.equals((ASN1Primitive)aSN1ObjectIdentifier) || (extension = extensions2.getExtension(aSN1ObjectIdentifier)) == null || extension.equals((Object)extensions.getExtension(aSN1ObjectIdentifier))) continue;
                aSN1BitString.addExtension(extension);
            }
            extensions2 = aSN1BitString.isEmpty() ? null : aSN1BitString.generate();
        }
        aSN1BitString = deltaCertificateDescriptor.getSignatureValue();
        return new DeltaCertificateDescriptor(aSN1Integer, algorithmIdentifier, x500Name2, validity, x500Name, subjectPublicKeyInfo, extensions2, aSN1BitString);
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n, boolean bl, ASN1Object aSN1Object) {
        if (aSN1Object != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(bl, n, (ASN1Encodable)aSN1Object));
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(8);
        aSN1EncodableVector.add((ASN1Encodable)this.serialNumber);
        this.addOptional(aSN1EncodableVector, 0, true, (ASN1Object)this.signature);
        this.addOptional(aSN1EncodableVector, 1, true, (ASN1Object)this.issuer);
        this.addOptional(aSN1EncodableVector, 2, true, this.validity);
        this.addOptional(aSN1EncodableVector, 3, true, (ASN1Object)this.subject);
        aSN1EncodableVector.add((ASN1Encodable)this.subjectPublicKeyInfo);
        this.addOptional(aSN1EncodableVector, 4, true, (ASN1Object)this.extensions);
        aSN1EncodableVector.add((ASN1Encodable)this.signatureValue);
        return new DERSequence(aSN1EncodableVector);
    }
}

