/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mail.pgp.dao;

import com.inet.annotations.InternalApi;
import com.inet.mail.api.BaseEmail;
import com.inet.mail.pgp.a;
import com.inet.plugin.ServerPluginManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

@InternalApi
public interface KeyDataAccessor {
    @Nullable
    public String getPublicKey(String var1);

    public void putPublicKey(String var1, String var2);

    public void removePublicKey(String var1);

    public boolean containsPublicKeyForIdentifier(String var1);

    public PGPSecretKeyRingCollection getPrivateKeyRing() throws IOException, PGPException;

    public void putPrivateKey(String var1, String var2) throws IOException;

    public List<com.inet.mail.smime.a> getPublicKeyInfos();

    public List<com.inet.mail.smime.a> getPrivateKeyInfos();

    public void removePrivateKey(String var1);

    public void storePrivateKeyPassphrase(long var1, String var3);

    public static void migrateFromOldKeyRing(String serializedKeyRing) {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = null;
        try {
            KeyDataAccessor keyDataAccessor = (KeyDataAccessor)ServerPluginManager.getInstance().getSingleInstance(KeyDataAccessor.class);
            pGPSecretKeyRingCollection = a.k(serializedKeyRing);
            com.inet.mail.pgp.dao.a.b(pGPSecretKeyRingCollection);
            Iterator iterator = pGPSecretKeyRingCollection.getKeyRings();
            while (iterator.hasNext()) {
                PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
                PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey();
                PBESecretKeyDecryptor pBESecretKeyDecryptor = new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().build()).setProvider(com.inet.mail.a.a()).build("".toCharArray());
                PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(pBESecretKeyDecryptor);
                Iterator iterator2 = pGPSecretKeyRing.getSecretKeys();
                while (iterator2.hasNext()) {
                    PGPSecretKey pGPSecretKey2 = (PGPSecretKey)iterator2.next();
                    long l = pGPSecretKey2.getKeyID();
                    keyDataAccessor.storePrivateKeyPassphrase(l, "");
                }
            }
        }
        catch (Exception exception) {
            BaseEmail.LOGGER.error((Throwable)exception);
        }
    }
}

