/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mail.api;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.http.security.TrustAllTrustManager;
import com.inet.id.GUID;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.JavaLogHandler;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.mail.api.MailAuthenticationMethod;
import com.inet.mail.api.MailDataSource;
import com.inet.mail.api.MailEncryption;
import com.inet.mail.api.processor.OutMailProcessor;
import com.inet.mail.api.profiles.MailProfile;
import com.inet.oauth.connection.api.token.OauthAccessTokenManager;
import com.inet.plugin.ServerPluginManager;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManager;
import org.eclipse.angus.mail.util.MailSSLSocketFactory;

@InternalApi
public abstract class BaseEmail
implements Runnable {
    protected static final ConfigValue<String> PROPERTY_SMTP_HOST = new ConfigValue(ConfigKey.MAIL_SMTPHOST);
    protected static final ConfigValue<Integer> PROPERTY_SMTP_PORT = new ConfigValue(ConfigKey.MAIL_SMTPPORT);
    protected static final ConfigValue<String> PROPERTY_POP3_HOST = new ConfigValue(ConfigKey.MAIL_POP3HOST);
    protected static final ConfigValue<Integer> PROPERTY_POP3_PORT = new ConfigValue(ConfigKey.MAIL_POP3PORT);
    protected static final ConfigValue<MailAuthenticationMethod> PROPERTY_EMAIL_AUTHENTICATION = new ConfigValue<MailAuthenticationMethod>(ConfigKey.MAIL_AUTHENTICATION){

        protected MailAuthenticationMethod c(@Nonnull String string) throws IllegalArgumentException {
            Object object = super.convert(string);
            return MailAuthenticationMethod.fromID((Integer)object);
        }

        protected /* synthetic */ Object convert(@Nonnull String string) throws IllegalArgumentException {
            return this.c(string);
        }
    };
    protected static final ConfigValue<String> PROPERTY_USER = new ConfigValue(ConfigKey.MAIL_USER);
    protected static final ConfigValue<MailEncryption> PROPERTY_MAIL_ENCRYPTION = new ConfigValue<MailEncryption>(ConfigKey.MAIL_ENCRYPTION){

        protected MailEncryption d(@Nonnull String string) throws IllegalArgumentException {
            return MailEncryption.valueOfImpl(string);
        }

        protected /* synthetic */ Object convert(@Nonnull String string) throws IllegalArgumentException {
            return this.d(string);
        }
    };
    protected static final ConfigValue<String> PROPERTY_PASSWORD = new ConfigValue<String>(ConfigKey.MAIL_PASSWORD){

        protected String e(@Nonnull String string) throws IllegalArgumentException {
            return Encryption.decrypt((String)string);
        }

        protected /* synthetic */ Object convert(@Nonnull String string) throws IllegalArgumentException {
            return this.e(string);
        }
    };
    protected static final ConfigValue<InternetAddress> PROPERTY_SENDER = new ConfigValue<InternetAddress>(ConfigKey.MAIL_SENDER){

        protected InternetAddress f(@Nonnull String string) throws IllegalArgumentException {
            InternetAddress[] internetAddressArray = BaseEmail.getAddresses(string, LogManager.getConfigLogger());
            return internetAddressArray != null && internetAddressArray.length > 0 ? internetAddressArray[0] : null;
        }

        protected /* synthetic */ Object convert(@Nonnull String string) throws IllegalArgumentException {
            return this.f(string);
        }
    };
    private static final ConfigValue<Boolean> l = new ConfigValue(ConfigKey.MAIL_PUBLIC_EHLO);
    protected static final ConfigValue<String> SERVER_NAME = new ConfigValue<String>(ConfigKey.SERVER_URL){

        protected String e(@Nonnull String string) throws IllegalArgumentException {
            try {
                return new URL(string).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                return "";
            }
        }

        protected /* synthetic */ Object convert(@Nonnull String string) throws IllegalArgumentException {
            return this.e(string);
        }
    };
    private static final ConfigValue<String> m = new ConfigValue(com.inet.mail.structure.a.aM);
    public static final Logger LOGGER = LogManager.getLogger((String)"Mail");
    private static List<@Nonnull OutMailProcessor> n;

    protected static InternetAddress[] getAddresses(String recipient, Logger logger) {
        if (recipient == null || recipient.trim().length() == 0) {
            return new InternetAddress[0];
        }
        ArrayList<InternetAddress> arrayList = new ArrayList<InternetAddress>();
        StringTokenizer stringTokenizer = new StringTokenizer(recipient, ";");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                arrayList.add(new InternetAddress(stringTokenizer.nextToken()));
            }
            catch (AddressException addressException) {
                logger.error((Throwable)addressException);
            }
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        return arrayList.toArray(new InternetAddress[n]);
    }

    public static boolean isSmtpConfigured() {
        return MailProfile.getProfile() != null || !StringFunctions.isEmpty((String)((String)PROPERTY_SMTP_HOST.get()));
    }

    @Override
    public void run() {
        try {
            this.send();
        }
        catch (Throwable throwable) {
            this.getLogger().error(throwable);
        }
    }

    public void send(InternetAddress absender) throws MessagingException {
        MailProfile mailProfile = MailProfile.getProfile();
        if (mailProfile != null) {
            Consumer<String> consumer = string -> ConfigurationManager.getInstance().getCurrent().put(com.inet.mail.structure.a.aM, string);
            this.send(absender, mailProfile, (InternetAddress)PROPERTY_SENDER.get(), (String)m.get(), consumer);
        } else {
            this.send((String)PROPERTY_SMTP_HOST.get(), ((Integer)PROPERTY_SMTP_PORT.get()).toString(), (String)PROPERTY_POP3_HOST.get(), ((Integer)PROPERTY_POP3_PORT.get()).toString(), (MailAuthenticationMethod)((Object)PROPERTY_EMAIL_AUTHENTICATION.get()), (MailEncryption)((Object)PROPERTY_MAIL_ENCRYPTION.get()), (String)PROPERTY_USER.get(), (String)PROPERTY_PASSWORD.get(), absender);
        }
    }

    protected void send(@Nonnull InternetAddress orignalAbsender, @Nonnull MailProfile sendProfile, @Nullable InternetAddress emailSender, @Nonnull String currentRefreshToken, @Nonnull @Nonnull Consumer<@Nonnull String> refreshTokenUpdateCallback) throws MessagingException {
        String string2 = emailSender != null ? emailSender.getAddress() : null;
        Consumer<String> consumer = string -> ConfigurationManager.getInstance().getCurrent().put(com.inet.mail.structure.a.aM, string);
        String string3 = OauthAccessTokenManager.getAccessToken((String)sendProfile.getOauthProvider(), (String)((String)m.get()), consumer);
        this.send(sendProfile.getSmtpHost(), sendProfile.getSmtpPort(), null, null, sendProfile.getAuthenticationMethod(), sendProfile.getSmtpEncryption(), string2, string3, orignalAbsender);
    }

    public void send() throws MessagingException {
        InternetAddress internetAddress = (InternetAddress)PROPERTY_SENDER.get();
        InternetAddress internetAddress2 = null;
        try {
            internetAddress2 = internetAddress == null ? null : new InternetAddress(internetAddress.getAddress(), internetAddress.getPersonal());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            internetAddress2 = null;
        }
        this.send(internetAddress2);
    }

    protected String getEHLOServerName() {
        String string = (String)SERVER_NAME.get();
        if (((Boolean)l.get()).booleanValue()) {
            string = CoreSystemStructureProvider.getPublicDomain();
        }
        return string;
    }

    protected Object send(String host, String port, String pop3Host, String pop3Port, MailAuthenticationMethod authMode, MailEncryption encryption, String user, String password, InternetAddress sender) throws MessagingException {
        MimeMessage mimeMessage;
        MailSSLSocketFactory mailSSLSocketFactory;
        Properties properties;
        block22: {
            Thread.currentThread().setContextClassLoader(BaseEmail.class.getClassLoader());
            properties = new Properties();
            if (port == null || port.isEmpty()) {
                port = "25";
            }
            properties.setProperty("mail.smtp.host", host);
            properties.setProperty("mail.smtp.port", port);
            properties.setProperty("mail.smtp.connectiontimeout", "60000");
            String string = this.getEHLOServerName();
            properties.setProperty("mail.smtp.localhost", string);
            properties.setProperty("mail.smtp.timeout", "600000");
            if (pop3Host != null) {
                properties.setProperty("mail.pop3.host", pop3Host);
            }
            if (pop3Port != null) {
                properties.setProperty("mail.pop3.port", pop3Port);
            }
            if (authMode == MailAuthenticationMethod.SMTP || authMode == MailAuthenticationMethod.POP3_AND_SMTP) {
                properties.setProperty("mail.smtp.auth", "true");
            } else if (authMode == MailAuthenticationMethod.XOAUTH2) {
                properties.put("mail.smtp.auth.mechanisms", "XOAUTH2");
            }
            try {
                mailSSLSocketFactory = new MailSSLSocketFactory();
                mailSSLSocketFactory.setTrustAllHosts(true);
                mailSSLSocketFactory.setTrustManagers(new TrustManager[]{new TrustAllTrustManager()});
                properties.put("mail.smtp.ssl.socketFactory", mailSSLSocketFactory);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (!LOGGER.isError()) break block22;
                LOGGER.error((Throwable)generalSecurityException);
            }
        }
        switch (encryption) {
            case STARTTLS: {
                properties.put("mail.smtp.starttls.enable", "true");
                break;
            }
            case SSL: {
                properties.put("mail.smtp.ssl.enable", "true");
                break;
            }
            default: {
                properties.remove("mail.smtp.ssl.enable");
                properties.remove("mail.smtp.starttls.enable");
            }
        }
        if (LoginProcessor.LOGGER.isDebug()) {
            properties.put("mail.debug.auth", "true");
        }
        mailSSLSocketFactory = Session.getInstance((Properties)properties, null);
        if (authMode == MailAuthenticationMethod.POP3 || authMode == MailAuthenticationMethod.POP3_AND_SMTP) {
            try {
                if (pop3Host != null && pop3Host.trim().length() > 0) {
                    mimeMessage = mailSSLSocketFactory.getStore("pop3");
                    mimeMessage.connect(user, password);
                }
            }
            catch (Throwable throwable) {
                this.getLogger().debug((Object)throwable);
            }
        }
        mimeMessage = this.a((Session)mailSSLSocketFactory, sender);
        Transport transport = mailSSLSocketFactory.getTransport("smtp");
        try {
            if (authMode == MailAuthenticationMethod.NONE) {
                transport.connect();
            } else {
                transport.connect(user, password);
            }
        }
        catch (AuthenticationFailedException authenticationFailedException) {
            this.authenticationFailedHook(authenticationFailedException, transport, (Session)mailSSLSocketFactory, properties);
        }
        Collection<MimeMessage> collection = this.willSend(mimeMessage);
        for (MimeMessage mimeMessage2 : collection) {
            transport.sendMessage((Message)mimeMessage2, mimeMessage2.getAllRecipients());
        }
        transport.close();
        return null;
    }

    private MimeMessage a(Session session, InternetAddress internetAddress) throws MessagingException {
        Properties properties;
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setSentDate(new Date());
        mimeMessage.setSubject(this.getSubject(), "UTF-8");
        if (internetAddress != null) {
            mimeMessage.setFrom((Address)internetAddress);
        }
        mimeMessage.addRecipients(Message.RecipientType.TO, (Address[])this.getTo());
        InternetAddress[] internetAddressArray = this.getCc();
        if (internetAddressArray != null) {
            mimeMessage.addRecipients(Message.RecipientType.CC, (Address[])internetAddressArray);
        }
        if ((internetAddressArray = this.getBcc()) != null) {
            mimeMessage.addRecipients(Message.RecipientType.BCC, (Address[])internetAddressArray);
        }
        if ((properties = this.getHeaders()) != null) {
            for (Map.Entry object2 : properties.entrySet()) {
                mimeMessage.setHeader((String)object2.getKey(), (String)object2.getValue());
            }
        }
        MimeMultipart mimeMultipart = new MimeMultipart();
        MailDataSource[] mailDataSourceArray = this.getFiles();
        if (mailDataSourceArray != null && mailDataSourceArray.length > 0) {
            switch (a.a(mailDataSourceArray)) {
                case r: {
                    mimeMultipart = new MimeMultipart("mixed");
                    this.a((Multipart)mimeMultipart);
                    this.b((Multipart)mimeMultipart, mailDataSourceArray);
                    break;
                }
                case s: {
                    mimeMultipart = new MimeMultipart("mixed");
                    this.a((Multipart)mimeMultipart, mailDataSourceArray);
                    this.b((Multipart)mimeMultipart, mailDataSourceArray);
                    break;
                }
                case q: {
                    mimeMultipart = new MimeMultipart("related");
                    this.a((Multipart)mimeMultipart);
                    this.c((Multipart)mimeMultipart, mailDataSourceArray);
                    break;
                }
            }
        } else {
            this.a((Multipart)mimeMultipart);
        }
        mimeMessage.setContent((Multipart)mimeMultipart);
        mimeMessage.saveChanges();
        return mimeMessage;
    }

    private void a(Multipart multipart, MailDataSource[] mailDataSourceArray) throws MessagingException {
        MimeMultipart mimeMultipart = new MimeMultipart("related");
        this.a((Multipart)mimeMultipart);
        this.c((Multipart)mimeMultipart, mailDataSourceArray);
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Multipart)mimeMultipart);
        multipart.addBodyPart((BodyPart)mimeBodyPart);
    }

    private void b(Multipart multipart, MailDataSource[] mailDataSourceArray) throws MessagingException {
        for (MailDataSource mailDataSource : mailDataSourceArray) {
            if (mailDataSource.isInlined()) continue;
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)mailDataSource));
            mimeBodyPart.setFileName(mailDataSource.getName());
            mimeBodyPart.setDisposition("attachment");
            multipart.addBodyPart((BodyPart)mimeBodyPart);
        }
    }

    private void c(Multipart multipart, MailDataSource[] mailDataSourceArray) throws MessagingException {
        for (MailDataSource mailDataSource : mailDataSourceArray) {
            if (!mailDataSource.isInlined()) continue;
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)mailDataSource));
            String string = mailDataSource.getName();
            if (StringFunctions.isEmpty((String)string)) {
                string = GUID.generateNew().toString();
            }
            mimeBodyPart.setFileName(string);
            mimeBodyPart.setDisposition("inline");
            multipart.addBodyPart((BodyPart)mimeBodyPart);
            String string2 = mailDataSource.getCID();
            mimeBodyPart.setContentID("<" + string2 + ">");
            mimeBodyPart.addHeader("X-Attachment-Id", string2);
        }
    }

    private void a(Multipart multipart) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(this.getMessage(), "UTF-8", this.getMessageMime());
        multipart.addBodyPart((BodyPart)mimeBodyPart);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected Collection<MimeMessage> willSend(MimeMessage m) throws MessagingException {
        OutMailProcessor outMailProcessor;
        ArrayList<MimeMessage> arrayList = new ArrayList<MimeMessage>();
        @Nonnull List list = n;
        if (list == null) {
            n = list = ServerPluginManager.getInstance().get(OutMailProcessor.class);
        }
        Iterator<OutMailProcessor> iterator = list.iterator();
        while (iterator.hasNext() && (m = (outMailProcessor = iterator.next()).process(m, arrayList)) != null) {
        }
        if (m != null) {
            arrayList.add(m);
        }
        return arrayList;
    }

    protected Object authenticationFailedHook(AuthenticationFailedException afe, Transport transport, Session session, Properties props) throws AuthenticationFailedException {
        throw afe;
    }

    protected abstract String getSubject() throws MessagingException;

    protected abstract InternetAddress[] getTo() throws MessagingException;

    @Nullable
    protected InternetAddress[] getCc() throws MessagingException {
        return null;
    }

    @Nullable
    protected InternetAddress[] getBcc() throws MessagingException {
        return null;
    }

    @Nullable
    protected Properties getHeaders() {
        return null;
    }

    protected abstract String getMessage() throws MessagingException;

    @Nonnull
    protected String getMessageMime() throws MessagingException {
        return "HTML";
    }

    @Nullable
    protected MailDataSource[] getFiles() throws MessagingException {
        return null;
    }

    @Nonnull
    protected abstract Logger getLogger();

    public static String encodeMIMEText(String text) {
        try {
            text = EncodingFunctions.encodeUrlPath((String)text);
            text = MimeUtility.encodeText((String)text, (String)"UTF-8", null);
        }
        catch (Exception exception) {
            LogManager.getConfigLogger().error((Throwable)exception);
        }
        return text;
    }

    static {
        new JavaLogHandler("com.sun.mail", LOGGER);
        new JavaLogHandler("javax.mail", LOGGER);
        new JavaLogHandler("jakarta.mail", LOGGER);
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a q = new a();
        public static final /* enum */ a r = new a();
        public static final /* enum */ a s = new a();
        private static final /* synthetic */ a[] t;

        public static a[] values() {
            return (a[])t.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        public static a a(MailDataSource[] mailDataSourceArray) {
            if (mailDataSourceArray == null) {
                throw new IllegalArgumentException("given array of attachments must not be null");
            }
            int n = a.b(mailDataSourceArray);
            if (n == 0) {
                return r;
            }
            if (n == mailDataSourceArray.length) {
                return q;
            }
            return s;
        }

        private static int b(MailDataSource[] mailDataSourceArray) {
            int n = 0;
            for (MailDataSource mailDataSource : mailDataSourceArray) {
                if (!mailDataSource.isInlined()) continue;
                ++n;
            }
            return n;
        }

        private static /* synthetic */ a[] b() {
            return new a[]{q, r, s};
        }

        static {
            t = a.b();
        }
    }
}

