/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mail.pgp.dao;

import com.inet.mail.api.BaseEmail;
import com.inet.mail.pgp.dao.KeyDataAccessor;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.util.encoders.Hex;

@SuppressFBWarnings(value={"HARD_CODE_KEY"}, justification="key used only for obfuscation")
public class a
implements KeyDataAccessor {
    @Nonnull
    public static PersistenceEntry a(boolean bl) {
        return Persistence.getInstance().resolve(bl ? "/pgp/public" : "/pgp/private");
    }

    @Override
    @Nullable
    public String getPublicKey(String identifier) {
        PersistenceEntry persistenceEntry = a.a(true).resolve(a.l(identifier));
        return persistenceEntry.getString();
    }

    @Override
    public void putPublicKey(String identifier, String key) {
        PersistenceEntry persistenceEntry = a.a(true).resolve(a.l(identifier));
        persistenceEntry.setString(key);
    }

    @Override
    public void removePublicKey(String identifier) {
        PersistenceEntry persistenceEntry = a.a(true).resolve(a.l(identifier));
        persistenceEntry.deleteValue();
    }

    @Override
    public boolean containsPublicKeyForIdentifier(String identifier) {
        PersistenceEntry persistenceEntry = a.a(true).resolve(a.l(identifier));
        return persistenceEntry.exists();
    }

    @Nonnull
    private static String l(@Nonnull String string) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(string.toLowerCase().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public PGPSecretKeyRingCollection getPrivateKeyRing() throws IOException, PGPException {
        PersistenceEntry persistenceEntry = a.a(false);
        PersistenceEntry persistenceEntry2 = persistenceEntry.resolve("keyring");
        if (!persistenceEntry2.exists()) {
            return new PGPSecretKeyRingCollection((Collection)Collections.EMPTY_LIST);
        }
        PersistenceEntry persistenceEntry3 = persistenceEntry2.getCryptoInstance("keyring".toCharArray(), "keyring".getBytes(StandardCharsets.UTF_8));
        byte[] byArray = persistenceEntry3.getBytes();
        return new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(byArray)), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
    }

    @Override
    public void putPrivateKey(String key, String passphrase) throws IOException {
        try {
            PGPSecretKeyRingCollection pGPSecretKeyRingCollection = this.getPrivateKeyRing();
            PGPSecretKeyRingCollection pGPSecretKeyRingCollection2 = com.inet.mail.pgp.a.k(key);
            Iterator iterator = pGPSecretKeyRingCollection2.getKeyRings();
            IllegalArgumentException illegalArgumentException = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                try {
                    PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
                    PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey();
                    PBESecretKeyDecryptor pBESecretKeyDecryptor = new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().build()).build(passphrase.toCharArray());
                    PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(pBESecretKeyDecryptor);
                    Iterator iterator2 = pGPSecretKeyRing.getSecretKeys();
                    while (iterator2.hasNext()) {
                        PGPSecretKey pGPSecretKey2 = (PGPSecretKey)iterator2.next();
                        long l = pGPSecretKey2.getKeyID();
                        this.storePrivateKeyPassphrase(l, passphrase);
                    }
                    pGPSecretKeyRingCollection = PGPSecretKeyRingCollection.addSecretKeyRing((PGPSecretKeyRingCollection)pGPSecretKeyRingCollection, (PGPSecretKeyRing)pGPSecretKeyRing);
                    bl = true;
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    illegalArgumentException = illegalArgumentException2;
                }
            }
            if (!bl) {
                throw illegalArgumentException != null ? illegalArgumentException : new IllegalArgumentException("Not a PGP key");
            }
            a.b(pGPSecretKeyRingCollection);
        }
        catch (PGPException pGPException) {
            throw new IOException(pGPException);
        }
    }

    static void b(PGPSecretKeyRingCollection pGPSecretKeyRingCollection) throws IOException {
        String string = com.inet.mail.pgp.a.a(pGPSecretKeyRingCollection);
        PersistenceEntry persistenceEntry = a.a(false).resolve("keyring");
        PersistenceEntry persistenceEntry2 = persistenceEntry.getCryptoInstance("keyring".toCharArray(), "keyring".getBytes(StandardCharsets.UTF_8));
        persistenceEntry2.setString(string);
    }

    @Override
    public void storePrivateKeyPassphrase(long keyID, String passphrase) {
        PersistenceEntry persistenceEntry = a.a(false).resolve("" + keyID);
        PersistenceEntry persistenceEntry2 = persistenceEntry.getCryptoInstance(("" + keyID / 13L).toCharArray(), ("" + keyID / 17L).getBytes(StandardCharsets.UTF_8));
        persistenceEntry2.setString(passphrase);
    }

    @Override
    public List<com.inet.mail.smime.a> getPublicKeyInfos() {
        PersistenceEntry persistenceEntry2 = a.a(true);
        return persistenceEntry2.getChildren().stream().map(persistenceEntry -> {
            String string = persistenceEntry.getString();
            if (string == null) {
                return null;
            }
            try {
                PGPPublicKey pGPPublicKey = com.inet.mail.pgp.a.j(string);
                String string2 = persistenceEntry.getName();
                String string3 = a.m(string2);
                long l = com.inet.mail.pgp.a.c(string, string3);
                return new com.inet.mail.smime.a(string3, l, Hex.toHexString((byte[])pGPPublicKey.getFingerprint()));
            }
            catch (Exception exception) {
                return null;
            }
        }).filter(a2 -> a2 != null).collect(Collectors.toList());
    }

    private static String m(String string) {
        byte[] byArray = Base64.getUrlDecoder().decode(string);
        String string2 = new String(byArray, StandardCharsets.UTF_8);
        return string2;
    }

    @Override
    public List<com.inet.mail.smime.a> getPrivateKeyInfos() {
        ArrayList<com.inet.mail.smime.a> arrayList = new ArrayList<com.inet.mail.smime.a>();
        try {
            PGPSecretKeyRingCollection pGPSecretKeyRingCollection = this.getPrivateKeyRing();
            Iterator iterator = pGPSecretKeyRingCollection.getKeyRings();
            while (iterator.hasNext()) {
                PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
                Iterator iterator2 = pGPSecretKeyRing.getSecretKeys();
                while (iterator2.hasNext()) {
                    PGPSecretKey pGPSecretKey = (PGPSecretKey)iterator2.next();
                    Iterator iterator3 = pGPSecretKey.getUserIDs();
                    while (iterator3.hasNext()) {
                        String string = (String)iterator3.next();
                        PGPPublicKey pGPPublicKey = pGPSecretKey.getPublicKey();
                        arrayList.add(new com.inet.mail.smime.a(string, pGPPublicKey.getCreationTime().getTime() + pGPPublicKey.getValidSeconds() * 1000L, Hex.toHexString((byte[])pGPPublicKey.getFingerprint())));
                    }
                }
            }
        }
        catch (Exception exception) {
            return new ArrayList<com.inet.mail.smime.a>();
        }
        return arrayList;
    }

    @Override
    public void removePrivateKey(String address) {
        try {
            PGPSecretKeyRingCollection pGPSecretKeyRingCollection = this.getPrivateKeyRing();
            Iterator iterator = pGPSecretKeyRingCollection.getKeyRings();
            while (iterator.hasNext()) {
                PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
                Iterator iterator2 = pGPSecretKeyRing.getSecretKeys();
                while (iterator2.hasNext()) {
                    PGPSecretKey pGPSecretKey = (PGPSecretKey)iterator2.next();
                    Iterator iterator3 = pGPSecretKey.getUserIDs();
                    while (iterator3.hasNext()) {
                        if (!address.equalsIgnoreCase((String)iterator3.next())) continue;
                        PGPSecretKeyRingCollection pGPSecretKeyRingCollection2 = PGPSecretKeyRingCollection.removeSecretKeyRing((PGPSecretKeyRingCollection)pGPSecretKeyRingCollection, (PGPSecretKeyRing)pGPSecretKeyRing);
                        a.b(pGPSecretKeyRingCollection2);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            BaseEmail.LOGGER.error((Throwable)exception);
        }
    }
}

