/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class FixedEntropySourceProvider
implements EntropySourceProvider {
    private final byte[] data;
    private final boolean isPredictionResistant;

    protected FixedEntropySourceProvider(byte[] byArray, boolean bl) {
        this.data = byArray;
        this.isPredictionResistant = bl;
    }

    @Override
    public EntropySource get(final int n) {
        return new EntropySource(){
            int index = 0;

            @Override
            public boolean isPredictionResistant() {
                return FixedEntropySourceProvider.this.isPredictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                byte[] byArray = new byte[(n + 7) / 8];
                System.arraycopy(FixedEntropySourceProvider.this.data, this.index, byArray, 0, byArray.length);
                this.index += (n + 7) / 8;
                return byArray;
            }

            @Override
            public int entropySize() {
                return n;
            }
        };
    }
}

