/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mail.pgp.processor;

import com.inet.lib.util.IOFunctions;
import com.inet.mail.api.BaseEmail;
import com.inet.mail.api.MailAttachmentUtilities;
import com.inet.mail.api.PGPPublicKeyFoundListener;
import com.inet.mail.api.PartHandler;
import com.inet.mail.api.processor.InMailProcessor;
import com.inet.mail.pgp.dao.KeyDataAccessor;
import com.inet.mail.pgp.shared.b;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;

public class a
implements InMailProcessor {
    private PGPSecretKeyRingCollection am;
    private KeyDataAccessor an;
    private Charset ao = Charset.forName("US-ASCII");
    private long ap;
    private Set<String> aq = new HashSet<String>();

    public a() {
        this.aq.add("pgp");
        this.aq.add("gpg");
    }

    public void a(KeyDataAccessor keyDataAccessor) {
        this.an = keyDataAccessor;
    }

    @Override
    public Message process(Message mail) {
        try {
            if (this.an == null) {
                return mail;
            }
            Message message = this.a(mail);
            try {
                this.b(message);
            }
            catch (SQLException sQLException) {
                BaseEmail.LOGGER.error((Throwable)sQLException);
            }
            return message;
        }
        catch (Throwable throwable) {
            BaseEmail.LOGGER.error(throwable);
            return mail;
        }
    }

    Message a(Message message) throws MessagingException, IOException, PGPException {
        Object object;
        String string = this.b((Part)message);
        if (string.equalsIgnoreCase("multipart/encrypted")) {
            Object object2 = message.getContent();
            if (object2 instanceof Multipart) {
                MimeBodyPart mimeBodyPart = this.b((Multipart)object2);
                MimeMessage mimeMessage = this.a(message, message.getSession());
                Multipart multipart = (Multipart)mimeBodyPart.getContent();
                mimeMessage.setContent((Object)multipart, mimeBodyPart.getContentType());
                this.a(mimeMessage, (BodyPart)mimeBodyPart);
                mimeMessage.saveChanges();
                if (BaseEmail.LOGGER.isInfo()) {
                    BaseEmail.LOGGER.info((Object)("PGPPlugin: Decrypted PGP/MIME mail from " + String.valueOf(message.getHeader("From"))));
                }
                return mimeMessage;
            }
        } else if (string.equalsIgnoreCase("text/plain")) {
            String string2;
            int n;
            Object object3 = message.getContent();
            if (object3 instanceof String && (n = (string2 = (String)object3).indexOf("-----BEGIN PGP MESSAGE-----")) != -1) {
                byte[] byArray = this.a(new ByteArrayInputStream(string2.getBytes(this.ao)));
                MimeMessage mimeMessage = this.a(message, message.getSession());
                mimeMessage.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(byArray, message.getContentType())));
                if (BaseEmail.LOGGER.isInfo()) {
                    BaseEmail.LOGGER.info((Object)("PGPPlugin: Decrypted Inline PGP mail from " + String.valueOf(Arrays.asList(message.getHeader("From")))));
                }
                return mimeMessage;
            }
        } else if (string.equalsIgnoreCase("multipart/mixed") && (object = message.getContent()) instanceof Multipart) {
            String string3;
            Multipart multipart = (Multipart)object;
            boolean bl = false;
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                string3 = this.b((Part)bodyPart);
                if (string3.equals("text/plain")) {
                    if (!String.valueOf(bodyPart.getContent()).contains("-----BEGIN PGP MESSAGE-----")) continue;
                    bl = true;
                    break;
                }
                if (!this.aq.contains(this.n(bodyPart.getFileName()))) continue;
                bl = true;
                break;
            }
            if (bl) {
                MimeMultipart mimeMultipart = new MimeMultipart();
                for (int i = 0; i < n; ++i) {
                    string3 = multipart.getBodyPart(i);
                    Object object4 = string3.getContent();
                    String string4 = this.b((Part)string3);
                    if (string4.equals("text/plain") && object4 instanceof String) {
                        var12_24 = (String)object4;
                        int n2 = ((String)var12_24).indexOf("-----BEGIN PGP MESSAGE-----");
                        if (n2 != -1) {
                            byte[] byArray = this.a(new ByteArrayInputStream(((String)var12_24).getBytes(this.ao)));
                            string3 = new MimeBodyPart();
                            string3.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(byArray, string4)));
                        }
                    } else if (this.aq.contains(this.n(string3.getFileName()))) {
                        try {
                            var12_24 = this.a(string3.getInputStream());
                            String string5 = string3.getFileName();
                            string3 = new MimeBodyPart();
                            string3.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource((byte[])var12_24, string4)));
                            string3.setFileName(string5.substring(0, string5.length() - 4));
                        }
                        catch (PGPException pGPException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    mimeMultipart.addBodyPart((BodyPart)string3);
                }
                MimeMessage mimeMessage = this.a(message, message.getSession());
                mimeMessage.setContent((Multipart)mimeMultipart);
                mimeMessage.saveChanges();
                if (BaseEmail.LOGGER.isInfo()) {
                    BaseEmail.LOGGER.info((Object)("PGPPlugin: Decrypted Inline/Attachment PGP mail from " + String.valueOf(Arrays.asList(message.getHeader("From")))));
                }
                return mimeMessage;
            }
        }
        return message;
    }

    private void a(MimeMessage mimeMessage, BodyPart bodyPart) throws MessagingException, IOException {
        Header header;
        Enumeration enumeration = bodyPart.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            header = (Header)enumeration.nextElement();
            mimeMessage.setHeader(header.getName(), header.getValue());
        }
        header = (Multipart)bodyPart.getContent();
        for (int i = 0; i < header.getCount(); ++i) {
            BodyPart bodyPart2 = header.getBodyPart(i);
            if (!bodyPart2.getContentType().contains("multipart/mixed")) continue;
            enumeration = bodyPart2.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header2 = (Header)enumeration.nextElement();
                mimeMessage.setHeader(header2.getName(), header2.getValue());
            }
        }
    }

    private String b(Part part) throws MessagingException {
        String string = part.getContentType();
        if (string == null) {
            return "text/plain";
        }
        return new ContentType(string).getBaseType();
    }

    public void b(Message message) throws Exception, SQLException {
        Address[] addressArray = message.getFrom();
        if (addressArray != null && addressArray.length == 1 && addressArray[0] instanceof InternetAddress) {
            String string = ((InternetAddress)addressArray[0]).getAddress();
            ArrayList<PartHandler> arrayList = new ArrayList<PartHandler>();
            MailAttachmentUtilities.fetchParts((Part)message, arrayList, false);
            for (PartHandler partHandler : arrayList) {
                this.a(string, partHandler.getPart(), message.getAllRecipients());
            }
        }
    }

    private void a(String string, Part part, Address[] addressArray) throws IOException, MessagingException, SQLException {
        block12: {
            String string2 = this.b(part).toLowerCase();
            String string3 = this.n(part.getFileName());
            if (part.getSize() > 262144) {
                if (BaseEmail.LOGGER.isDebug()) {
                    BaseEmail.LOGGER.debug((Object)("PGPPlugin: Public key extraction skipped for mail part due to size (" + part.getSize() + ")"));
                }
                return;
            }
            if (string2.equals("text/plain") || string2.equals("application/pgp-keys") || !string2.equals("application/pgp-signature") && (string3.equals("asc") || string3.equals("pgp") || string3.equals("gpg"))) {
                Object object;
                Object object2 = part.getContent();
                InputStream inputStream = null;
                if (object2 instanceof String) {
                    object = object2.toString();
                    int n = ((String)object).indexOf("-----BEGIN PGP PUBLIC KEY BLOCK-----");
                    if (n == -1) {
                        return;
                    }
                    inputStream = new ByteArrayInputStream(((String)object).substring(n).getBytes());
                } else {
                    inputStream = part.getInputStream();
                }
                try {
                    Object object3;
                    Object object4;
                    Object object5;
                    object = PGPUtil.getDecoderStream((InputStream)inputStream);
                    PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection((InputStream)object, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream((OutputStream)byteArrayOutputStream);
                    pGPPublicKeyRingCollection.encode((OutputStream)armoredOutputStream);
                    armoredOutputStream.close();
                    Iterator iterator = pGPPublicKeyRingCollection.iterator();
                    if (iterator.hasNext() && (object5 = ((PGPPublicKeyRing)iterator.next()).getPublicKey()) != null && (object4 = object5.getUserIDs()).hasNext() && ((String)(object3 = (String)object4.next())).matches("^.*<[^>]+>$")) {
                        string = ((String)object3).substring(((String)object3).lastIndexOf("<") + 1, ((String)object3).length() - 1);
                    }
                    object5 = this.an.getPublicKey(string);
                    object4 = new String(byteArrayOutputStream.toByteArray());
                    this.an.putPublicKey(string, (String)object4);
                    if (!((String)object4).equalsIgnoreCase((String)object5)) {
                        BaseEmail.LOGGER.info((Object)("PGPPlugin: Found a new public key for " + string));
                        object3 = ServerPluginManager.getInstance().get(PGPPublicKeyFoundListener.class);
                        String string4 = string;
                        object3.forEach(pGPPublicKeyFoundListener -> pGPPublicKeyFoundListener.foundPublicKey(addressArray, string4));
                        break block12;
                    }
                    BaseEmail.LOGGER.info((Object)("PGPPlugin: Found already known public key for " + string));
                }
                catch (PGPException pGPException) {
                    BaseEmail.LOGGER.error((Object)("PGPPlugin: Failure during public key extraction for " + string + ", mime-type: " + string2 + ", suffix: " + string3));
                    BaseEmail.LOGGER.error((Throwable)pGPException);
                }
            } else if (BaseEmail.LOGGER.isDebug()) {
                BaseEmail.LOGGER.debug((Object)("PGPPlugin: Public key extraction skipped for mail part, mime-type: " + string2 + ", suffix: " + string3));
            }
        }
    }

    private String n(@Nullable String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(n + 1).toLowerCase();
        }
        return "";
    }

    @SuppressFBWarnings(value={"SMTP_HEADER_INJECTION"}, justification="An internal copy of the message is created here. Since the original message is duplicated, no additional injection can take place.")
    private MimeMessage a(Message message, Session session) throws MessagingException {
        b b2 = new b(session, message.getReceivedDate());
        Enumeration enumeration = message.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            Header header = (Header)enumeration.nextElement();
            b2.addHeader(header.getName(), header.getValue());
        }
        return b2;
    }

    private MimeBodyPart b(Multipart multipart) throws MessagingException, IOException, PGPException {
        if (multipart.getCount() != 2) {
            throw new IOException("Expected 2 parts, got " + multipart.getCount());
        }
        BodyPart bodyPart = multipart.getBodyPart(0);
        String string = bodyPart.getContentType();
        ContentType contentType = new ContentType(string);
        if (string == null || !contentType.getBaseType().equalsIgnoreCase("application/pgp-encrypted")) {
            throw new IOException("Expected first part of type application/pgp-encrypted, got " + string);
        }
        BodyPart bodyPart2 = multipart.getBodyPart(1);
        String string2 = bodyPart2.getContentType();
        ContentType contentType2 = new ContentType(string2);
        if (string2 == null || !contentType2.getBaseType().equalsIgnoreCase("application/octet-stream")) {
            throw new IOException("Expected second part of type application/octet-stream, got " + string2);
        }
        InputStream inputStream = bodyPart2.getInputStream();
        byte[] byArray = this.a(inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        MimeBodyPart mimeBodyPart = new MimeBodyPart((InputStream)byteArrayInputStream);
        return mimeBodyPart;
    }

    private byte[] a(InputStream inputStream) throws IOException, PGPException {
        InputStream inputStream2 = PGPUtil.getDecoderStream((InputStream)inputStream);
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream2, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Object object = pGPObjectFactory.nextObject();
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)(object instanceof PGPEncryptedDataList ? object : pGPObjectFactory.nextObject());
        Iterator iterator = pGPEncryptedDataList.getEncryptedDataObjects();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = null;
        PGPSecretKey pGPSecretKey = null;
        while (iterator.hasNext()) {
            PBESecretKeyDecryptor pBESecretKeyDecryptor;
            PGPObjectFactory pGPObjectFactory2;
            Object object2;
            PGPEncryptedData pGPEncryptedData = (PGPEncryptedData)iterator.next();
            if (!(pGPEncryptedData instanceof PGPPublicKeyEncryptedData)) continue;
            pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedData;
            pGPSecretKey = this.g().getSecretKey(pGPPublicKeyEncryptedData.getKeyID());
            if (pGPSecretKey == null) continue;
            String string = this.a(pGPSecretKey.getKeyID());
            if (string == null) {
                string = "";
            }
            if ((object2 = (pGPObjectFactory2 = new PGPObjectFactory(pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().build(pGPSecretKey.extractPrivateKey(pBESecretKeyDecryptor = new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().build()).setProvider(com.inet.mail.a.a()).build(string.toCharArray())))), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator())).nextObject()) instanceof PGPCompressedData) {
                pGPObjectFactory2 = new PGPObjectFactory(((PGPCompressedData)object2).getDataStream(), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                object2 = pGPObjectFactory2.nextObject();
            }
            if (object2 instanceof PGPOnePassSignatureList) {
                object2 = pGPObjectFactory2.nextObject();
            }
            if (!(object2 instanceof PGPLiteralData)) continue;
            PGPLiteralData pGPLiteralData = (PGPLiteralData)object2;
            InputStream inputStream3 = pGPLiteralData.getInputStream();
            byte[] byArray = IOFunctions.readBytes((InputStream)inputStream3);
            if (pGPPublicKeyEncryptedData.isIntegrityProtected() && !pGPPublicKeyEncryptedData.verify()) {
                throw new PGPException("Integrity check failed");
            }
            return byArray;
        }
        throw new PGPException("Message does not contain literal data which can be decrypted with our secret keys");
    }

    protected String a(long l) {
        PersistenceEntry persistenceEntry = com.inet.mail.pgp.dao.a.a(false).resolve("" + l);
        PersistenceEntry persistenceEntry2 = persistenceEntry.getCryptoInstance(("" + l / 13L).toCharArray(), ("" + l / 17L).getBytes(StandardCharsets.UTF_8));
        return persistenceEntry2.getString();
    }

    private PGPSecretKeyRingCollection g() throws PGPException, IOException {
        if (this.am == null || this.ap + 10000L < System.currentTimeMillis()) {
            this.am = this.an.getPrivateKeyRing();
        }
        return this.am;
    }
}

