/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mail.structure;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.StyledLabelConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.error.ErrorCode;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.mail.api.BaseEmail;
import com.inet.mail.api.MailAuthenticationMethod;
import com.inet.mail.api.MailEncryption;
import com.inet.mail.api.MailServerProbe;
import com.inet.mail.api.MailServerProbeResult;
import com.inet.mail.api.profiles.MailProfile;
import com.inet.mail.pgp.dao.KeyDataAccessor;
import com.inet.mail.smime.e;
import com.inet.mail.structure.CertificatesItemListConfigProperty;
import com.inet.oauth.connection.api.config.OAuthConnectionTokenConfigProperty;
import com.inet.oauth.connection.api.token.OauthAccessTokenManager;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.util.encoders.Hex;

public class a
extends AbstractStructureProvider {
    @Nonnull
    public static final ConfigKey aL = new ConfigKey("mail.smtp.provider", "", String.class);
    public static final ConfigKey aM = new ConfigKey("mail.smtp.refresh.token", "", String.class);
    protected static final ConfigValue<String> SERVER_NAME = new ConfigValue<String>(ConfigKey.SERVER_URL){

        protected String e(@Nonnull String string) throws IllegalArgumentException {
            if (StringFunctions.isEmpty((String)string)) {
                string = ConfigKey.SERVER_URL.getDefault();
            }
            try {
                return new URL(string).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                return "";
            }
        }

        protected /* synthetic */ Object convert(@Nonnull String string) throws IllegalArgumentException {
            return this.e(string);
        }
    };

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(this.getCommunicationGroup(settings));
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "categorygroup.communication": {
                categories.add(new ConfigCategory(100, "category.mail", this.translate(settings, "category.mail", new Object[0]), "components-email"));
                categories.add(new ConfigCategory(300, "category.smime", this.translate(settings, "category.smime", new Object[0]), "communication.smime"));
                categories.add(new ConfigCategory(301, "category.pgp", this.translate(settings, "category.pgp", new Object[0]), "communication.pgp"));
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "category.mail": {
                return ((Object)((Object)this)).getClass().getResource("email_server_out_48.png");
            }
            case "category.smime": {
                return ((Object)((Object)this)).getClass().getResource("smime_48.png");
            }
            case "category.pgp": {
                return ((Object)((Object)this)).getClass().getResource("pgp_plugin_48.png");
            }
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.mail": {
                propertyGroups.add(new ConfigPropertyGroup(300, "mail.propgroup.settings", this.translate(settings, "mail.propgroup.settings", new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(400, "mail.propgroup.security", this.translate(settings, "mail.propgroup.security", new Object[0])));
                if (advanced) {
                    propertyGroups.add(new ConfigPropertyGroup(500, "mail.propgroup.additional", this.translate(settings, "mail.propgroup.additional", new Object[0])));
                }
                propertyGroups.add(new ConfigPropertyGroup(600, "mail.propgroup.sender", this.translate(settings, "mail.propgroup.sender", new Object[0]), new ConfigAction("action.testemail", this.translate(settings, "action.testemail", new Object[0]))));
                break;
            }
            case "category.smime": {
                propertyGroups.add(new ConfigPropertyGroup(100, "smime.private.propgroup", this.translate(settings, "smime.private.propgroup", new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(200, "smime.public.propgroup", this.translate(settings, "smime.public.propgroup", new Object[0]), new ConfigAction("action.delete.expired", this.translate(settings, "action.delete.expired", new Object[0]))));
                break;
            }
            case "category.pgp": {
                propertyGroups.add(new ConfigPropertyGroup(100, "pgp.private.propgroup", this.translate(settings, "pgp.private.propgroup", new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(200, "pgp.public.propgroup", this.translate(settings, "pgp.public.propgroup", new Object[0]), new ConfigAction("action.delete.expired", this.translate(settings, "action.delete.expiredkeys", new Object[0]))));
                break;
            }
        }
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.mail": {
                ConfigCondition configCondition;
                ConfigCondition configCondition2;
                ConditionGenerator conditionGenerator = new ConditionGenerator();
                List<MailProfile> list = MailProfile.getAvailableProfiles();
                if (list.size() > 0) {
                    configCondition2 = conditionGenerator.createCondition().property(aL).equals().value((Object)"");
                    actions.add(conditionGenerator.visibleActionFor(configCondition2, ConfigKey.MAIL_SMTPHOST));
                    actions.add(conditionGenerator.visibleActionFor(configCondition2, ConfigKey.MAIL_SMTPPORT));
                    actions.add(conditionGenerator.visibleActionFor(configCondition2, "mail.propgroup.security"));
                    configCondition = conditionGenerator.createCondition().not(configCondition2);
                    actions.add(conditionGenerator.visibleActionFor(configCondition, aM));
                    actions.add(conditionGenerator.visibleActionFor(configCondition, "mail.error.badPublicUrl"));
                    for (MailProfile mailProfile : list) {
                        ConfigCondition configCondition3 = conditionGenerator.createCondition().property(aL).equals().value((Object)mailProfile.getName());
                        actions.add(conditionGenerator.setValueActionFor(configCondition3, "profile.scope", mailProfile.getSmtpScopes()));
                        actions.add(conditionGenerator.setValueActionFor(configCondition3, "profile.provider", mailProfile.getOauthProvider()));
                    }
                    actions.add(conditionGenerator.setValueActionFor(configCondition2, "profile.scope", ""));
                    actions.add(conditionGenerator.setValueActionFor(configCondition2, "profile.provider", ""));
                }
                configCondition2 = conditionGenerator.createCondition().or(new ConfigCondition[]{conditionGenerator.createCondition().property(ConfigKey.MAIL_AUTHENTICATION).equals().value((Object)"2"), conditionGenerator.createCondition().property(ConfigKey.MAIL_AUTHENTICATION).equals().value((Object)"3")});
                actions.add(conditionGenerator.visibleActionFor(configCondition2, ConfigKey.MAIL_POP3HOST));
                actions.add(conditionGenerator.visibleActionFor(configCondition2, ConfigKey.MAIL_POP3PORT));
                configCondition = conditionGenerator.createCondition().not(conditionGenerator.createCondition().property(ConfigKey.MAIL_AUTHENTICATION).equals().value((Object)"0"));
                actions.add(conditionGenerator.visibleActionFor(configCondition, ConfigKey.MAIL_USER));
                actions.add(conditionGenerator.visibleActionFor(configCondition, ConfigKey.MAIL_PASSWORD));
                actions.add(conditionGenerator.setValueActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property(ConfigKey.MAIL_ENCRYPTION).equals().value((Object)MailEncryption.SSL.name()), conditionGenerator.createCondition().property(ConfigKey.MAIL_SMTPPORT).equals().value((Object)"25")}), ConfigKey.MAIL_SMTPPORT, "465"));
                actions.add(conditionGenerator.setValueActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().or(new ConfigCondition[]{conditionGenerator.createCondition().property(ConfigKey.MAIL_ENCRYPTION).equals().value((Object)MailEncryption.STARTTLS.name()), conditionGenerator.createCondition().property(ConfigKey.MAIL_ENCRYPTION).equals().value((Object)MailEncryption.NONE.name())}), conditionGenerator.createCondition().property(ConfigKey.MAIL_SMTPPORT).equals().value((Object)"465")}), ConfigKey.MAIL_SMTPPORT, "25"));
                break;
            }
            case "category.smime": {
                ArrayList arrayList;
                ConditionGenerator conditionGenerator = new ConditionGenerator();
                String string = settings.getChangedValue("smime.private.keys");
                boolean bl = string != null ? !(arrayList = (ArrayList)new Json().fromJson(string, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{CertificatesItemListConfigProperty.CertificateEntry.class}))).isEmpty() : e.l();
                actions.add(conditionGenerator.enableActionFor(bl ? conditionGenerator.alwaysTrue() : conditionGenerator.alwaysFalse(), e.aE));
                arrayList = conditionGenerator.createCondition().property(e.aE).equals().value((Object)Boolean.TRUE);
                actions.add(conditionGenerator.enableActionFor((ConfigCondition)(bl ? arrayList : conditionGenerator.alwaysFalse()), e.aF));
                break;
            }
            case "category.pgp": {
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "mail.propgroup.settings": {
                List<MailProfile> list;
                if (MailProfile.XOAUTH2 && (list = MailProfile.getAvailableProfiles()).size() > 0) {
                    MailProfile mailProfile;
                    void var10_16;
                    this.addTo(configProperties, "profile.scope", "Hidden", settings);
                    this.addTo(configProperties, "profile.provider", "Hidden", settings);
                    ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                    arrayList.add(new LocalizedKey("", this.translate(settings, "mail.customMailServer", new Object[0])));
                    for (MailProfile object2 : list) {
                        arrayList.add(new LocalizedKey(object2.getName(), object2.getDisplayName()));
                    }
                    this.addSelectTo(configProperties, aL, settings, arrayList);
                    String string2 = ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)SessionStore.getHttpServletRequest()).toString();
                    String string7 = OauthAccessTokenManager.getRedirectUrl();
                    int n = string7.indexOf("://") + 3;
                    n = string7.indexOf(47, n);
                    if (n > 0) {
                        String string3 = string7.substring(0, n);
                    }
                    if (!string2.equalsIgnoreCase((String)var10_16)) {
                        configProperties.add((ConfigProperty)new StyledLabelConfigProperty(Set.of(StyledLabelConfigProperty.Style.danger), 204, "mail.error.badPublicUrl", "", this.translate(settings, "mail.error.badPublicUrl", new Object[]{var10_16})));
                    } else {
                        this.addTo(configProperties, "mail.error.badPublicUrl", "Hidden", settings);
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("provider", "profile.provider");
                    hashMap.put("scope", "profile.scope");
                    String string4 = settings.getValue(aM);
                    configProperties.add((ConfigProperty)new OAuthConnectionTokenConfigProperty(205, aM.getKey(), StringFunctions.isEmpty((String)string4) ? "" : "xxxxxx", hashMap));
                    String string5 = settings.getValue(aL);
                    String string6 = settings.getValue(aM);
                    if (!StringFunctions.isEmpty((String)string5) && !StringFunctions.isEmpty((String)string6) && (mailProfile = MailProfile.getProfile(string5)) != null) {
                        try {
                            Consumer<String> consumer = string -> ConfigurationManager.getInstance().getCurrent().put(aM, string);
                            OauthAccessTokenManager.getAccessToken((String)mailProfile.getOauthProvider(), (String)string6, (int)450, consumer);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                this.addTo(configProperties, ConfigKey.MAIL_SMTPHOST, settings);
                this.addTo(configProperties, ConfigKey.MAIL_SMTPPORT, settings, "25");
                this.addTo(configProperties, ConfigKey.MAIL_SENDER, settings);
                break;
            }
            case "mail.propgroup.security": {
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                String string6 = ConfigKey.MAIL_ENCRYPTION.getKey() + ".";
                arrayList.add(new LocalizedKey(MailEncryption.NONE.name(), this.translate(settings, string6 + "none", new Object[0])));
                arrayList.add(new LocalizedKey(MailEncryption.STARTTLS.name(), this.translate(settings, string6 + "starttls", new Object[0])));
                arrayList.add(new LocalizedKey(MailEncryption.SSL.name(), this.translate(settings, string6 + "ssl", new Object[0])));
                this.addSelectTo(configProperties, ConfigKey.MAIL_ENCRYPTION, settings, arrayList);
                arrayList = new ArrayList();
                arrayList.add(new LocalizedKey("0", this.translate(settings, string6 + "none", new Object[0])));
                arrayList.add(new LocalizedKey("1", "SMTP"));
                arrayList.add(new LocalizedKey("2", "POP3"));
                arrayList.add(new LocalizedKey("3", "POP3 & SMTP"));
                this.addSelectTo(configProperties, ConfigKey.MAIL_AUTHENTICATION, settings, arrayList);
                this.addTo(configProperties, ConfigKey.MAIL_POP3HOST, settings);
                this.addTo(configProperties, ConfigKey.MAIL_POP3PORT, settings);
                this.addTo(configProperties, ConfigKey.MAIL_USER, settings);
                this.addTo(configProperties, ConfigKey.MAIL_PASSWORD.getKey(), "Password", Encryption.decrypt((String)settings.getValue(ConfigKey.MAIL_PASSWORD)), settings);
                break;
            }
            case "mail.propgroup.sender": {
                this.addTo(configProperties, "sendTestEmailTo", "SimpleText", "", settings, this.translate(settings, "sendTestEmailTo.placeholder", new Object[0]));
                break;
            }
            case "smime.private.propgroup": {
                this.addTo(configProperties, "smime.private.description", "Label", settings);
                configProperties.add((ConfigProperty)new CertificatesItemListConfigProperty(this, "smime.private.keys", "*.p12,*.pfx", true, this.a("smime.private.keys", settings), settings, false));
                this.addTo(configProperties, e.aE, settings);
                break;
            }
            case "smime.public.propgroup": {
                this.addTo(configProperties, "smime.public.description", "Label", settings);
                configProperties.add((ConfigProperty)new CertificatesItemListConfigProperty(this, "smime.public.keys", "*.p7b,*.crt,*.cert,*.cer,*.pem,*.der", false, this.a("smime.public.keys", settings), settings, false));
                this.addTo(configProperties, e.aF, settings);
                break;
            }
            case "pgp.private.propgroup": {
                this.addTo(configProperties, "pgp.private.description", "Label", settings);
                configProperties.add((ConfigProperty)new CertificatesItemListConfigProperty(this, "pgp.private.keys", "*.asc", true, this.a("pgp.private.keys", settings), settings, true));
                break;
            }
            case "pgp.public.propgroup": {
                this.addTo(configProperties, "pgp.public.description", "Label", settings);
                configProperties.add((ConfigProperty)new CertificatesItemListConfigProperty(this, "pgp.public.keys", "*.asc", false, this.a("pgp.public.keys", settings), settings, true));
                break;
            }
            case "mail.propgroup.additional": {
                void var10_19;
                Function<String, String> function = string -> {
                    if (StringFunctions.isEmpty((String)string)) {
                        return this.translate(settings, "mail.publicehlo.notAvailable", new Object[0]);
                    }
                    return string;
                };
                this.addTo(configProperties, "mail.publicehlo.description", "Label", settings);
                String string7 = (String)SERVER_NAME.get();
                if (!settings.isFilter()) {
                    String string8 = CoreSystemStructureProvider.getPublicDomain();
                }
                List<LocalizedKey> list = List.of(new LocalizedKey("false", this.translate(settings, "mail.publicehlo.server", new Object[]{function.apply((String)SERVER_NAME.get())})), new LocalizedKey("true", this.translate(settings, "mail.publicehlo.public", new Object[]{function.apply((String)var10_19)})));
                this.addSelectTo(configProperties, ConfigKey.MAIL_PUBLIC_EHLO, settings, list);
                break;
            }
        }
    }

    @Nonnull
    private List<CertificatesItemListConfigProperty.CertificateEntry> a(@Nonnull String string2, @Nonnull ConfigStructureSettings configStructureSettings) {
        List<com.inet.mail.smime.a> list;
        String string3 = configStructureSettings.getChangedValue(string2);
        if (string3 != null) {
            long l;
            HttpSession httpSession = SessionStore.getHttpSession();
            if ((string2.equals("smime.public.keys") || string2.equals("pgp.public.keys")) && httpSession != null && httpSession.getAttribute("action.delete.expired") != null) {
                l = System.currentTimeMillis();
                httpSession.removeAttribute("action.delete.expired");
            } else {
                l = Long.MIN_VALUE;
            }
            ArrayList arrayList = (ArrayList)new Json().fromJson(string3, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{CertificatesItemListConfigProperty.CertificateEntry.class}));
            ArrayList<CertificatesItemListConfigProperty.CertificateEntry> arrayList2 = new ArrayList<CertificatesItemListConfigProperty.CertificateEntry>();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                CertificatesItemListConfigProperty.CertificateEntry certificateEntry = (CertificatesItemListConfigProperty.CertificateEntry)iterator.next();
                if (!StringFunctions.isEmpty((String)certificateEntry.certupload)) {
                    if (!StringFunctions.isEmpty((String)certificateEntry.label)) continue;
                    try {
                        byte[] byArray = a.s(certificateEntry.certupload);
                        boolean bl = false;
                        switch (string2) {
                            case "smime.private.keys": {
                                certificateEntry.set(e.a(byArray, certificateEntry.certpassword, string -> this.translate(configStructureSettings, (String)string, new Object[0])), this);
                                break;
                            }
                            case "smime.public.keys": {
                                X509Certificate x509Certificate = e.a(byArray);
                                com.inet.mail.smime.a a2 = e.a(x509Certificate);
                                a2.a(x509Certificate, (String string) -> this.translate(configStructureSettings, (String)string, new Object[0]));
                                certificateEntry.set(a2, this);
                                break;
                            }
                            case "pgp.private.keys": {
                                Object object;
                                Object object2;
                                PGPSecretKey pGPSecretKey;
                                Object object3;
                                String string4;
                                String string5 = new String(byArray, StandardCharsets.UTF_8);
                                string5 = string5.replaceAll("(?m)(?s)-----BEGIN PGP PUBLIC KEY BLOCK-----.*-----END PGP PUBLIC KEY BLOCK-----", "");
                                PGPSecretKeyRingCollection pGPSecretKeyRingCollection = com.inet.mail.pgp.a.k(string5);
                                Iterator iterator2 = pGPSecretKeyRingCollection.getKeyRings();
                                while (iterator2.hasNext()) {
                                    string4 = (PGPSecretKeyRing)iterator2.next();
                                    object3 = string4.getSecretKeys();
                                    while (object3.hasNext()) {
                                        pGPSecretKey = (PGPSecretKey)object3.next();
                                        object2 = pGPSecretKey.getUserIDs();
                                        while (object2.hasNext()) {
                                            object = (String)object2.next();
                                            PGPPublicKey pGPPublicKey = pGPSecretKey.getPublicKey();
                                            com.inet.mail.smime.a a3 = new com.inet.mail.smime.a((String)object, pGPPublicKey.getCreationTime().getTime() + pGPPublicKey.getValidSeconds() * 1000L, Hex.toHexString((byte[])pGPPublicKey.getFingerprint()));
                                            if (!bl) {
                                                certificateEntry.set(a3, this);
                                                bl = true;
                                                continue;
                                            }
                                            CertificatesItemListConfigProperty.CertificateEntry certificateEntry2 = new CertificatesItemListConfigProperty.CertificateEntry();
                                            certificateEntry2.set(a3, this);
                                            certificateEntry2.certupload = certificateEntry.certupload;
                                            certificateEntry2.certpassword = certificateEntry.certpassword;
                                            arrayList2.add(certificateEntry2);
                                        }
                                    }
                                }
                                break;
                            }
                            case "pgp.public.keys": {
                                Object object;
                                Object object2;
                                String string4 = new String(byArray, StandardCharsets.UTF_8);
                                string4 = string4.replaceAll("(?m)(?s)-----BEGIN PGP PRIVATE KEY BLOCK-----.*-----END PGP PRIVATE KEY BLOCK-----", "");
                                Object object3 = com.inet.mail.pgp.a.i(string4);
                                PGPSecretKey pGPSecretKey = object3.iterator();
                                while (pGPSecretKey.hasNext()) {
                                    object2 = pGPSecretKey.next();
                                    if (!bl) {
                                        certificateEntry.set((com.inet.mail.smime.a)object2, this);
                                        bl = true;
                                        continue;
                                    }
                                    object = new CertificatesItemListConfigProperty.CertificateEntry();
                                    ((CertificatesItemListConfigProperty.CertificateEntry)object).set((com.inet.mail.smime.a)object2, this);
                                    ((CertificatesItemListConfigProperty.CertificateEntry)object).certupload = certificateEntry.certupload;
                                    arrayList2.add((CertificatesItemListConfigProperty.CertificateEntry)object);
                                }
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        certificateEntry.label = "Error: " + StringFunctions.getUserFriendlyErrorMessage((Throwable)exception);
                    }
                    continue;
                }
                if (certificateEntry.expired >= l || certificateEntry.expired <= 0L) continue;
                iterator.remove();
            }
            arrayList.addAll(arrayList2);
            a.a(arrayList);
            return arrayList;
        }
        boolean bl = true;
        switch (string2) {
            case "smime.private.keys": {
                bl = false;
            }
            case "smime.public.keys": {
                Object object;
                list = e.b(bl);
                for (com.inet.mail.smime.a a4 : list) {
                    object = e.a(bl, a4);
                    if (object == null) continue;
                    a4.a((X509Certificate)object, (String string) -> this.translate(configStructureSettings, (String)string, new Object[0]));
                }
                break;
            }
            case "pgp.public.keys": {
                Object object;
                list = this.c(true);
                try {
                    PersistenceEntry iOException = com.inet.mail.pgp.dao.a.a(true);
                    for (int i = 0; i < list.size(); ++i) {
                        object = list.get(i);
                        String string6 = Base64.getUrlEncoder().withoutPadding().encodeToString(((com.inet.mail.smime.a)object).getAddress().toLowerCase().getBytes(StandardCharsets.UTF_8));
                        String string7 = com.inet.mail.pgp.a.a(iOException.resolve(string6).getString(), ((com.inet.mail.smime.a)object).getAddress());
                        list.set(i, new com.inet.mail.smime.a(string7, ((com.inet.mail.smime.a)object).h(), ((com.inet.mail.smime.a)object).i()));
                    }
                    break;
                }
                catch (IOException pGPException) {
                    throw new RuntimeException(pGPException);
                }
                catch (PGPException pGPException) {
                    throw new RuntimeException(pGPException);
                }
            }
            case "pgp.private.keys": {
                list = this.c(false);
                break;
            }
            default: {
                throw new UnknownError();
            }
        }
        Object object = new ArrayList();
        for (com.inet.mail.smime.a a5 : list) {
            CertificatesItemListConfigProperty.CertificateEntry certificateEntry = new CertificatesItemListConfigProperty.CertificateEntry();
            certificateEntry.set(a5, this);
            ((ArrayList)object).add(certificateEntry);
        }
        return object;
    }

    static void a(ArrayList<CertificatesItemListConfigProperty.CertificateEntry> arrayList) {
        ArrayList<CertificatesItemListConfigProperty.CertificateEntry> arrayList2 = new ArrayList<CertificatesItemListConfigProperty.CertificateEntry>(arrayList);
        arrayList.clear();
        for (CertificatesItemListConfigProperty.CertificateEntry certificateEntry : arrayList2) {
            if (!arrayList.stream().noneMatch(certificateEntry2 -> {
                String string = EmailAddressHelper.get().extractEmailAddress(certificateEntry2.address);
                String string2 = EmailAddressHelper.get().extractEmailAddress(certificateEntry.address);
                return string != null && string2 != null && Objects.equals(string, string2);
            })) continue;
            arrayList.add(certificateEntry);
        }
    }

    private List<com.inet.mail.smime.a> c(boolean bl) {
        KeyDataAccessor keyDataAccessor = (KeyDataAccessor)ServerPluginManager.getInstance().getSingleInstance(KeyDataAccessor.class);
        if (keyDataAccessor == null) {
            return new ArrayList<com.inet.mail.smime.a>();
        }
        return bl ? keyDataAccessor.getPublicKeyInfos() : keyDataAccessor.getPrivateKeyInfos();
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        String string2;
        if (categoryKey == null || categoryKey.equals("category.mail")) {
            Object object = new ConfigValidator(messages, settings);
            object.validateEmails(ConfigKey.MAIL_SENDER);
            String string3 = settings.getValue(aL.getKey());
            string2 = settings.getValue(aM.getKey());
            if (!StringFunctions.isEmpty((String)string3) && StringFunctions.isEmpty((String)string2)) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "mail.error.missing.refreshtoken", new Object[0]), aM));
            }
        }
        if (categoryKey == null) {
            return;
        }
        switch (categoryKey) {
            case "certificate.addsmime.private.keys": {
                try {
                    string2 = settings.getChangedValue("certupload");
                    String string4 = settings.getChangedValue("certpassword");
                    byte[] byArray = a.s(string2);
                    e.a(byArray, string4, string -> this.translate(settings, (String)string, new Object[0]));
                }
                catch (Exception exception) {
                    BaseEmail.LOGGER.debug((Object)exception);
                    String string5 = StringFunctions.getUserFriendlyErrorMessage((Throwable)exception);
                    String string6 = string5.toLowerCase().contains("password") ? "certpassword" : "certupload";
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, string5, string6));
                }
                break;
            }
            case "certificate.addsmime.public.keys": {
                try {
                    string2 = settings.getChangedValue("certupload");
                    byte[] byArray = a.s(string2);
                    X509Certificate x509Certificate = e.a(byArray);
                    e.a(x509Certificate);
                }
                catch (Exception exception) {
                    BaseEmail.LOGGER.debug((Object)exception);
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, StringFunctions.getUserFriendlyErrorMessage((Throwable)exception), "certupload"));
                }
                break;
            }
            case "certificate.addpgp.private.keys": {
                try {
                    Object object;
                    string2 = settings.getChangedValue("certupload");
                    String string7 = settings.getChangedValue("certpassword");
                    String string8 = settings.getChangedValue("address");
                    String string9 = new String(a.s(string2), StandardCharsets.UTF_8);
                    boolean bl = string9.contains("BEGIN PGP PUBLIC KEY BLOCK");
                    int n = 0;
                    string9 = string9.replaceAll("(?m)(?s)-----BEGIN PGP PUBLIC KEY BLOCK-----.*-----END PGP PUBLIC KEY BLOCK-----", "");
                    PGPSecretKeyRingCollection pGPSecretKeyRingCollection = com.inet.mail.pgp.a.k(string9);
                    Iterator iterator = pGPSecretKeyRingCollection.getKeyRings();
                    Object var15_35 = null;
                    boolean bl2 = false;
                    while (iterator.hasNext()) {
                        object = (PGPSecretKeyRing)iterator.next();
                        PGPSecretKey pGPSecretKey = object.getSecretKey();
                        PBESecretKeyDecryptor pBESecretKeyDecryptor = new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().build()).build(string7.toCharArray());
                        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(pBESecretKeyDecryptor);
                        ++n;
                    }
                    if (bl) {
                        if (string9.contains("BEGIN PGP PRIVATE KEY BLOCK")) {
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, this.translate(settings, "pgp.warningfoundpublicinprivateimport", new Object[0]), "certupload"));
                            break;
                        }
                        object = this.translate(settings, "pgp.notaprivatekey", new Object[0]);
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, (String)object, "certupload"));
                        break;
                    }
                    if (n != 0) break;
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "pgp.noprivatekeyfound", new Object[0]), "certupload"));
                }
                catch (IOException | PGPException throwable) {
                    String string10;
                    BaseEmail.LOGGER.debug((Object)throwable);
                    String string11 = StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable);
                    String string12 = string10 = string11.toLowerCase().contains("checksum mismatch") ? "certpassword" : "certupload";
                    if (string11.toLowerCase().contains("checksum mismatch")) {
                        string11 = this.translate(settings, "pgp.privatepassphrase.error", new Object[0]);
                    } else if (string11.toLowerCase().contains("no protocol")) {
                        string11 = this.translate(settings, "pgp.needupload", new Object[0]);
                    } else if (string11.toLowerCase().contains("publickeyring found where")) {
                        string11 = this.translate(settings, "pgp.notaprivatekey", new Object[0]);
                    }
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, string11, string10));
                }
                break;
            }
            case "certificate.addpgp.public.keys": {
                try {
                    string2 = settings.getChangedValue("certupload");
                    String string13 = new String(a.s(string2), StandardCharsets.UTF_8);
                    boolean bl = string13.contains("BEGIN PGP PRIVATE KEY BLOCK");
                    string13 = string13.replaceAll("(?m)(?s)-----BEGIN PGP PRIVATE KEY BLOCK-----.*-----END PGP PRIVATE KEY BLOCK-----", "");
                    PGPPublicKey pGPPublicKey = com.inet.mail.pgp.a.j(string13);
                    String string14 = com.inet.mail.pgp.a.a(string13, null);
                    if (bl) {
                        if (string13.contains("BEGIN PGP PUBLIC KEY BLOCK")) {
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, this.translate(settings, "pgp.warningfoundprivateinpublicimport", new Object[0]), "certupload"));
                        } else {
                            String string15 = this.translate(settings, "pgp.notapublickey", new Object[0]);
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, string15, "certupload"));
                        }
                    }
                    if (string14 != null && !string14.isBlank()) break;
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "pgp.noemail", new Object[0]), "certupload"));
                    break;
                }
                catch (Exception exception) {
                    BaseEmail.LOGGER.debug((Object)exception);
                    String string16 = StringFunctions.getUserFriendlyErrorMessage((Throwable)exception);
                    String string17 = "certupload";
                    if (string16.toLowerCase().contains("no protocol")) {
                        string16 = this.translate(settings, "pgp.needupload", new Object[0]);
                    } else if (string16.toLowerCase().contains("secretkeyring found where")) {
                        string16 = this.translate(settings, "pgp.notapublickey", new Object[0]);
                    } else if (string16.toLowerCase().contains("no key found")) {
                        string16 = this.translate(settings, "pgp.notapublickey", new Object[0]);
                    }
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, string16, string17));
                }
            }
        }
    }

    public void action(@Nonnull String actionKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings) {
        block4 : switch (actionKey) {
            case "action.testemail": {
                Object object;
                String string = settings.getChangedValue("sendTestEmailTo");
                if (string == null || string.length() == 0) {
                    string = settings.getValue(ConfigKey.MAIL_SENDER);
                }
                new ConfigValidator(messages, settings).validateEmails(string, "sendTestEmailTo");
                new ConfigValidator(messages, settings).validateEmails(ConfigKey.MAIL_SENDER);
                if (!messages.isEmpty()) {
                    return;
                }
                List list = this.getConditions("category.mail", settings);
                ApplicationDescription applicationDescription = ApplicationDescription.get();
                String string2 = applicationDescription.getRemoteGuiInformation().getProductTitle();
                MailServerProbe mailServerProbe = new MailServerProbe(this.translate(settings, "action.testemail.subject", new Object[]{string2}), this.translate(settings, "action.testemail.message", new Object[]{string2}));
                String string3 = settings.getValue(ConfigKey.MAIL_SMTPPORT);
                if (string3 == null || string3.isEmpty()) {
                    string3 = "25";
                }
                mailServerProbe.setSmtpHost(settings.getValue(ConfigKey.MAIL_SMTPHOST)).setSmtpPort(Integer.parseInt(string3)).setSender(settings.getValue(ConfigKey.MAIL_SENDER)).setAuthenticationMethod(MailAuthenticationMethod.fromID(Integer.parseInt(settings.getValue(ConfigKey.MAIL_AUTHENTICATION)))).setEncryption(MailEncryption.valueOf(settings.getValue(ConfigKey.MAIL_ENCRYPTION)));
                if (settings.isValidatable(ConfigKey.MAIL_USER, list)) {
                    mailServerProbe.setUser(settings.getValue(ConfigKey.MAIL_USER));
                    object = settings.getOriginalValue(ConfigKey.MAIL_PASSWORD);
                    String string4 = settings.getValue(ConfigKey.MAIL_PASSWORD);
                    if (((String)object).equals(string4)) {
                        string4 = Encryption.decrypt((String)object);
                    }
                    mailServerProbe.setPassword(string4);
                }
                if (settings.isValidatable(ConfigKey.MAIL_POP3HOST, list)) {
                    mailServerProbe.setPop3Host(settings.getValue(ConfigKey.MAIL_POP3HOST));
                    mailServerProbe.setPop3Port(Integer.parseInt(settings.getValue(ConfigKey.MAIL_POP3PORT)));
                }
                mailServerProbe.setEmailRecipient(string);
                mailServerProbe.setSmtpProvider(settings.getValue(aL)).setSmtpRefreshToken(settings.getValue(aM));
                object = mailServerProbe.probe();
                switch (((MailServerProbeResult)object).getStatus()) {
                    case OK: {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, this.translate(settings, "mail.validateMailOK", new Object[0]), (String)null));
                        break block4;
                    }
                    case INVALID_SENDER: {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "mail.validateMailInvalidSender", new Object[0]), (String)null));
                        break block4;
                    }
                    case STARTTLS_REQUIRED: {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "mail.startTlsRequired", new Object[0]), (String)null));
                        break block4;
                    }
                    case LOGIN_FAILURE_POP3: 
                    case LOGIN_FAILURE_SMTP: {
                        if (settings.getValue(ConfigKey.MAIL_USER).contains("@")) {
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "mail.validateMailFailureTryNoAt", new Object[]{((MailServerProbeResult)object).getMessage()}), (String)null));
                            break block4;
                        }
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "mail.validateMailFailure", new Object[]{((MailServerProbeResult)object).getMessage()}), (String)null));
                        break block4;
                    }
                }
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "mail.validateMailFailure", new Object[]{((MailServerProbeResult)object).getMessage()}), (String)null));
                break;
            }
            case "action.delete.expired": {
                HttpSession httpSession = SessionStore.getHttpSession();
                if (httpSession == null) break;
                httpSession.setAttribute("action.delete.expired", (Object)Boolean.TRUE);
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Reload, "", "action.delete.expired"));
                break;
            }
        }
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        switch (key) {
            case "profile.scope": 
            case "profile.provider": 
            case "sendTestEmailTo": {
                return ConfigStructure.SaveState.SAVE;
            }
            case "mail.smtp.refresh.token": 
            case "mail.smtp.provider": {
                if (StringFunctions.isEmpty((String)settings.getValue("mail.smtp.provider"))) {
                    settings.save(aL, "");
                    settings.save(aM, "");
                    return ConfigStructure.SaveState.SAVE;
                }
                return ConfigStructure.SaveState.NONE;
            }
            case "mail.password": {
                settings.save(key, Encryption.encrypt((String)value));
                return ConfigStructure.SaveState.SAVE;
            }
            case "smime.public.keys": {
                this.b(true, value);
                return ConfigStructure.SaveState.SAVE;
            }
            case "smime.private.keys": {
                this.b(false, value);
                return ConfigStructure.SaveState.SAVE;
            }
            case "pgp.public.keys": {
                this.c(true, value);
                return ConfigStructure.SaveState.SAVE;
            }
            case "pgp.private.keys": {
                this.c(false, value);
                return ConfigStructure.SaveState.SAVE;
            }
        }
        return ConfigStructure.SaveState.NONE;
    }

    private void b(boolean bl, String string) {
        List<com.inet.mail.smime.a> list = e.b(bl);
        ArrayList arrayList = (ArrayList)new Json().fromJson(string, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{CertificatesItemListConfigProperty.CertificateEntry.class}));
        for (CertificatesItemListConfigProperty.CertificateEntry object : arrayList) {
            if (!StringFunctions.isEmpty((String)object.certupload)) {
                try {
                    byte[] byArray = a.s(object.certupload);
                    if (bl) {
                        X509Certificate x509Certificate = e.a(byArray);
                        object.set(e.a(x509Certificate, true), this);
                    } else {
                        object.set(e.a(byArray, object.certpassword), this);
                    }
                }
                catch (Exception exception) {
                    throw (RuntimeException)ErrorCode.throwAny((Throwable)exception);
                }
            }
            list.remove(new com.inet.mail.smime.a(object.address, object.expired, object.keyID));
        }
        for (com.inet.mail.smime.a a2 : list) {
            e.b(bl, a2.getAddress(), a2.h());
        }
    }

    private void c(boolean bl, String string) {
        KeyDataAccessor keyDataAccessor = (KeyDataAccessor)ServerPluginManager.getInstance().getSingleInstance(KeyDataAccessor.class);
        if (keyDataAccessor == null) {
            return;
        }
        List<com.inet.mail.smime.a> list = this.c(bl);
        ArrayList arrayList = (ArrayList)new Json().fromJson(string, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{CertificatesItemListConfigProperty.CertificateEntry.class}));
        HashSet<String> hashSet = new HashSet<String>();
        for (CertificatesItemListConfigProperty.CertificateEntry object : arrayList) {
            String illegalArgumentException;
            block14: {
                if (!StringFunctions.isEmpty((String)object.certupload)) {
                    try {
                        String string2;
                        illegalArgumentException = new String(a.s(object.certupload), StandardCharsets.UTF_8);
                        if (bl) {
                            string2 = illegalArgumentException.replaceAll("(?m)(?s)-----BEGIN PGP PRIVATE KEY BLOCK-----.*-----END PGP PRIVATE KEY BLOCK-----", "");
                            List<com.inet.mail.smime.a> list2 = com.inet.mail.pgp.a.i(string2);
                            for (com.inet.mail.smime.a a3 : list2) {
                                String string3 = a3.getAddress();
                                String string4 = EmailAddressHelper.get().extractEmailAddress(string3);
                                keyDataAccessor.putPublicKey(string4, string2);
                            }
                            break block14;
                        }
                        try {
                            if (!hashSet.contains(object.certupload)) {
                                hashSet.add(object.certupload);
                                string2 = illegalArgumentException.replaceAll("(?m)(?s)-----BEGIN PGP PUBLIC KEY BLOCK-----.*-----END PGP PUBLIC KEY BLOCK-----", "");
                                keyDataAccessor.putPrivateKey(illegalArgumentException, object.certpassword);
                            }
                        }
                        catch (IOException iOException) {
                            throw (RuntimeException)ErrorCode.throwAny((Throwable)iOException);
                        }
                    }
                    catch (IOException pGPException) {
                        throw (RuntimeException)ErrorCode.throwAny((Throwable)pGPException);
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        if (illegalArgumentException2.getMessage() == null || !illegalArgumentException2.getMessage().contains("already contains")) {
                            throw (RuntimeException)ErrorCode.throwAny((Throwable)illegalArgumentException2);
                        }
                    }
                    catch (PGPException pGPException) {
                        throw (RuntimeException)ErrorCode.throwAny((Throwable)pGPException);
                    }
                }
            }
            illegalArgumentException = EmailAddressHelper.get().extractEmailAddress(object.address);
            list.removeIf(a2 -> a2.getAddress().equals(string2) || a2.getAddress().endsWith("<" + string2 + ">"));
        }
        for (com.inet.mail.smime.a a4 : list) {
            this.d(bl, a4.getAddress());
        }
    }

    private void d(boolean bl, String string) {
        KeyDataAccessor keyDataAccessor = (KeyDataAccessor)ServerPluginManager.getInstance().getSingleInstance(KeyDataAccessor.class);
        if (keyDataAccessor == null) {
            return;
        }
        if (bl) {
            keyDataAccessor.removePublicKey(string);
        } else {
            keyDataAccessor.removePrivateKey(string);
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only data protocoll acepted")
    private static byte[] s(String string) throws IOException {
        URL uRL = new URL(string);
        if (!"data".equals(uRL.getProtocol())) {
            throw new IOException("Unsupported upload protocol: " + uRL.getProtocol());
        }
        return IOFunctions.readBytes((InputStream)uRL.openStream());
    }
}

