/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.structure;

import com.inet.config.ConfigKey;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.helpdesk.plugins.livesupport.utils.LiveSupportThemeService;
import com.inet.lib.json.Json;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LiveSupportThemeStructureProvider
extends AbstractStructureProvider {
    private static final String GROUP_LIVE_SUPPORT_DESIGN = "group.livesupport.design";
    private static final String FONT_SIZE = "@font-size";
    private static final String FONT_COLOR = "@font-color";
    private static final String BASE_COLOR = "@base-color";
    private static final String USER_COLOR = "@user-color";
    private static final String SUPPORTER_COLOR = "@supporter-color";
    private static final String ERROR_COLOR = "@error-color";
    private static final String[] USER_COLOR_ORDER = new String[]{"@base-color", "@user-color", "@supporter-color", "@error-color", "@font-color", "@font-size"};
    private static final String LIVE_SUPPORT_COLORS_PREFIX = "livesupport.themecolors";
    public static final ConfigKey LIVE_SUPPORT_THEMECOLORS = new ConfigKey("livesupport.themecolors", "", String.class);
    private static final String LIVE_SUPPORT_RESET_DEFAULT_COLORS = "livesupport.theme.action.defaultvalues";

    private static String getDefaultColors() {
        List<String> colors = Arrays.asList(USER_COLOR_ORDER);
        Map<String, String> defaultColors = LiveSupportThemeService.getInstance().getDefaultColors().entrySet().parallelStream().filter(e -> colors.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new Json().toJson(defaultColors);
    }

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.livesupport": {
                ConfigAction actionDefaultValues = new ConfigAction(LIVE_SUPPORT_RESET_DEFAULT_COLORS, this.translate(settings, LIVE_SUPPORT_RESET_DEFAULT_COLORS, new Object[0]));
                configPropertyGroups.add(new ConfigPropertyGroup(300, GROUP_LIVE_SUPPORT_DESIGN, this.translate(settings, GROUP_LIVE_SUPPORT_DESIGN, new Object[0]), actionDefaultValues));
                break;
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.livesupport.design": {
                String valueColors = settings.getValue(LIVE_SUPPORT_THEMECOLORS);
                Properties colors = null;
                if (valueColors != null && valueColors.length() > 0) {
                    colors = (Properties)new Json().fromJson(valueColors, Properties.class);
                }
                if (colors == null) {
                    colors = new Properties();
                }
                HashMap<String, String> defaultColors = LiveSupportThemeService.getInstance().getDefaultColors();
                for (Object oKey : colors.keySet()) {
                    String cKey = (String)oKey;
                    String cValue = colors.getProperty(cKey);
                    defaultColors.put(cKey, cValue);
                }
                for (String colorKey : USER_COLOR_ORDER) {
                    if (!defaultColors.containsKey(colorKey)) continue;
                    String value = settings.getValue("livesupport.themecolors_" + colorKey);
                    if (value == null || value.length() == 0) {
                        value = defaultColors.get(colorKey);
                    }
                    if (FONT_SIZE.equals(colorKey)) {
                        if (value != null && value.endsWith("px")) {
                            value = value.substring(0, value.length() - 2);
                        }
                        ArrayList<UnitConfigProperty.Unit> units = new ArrayList<UnitConfigProperty.Unit>();
                        units.add(new UnitConfigProperty.Unit(1.0, "px"));
                        this.addUnitTo(configProperties, "livesupport.themecolors_@font-size", value, "FixNumber", settings, units);
                        continue;
                    }
                    this.addTo(configProperties, "livesupport.themecolors_" + colorKey, "Color", value, settings);
                }
                break;
            }
        }
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        if (key.startsWith("livesupport.themecolors_")) {
            key = key.substring("livesupport.themecolors_".length());
            String valueColors = settings.getOriginalValue(LIVE_SUPPORT_THEMECOLORS);
            Properties colors = null;
            if (valueColors != null && valueColors.length() > 0) {
                colors = (Properties)new Json().fromJson(valueColors, Properties.class);
            }
            if (colors == null) {
                colors = new Properties();
            }
            if (((String)value).length() == 0) {
                colors.remove(key);
            } else {
                if (FONT_SIZE.equals(key)) {
                    value = (String)value + "px";
                }
                colors.put(key, value);
            }
            value = new Json().toJson((Object)colors);
            settings.save(LIVE_SUPPORT_THEMECOLORS, (String)value);
            return ConfigStructure.SaveState.SAVE;
        }
        return ConfigStructure.SaveState.NONE;
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        if (categoryKey == null || categoryKey.equals("category.livesupport")) {
            Properties values = settings.getValues();
            String key = "livesupport.themecolors_@font-size";
            if (values != null && values.containsKey(key)) {
                ConfigValidator validator = new ConfigValidator(messages, settings);
                validator.validateUnitNumberRange(key, values.getProperty(key), 9.0, 20.0, "px");
            }
        }
    }

    public void action(@Nonnull String actionKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings) {
        switch (actionKey) {
            case "livesupport.theme.action.defaultvalues": {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Reload, "", "livesupport.theme.action.defaultvalues.ok"));
                break;
            }
            case "livesupport.theme.action.defaultvalues.ok": {
                Properties values = settings.getValues();
                if (values == null) break;
                HashMap<String, String> defaultColors = LiveSupportThemeService.getInstance().getDefaultColors();
                for (Map.Entry<String, String> entry : defaultColors.entrySet()) {
                    String value = entry.getValue();
                    if (FONT_SIZE.equals(entry.getKey()) && value.endsWith("px")) {
                        value = value.substring(0, value.length() - 2);
                    }
                    values.setProperty("livesupport.themecolors_" + entry.getKey(), value);
                }
                break;
            }
        }
    }
}

