/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.server.taskplanner;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.livesupport.LiveSupportServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.template.TaskTemplateDefinition;
import com.inet.taskplanner.server.api.template.TaskTemplateDefinitionImpl;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.time.RepeatInterval;
import java.time.ZonedDateTime;
import java.util.Collections;

@JsonData
public class LiveSupportCanBeProvidedTaskTemplateDefinition
extends TaskTemplateDefinitionImpl {
    private LiveSupportCanBeProvidedTaskTemplateDefinition(Boolean enabled) {
        super("livesupport.canBeProvided." + (enabled != false ? "true" : "false"), LiveSupportServerPlugin.MSG, "taskplanner.template.canBeProvided.title." + (enabled != false ? "true" : "false"), "taskplanner.template.canBeProvided.description." + (enabled != false ? "true" : "false"), LiveSupportCanBeProvidedTaskTemplateDefinition.getDescription(enabled), Collections.emptyList());
    }

    private static TaskDefinition getDescription(Boolean enabled) {
        TaskDefinition task = new TaskDefinition("livesupport.canBeProvided." + (enabled != false ? "true" : "false"));
        TriggerDefinition timeTrigger = new TriggerDefinition("trigger.time");
        timeTrigger.setProperty("repeat.select", RepeatInterval.WORKDAYS.name());
        ZonedDateTime dest = ZonedDateTime.now().withHour(enabled != false ? 9 : 17).withMinute(0);
        timeTrigger.setProperty("start.time", "" + dest.toEpochSecond() * 1000L);
        timeTrigger.setProperty("start.day", "" + dest.toEpochSecond() * 1000L);
        task.addTrigger(timeTrigger);
        ResultActionDefinition action = new ResultActionDefinition("livesupport.canbeprovided");
        action.getProperties().put("enabled", enabled.toString());
        task.addResultAction(action);
        return task;
    }

    public static void registerExtension(ServerPluginManager spm, Boolean enable) {
        spm.register(TaskTemplateDefinition.class, (Object)new LiveSupportCanBeProvidedTaskTemplateDefinition(enable));
    }
}

