/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.server.webapi;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.livesupport.server.LiveSupportServlet;
import com.inet.helpdesk.plugins.livesupport.server.notifications.LiveSupportNotificationGenerator;
import com.inet.helpdesk.plugins.livesupport.server.session.LiveSupportPreflightSessionCache;
import com.inet.helpdesk.plugins.livesupport.server.session.LiveSupportSessionClearer;
import com.inet.helpdesk.plugins.livesupport.server.ticket.LiveSupportTicketActionExtension;
import com.inet.helpdesk.plugins.livesupport.structure.LiveSupportStructureProvider;
import com.inet.helpdesk.plugins.livesupport.utils.HmacUtils;
import com.inet.helpdesk.plugins.livesupport.utils.LiveSupportAttachmentHelper;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.data.step.TicketStepEntryResponseData;
import com.inet.helpdesk.webapi.ticket.HelpDeskTicketActionApplyHandler;
import com.inet.helpdesk.webapi.ticket.HelpDeskTicketActionListHandler;
import com.inet.helpdesk.webapi.ticket.HelpDeskTicketCreateHandler;
import com.inet.helpdesk.webapi.ticket.HelpDeskTicketIdHandler;
import com.inet.helpdesk.webapi.ticket.step.HelpDeskTicketStepIdHandler;
import com.inet.helpdesk.webapi.ticket.step.HelpDeskTicketStepsHandler;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.http.ExpandableHttpSessionListener;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.webapi.WebAPICoreServerPlugin;
import com.inet.plugin.webapi.api.PathTokenizer;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.WebAPIAccessProvider;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.usersandgroups.api.user.UserAccountScope;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class LiveSupportWebAPIAccessProvider
implements WebAPIAccessProvider {
    private static final int[] CLOSE_ACTIONS = new int[]{LiveSupportTicketActionExtension.LIVE_SUPPORT_FINISH_CONVERT_TO_TICKET.getId(), 2, 7};
    private static final int[] AS_LIST = new int[]{LiveSupportTicketActionExtension.LIVE_SUPPORT_SUPPORTER_ACTION.getId(), LiveSupportTicketActionExtension.LIVE_SUPPORT_FINISH_CONVERT_TO_TICKET.getId(), -12, 2, 7, -22};
    private static final String X_TICKET_TOKEN = "X-Ticket-Token";
    public static final String LIVE_SUPPORT_WEB_API_ACCESS = "LiveSupportWebAPIAccess";
    public static final String TICKET_TOKEN_NAME = "current-livesupport-ticket";
    public static final String TICKET_TOKEN_SECRET = "current-livesupport-secret";
    private static ConfigValue<GUID> DISPATCH_TO = new ConfigValue(LiveSupportStructureProvider.LIVE_SUPPORT_DISPATCH_TO);

    public boolean isWebApiAccessGranted(HttpServletRequest request, HttpServletResponse response) {
        List pathTokens = PathTokenizer.convertPathToTokens((String)request.getPathInfo()).stream().map(p -> p.toLowerCase()).collect(Collectors.toList());
        if (pathTokens.isEmpty() || pathTokens.size() == 1) {
            return false;
        }
        return pathTokens.size() <= 1 || "ticket".equalsIgnoreCase((String)pathTokens.get(0)) || LiveSupportServlet.hasAttachments() && LiveSupportAttachmentHelper.isAttachmentWebAPIExtensionName((String)pathTokens.get(0));
    }

    public boolean isAccessToExtensionGranted(WebAPIExtension apiExtension, HttpServletRequest request, HttpServletResponse response, List<String> pathTokens) {
        return (apiExtension instanceof HelpDeskTicketWebAPIExtension || LiveSupportServlet.hasAttachments() && LiveSupportAttachmentHelper.isAttachmentWebAPIExtension(apiExtension)) && this.checkAccess(request, response);
    }

    public UserAccountScope getUserAccountScopeForHandler(RequestHandlerBase<?, ?> handler, HttpServletRequest request, HttpServletResponse response, List<String> pathTokens) {
        if (handler instanceof HelpDeskTicketCreateHandler || handler instanceof HelpDeskTicketIdHandler || handler instanceof HelpDeskTicketActionApplyHandler || handler instanceof HelpDeskTicketStepsHandler || handler instanceof HelpDeskTicketActionListHandler || handler instanceof HelpDeskTicketStepIdHandler || LiveSupportServlet.hasAttachments() && LiveSupportAttachmentHelper.isAttachmentHandler(handler)) {
            HelpDeskWebAPIHelper.setRequestRequiresEncodedTicketId();
            if (handler instanceof HelpDeskTicketStepIdHandler) {
                request.setAttribute("inlineImages", (Object)"true");
            }
            return UserAccountScope.createPrivileged();
        }
        return super.getUserAccountScopeForHandler(handler, request, response, pathTokens);
    }

    private boolean checkAccess(HttpServletRequest request, HttpServletResponse response) {
        List pathTokens = PathTokenizer.convertPathToTokens((String)request.getPathInfo()).stream().map(p -> p.toLowerCase()).collect(Collectors.toList());
        if (pathTokens.size() == 2 && "create".equalsIgnoreCase((String)pathTokens.get(1))) {
            if (!((Boolean)LiveSupportServlet.CAN_PROVIDE_SUPPORT.get()).booleanValue()) {
                ResponseWriter.unavailable((HttpServletResponse)response);
                throw new ClientMessageException("Support hours ended");
            }
            return this.prepareAPI(this.isCreateRequestAllowed());
        }
        if (pathTokens.size() == 5 && LiveSupportServlet.hasAttachments() && LiveSupportAttachmentHelper.isAttachmentWebAPIExtensionName((String)pathTokens.get(0))) {
            int ticketId = Tickets.decodeTicketID((String)((String)pathTokens.get(2)), (boolean)false);
            if (ticketId == -1) {
                return false;
            }
            LiveSupportSessionClearer.registerLiveSupportSession(ticketId);
            return this.prepareAPI(true);
        }
        if (pathTokens.size() >= 2) {
            int ticketId = Tickets.decodeTicketID((String)((String)pathTokens.get(1)), (boolean)true);
            if (ticketId == -1) {
                return false;
            }
            try {
                if (!Integer.valueOf(ticketId).equals(this.getSessionTicketToken())) {
                    return false;
                }
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            HelpDeskWebAPIHelper.setRequestRequiresEncodedTicketId();
            LiveSupportSessionClearer.registerLiveSupportSession(ticketId);
        }
        if (pathTokens.size() == 3 && "apply".equalsIgnoreCase((String)pathTokens.get(2))) {
            return this.prepareAPI(true);
        }
        if (pathTokens.size() == 3 && "actions".equalsIgnoreCase((String)pathTokens.get(2))) {
            return this.prepareAPI(true);
        }
        if (pathTokens.size() >= 3 && !"steps".equalsIgnoreCase((String)pathTokens.get(2))) {
            return false;
        }
        return this.prepareAPI(true);
    }

    private boolean isCreateRequestAllowed() {
        if (this.getSessionTicketToken() != null) {
            return false;
        }
        HttpSession session = SessionStore.getHttpSession((boolean)false);
        HttpServletRequest request = SessionStore.getHttpServletRequest();
        if (session == null || request == null) {
            WebAPICoreServerPlugin.LOGGER.debug((Object)"There is no session or request to check if the ticket create request is allowed.");
            return false;
        }
        String header = request.getHeader(X_TICKET_TOKEN);
        if (StringFunctions.isEmpty((String)header)) {
            return false;
        }
        try {
            String[] headerValue = LiveSupportServlet.decode(Objects.requireNonNullElse(header, "").trim()).split("\u00a7");
            GUID reversedGUID = GUID.valueOf((String)headerValue[0]);
            if (reversedGUID == null || headerValue.length != 2) {
                return false;
            }
            String liveSupportId = LiveSupportServlet.decode(headerValue[1]);
            return LiveSupportPreflightSessionCache.sessionHasAuthToken(liveSupportId, reversedGUID);
        }
        catch (Exception e) {
            return false;
        }
    }

    private Integer getSessionTicketToken() {
        HttpSession httpSession = SessionStore.getHttpSession();
        try {
            return (Integer)httpSession.getAttribute(TICKET_TOKEN_NAME);
        }
        catch (ClassCastException | NullPointerException e) {
            return null;
        }
    }

    public static boolean isLiveSupportAPIAccess() {
        HttpServletRequest request = SessionStore.getHttpServletRequest();
        return request != null && request.getAttribute(LIVE_SUPPORT_WEB_API_ACCESS) != null;
    }

    private boolean prepareAPI(boolean isAPIAllowed) {
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        HttpServletRequest request = httpServletRequest;
        if (request == null) {
            return false;
        }
        if (isAPIAllowed && httpServletRequest != null) {
            httpServletRequest.setAttribute(LIVE_SUPPORT_WEB_API_ACCESS, (Object)Boolean.TRUE);
        }
        return isAPIAllowed;
    }

    public <R> void postProcessRequest(RequestHandlerBase<?, R> handler, HttpServletRequest request, HttpServletResponse response, @Nullable R typedResponse) {
        if (!response.isCommitted()) {
            response.setHeader("Set-Cookie", null);
            response.setHeader("X-User", null);
        }
        if (handler instanceof HelpDeskTicketCreateHandler && typedResponse != null) {
            this.processCreateResponse((Integer)((HelpDeskTicketCreateHandler)handler).getTypedResponse(typedResponse), response);
        }
        if (handler instanceof HelpDeskTicketActionApplyHandler) {
            this.processApplyResponse(typedResponse == null ? null : (ReaStepVO)((HelpDeskTicketActionApplyHandler)handler).getTypedResponse(typedResponse), response);
        }
        if (handler instanceof HelpDeskTicketStepsHandler) {
            this.processStepsResponse(typedResponse == null ? null : (List)((HelpDeskTicketStepsHandler)handler).getTypedResponse(typedResponse), response);
        }
        if (handler instanceof HelpDeskTicketStepIdHandler) {
            this.processStepIdResponse(typedResponse == null ? null : (ReaStepVO)((HelpDeskTicketStepIdHandler)handler).getTypedResponse(typedResponse), response);
        }
    }

    private void processStepsResponse(List<ReaStepVO> reaStepsList, HttpServletResponse response) {
        response.resetBuffer();
        reaStepsList = new ArrayList<ReaStepVO>(reaStepsList);
        reaStepsList.removeIf(s -> !Arrays.stream(AS_LIST).anyMatch(e -> e == s.getActionID()));
        try {
            ResponseWriter.json((HttpServletResponse)response, (Object)TicketStepEntryResponseData.from(reaStepsList));
        }
        catch (IOException e) {
            throw new ClientMessageException(e.getMessage());
        }
    }

    private void processApplyResponse(ReaStepVO reaStepVO, HttpServletResponse response) {
        this.checkReaStepIsClosed(reaStepVO, response);
    }

    private void processStepIdResponse(ReaStepVO reaStepVO, HttpServletResponse response) {
        this.checkReaStepIsClosed(reaStepVO, response);
    }

    private void checkReaStepIsClosed(ReaStepVO reaStepVO, HttpServletResponse response) {
        if (reaStepVO != null && Arrays.stream(CLOSE_ACTIONS).anyMatch(id -> reaStepVO.getActionID() == id)) {
            SessionStore.getHttpSession().removeAttribute(TICKET_TOKEN_NAME);
            LiveSupportSessionClearer.unregisterLiveSupportSession();
            response.setStatus(200);
        }
    }

    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="data are save")
    private void processCreateResponse(Integer ticketId, HttpServletResponse response) {
        GUID guid = GUID.generateNew();
        HttpSession httpSession = SessionStore.getHttpSession();
        httpSession.setAttribute(TICKET_TOKEN_NAME, (Object)ticketId);
        httpSession.setAttribute(TICKET_TOKEN_SECRET, (Object)guid);
        LiveSupportSessionClearer.registerLiveSupportSession(ticketId);
        response.setHeader(X_TICKET_TOKEN, this.generateToken(ticketId, guid));
        response.setHeader("Access-Control-Expose-Headers", X_TICKET_TOKEN);
        LiveSupportNotificationGenerator.createNotification(ticketId);
    }

    public static GUID getDispatchToRessource() {
        GUID dispatchTo = null;
        try {
            HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
            if (httpServletRequest != null) {
                dispatchTo = GUID.valueOf((String)httpServletRequest.getParameter("dispatchTo"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (dispatchTo == null) {
            dispatchTo = (GUID)DISPATCH_TO.get();
        }
        return dispatchTo;
    }

    private String generateToken(@Nonnull Integer ticketId, @Nonnull GUID secret) {
        StringBuilder token = new StringBuilder();
        token.append(Tickets.encodeTicketId((int)ticketId));
        token.append(".");
        token.append(LiveSupportServlet.encode(SessionStore.getHttpSession().getId()));
        try {
            String signature = HmacUtils.generateHMAC(token.toString(), secret.toString().getBytes());
            token.append(".");
            token.append(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new ClientMessageException("Error while creating the authentication token: " + e.getMessage());
        }
        return LiveSupportServlet.encode(token.toString());
    }

    public static HttpSession sessionForRequest(HttpServletRequest request) {
        String header = request.getHeader(X_TICKET_TOKEN);
        if (header == null || header.isEmpty() || "null".equals(header)) {
            return null;
        }
        String[] token = LiveSupportServlet.decode(header).split("\\.", 3);
        if (token.length != 3) {
            return null;
        }
        String ticketId = token[0];
        String sessionIdToken = token[1];
        String sessionId = LiveSupportServlet.decode(sessionIdToken);
        String signature = token[2];
        Optional<HttpSession> optionalSession = ExpandableHttpSessionListener.getActiveSessions().parallelStream().filter(s -> s.getId().equals(sessionId)).findFirst();
        if (!optionalSession.isPresent()) {
            return null;
        }
        HttpSession session = optionalSession.get();
        try {
            if (!HmacUtils.verifyHMAC(signature, String.join((CharSequence)".", ticketId, sessionIdToken), session.getAttribute(TICKET_TOKEN_SECRET).toString().getBytes())) {
                return null;
            }
            if (Tickets.decodeTicketID((String)ticketId, (boolean)true) != (Integer)session.getAttribute(TICKET_TOKEN_NAME)) {
                return null;
            }
            String pathInfo = request.getPathInfo();
            if (pathInfo == null || !pathInfo.contains(ticketId)) {
                return null;
            }
        }
        catch (ClassCastException | NullPointerException | InvalidKeyException | NoSuchAlgorithmException e) {
            return null;
        }
        return session;
    }

    @Nonnull
    public String getExtensionName() {
        return LIVE_SUPPORT_WEB_API_ACCESS;
    }
}

