/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.server.ticket.field.definition;

import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.livesupport.server.webapi.LiveSupportWebAPIAccessProvider;
import com.inet.id.GUID;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleFieldEditDefinition
extends FieldEditDefinition {
    private TicketField<String> ticketField;

    public SimpleFieldEditDefinition(TicketField<String> ticketField, TicketFieldDefinition definition) {
        super(definition);
        this.ticketField = ticketField;
    }

    public void updateTicketData(MutableTicketData ticketData, @Nonnull Map<String, String> values) {
        String string = values.get(this.getFieldKey());
        if (string != null) {
            ticketData.put(this.ticketField, (Object)string);
        }
    }

    public void updateCurrentValue(@Nullable TicketVO ticket, @Nullable GUID ownerId, @Nonnull Map<String, String> values) {
        if (ticket == null) {
            return;
        }
        String value = (String)ticket.getFieldOrAttributeValue(this.ticketField);
        if (value != null) {
            values.put(this.getFieldKey(), value);
        }
    }

    public String getFieldKey() {
        return this.ticketField.getKey();
    }

    public String getDisplayType() {
        return "textinput";
    }

    public String getDisplayName() {
        return this.ticketField.getSearchTag().getDisplayName();
    }

    public boolean isAvailable(List<TicketVO> tickets) {
        return LiveSupportWebAPIAccessProvider.isLiveSupportAPIAccess();
    }
}

