/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.server.session;

import com.inet.cache.CacheTimeoutListener;
import com.inet.cache.MemoryStoreMap;
import com.inet.helpdesk.plugins.livesupport.LiveSupportServerPlugin;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import javax.annotation.Nonnull;

public class LiveSupportPreflightSessionCache {
    private static final int TIMEOUT = 15;
    private static final MemoryStoreMap<String, GUID> CACHE = new MemoryStoreMap(15, true);

    public static GUID createSessionAuthToken(String liveSupportId, boolean register) {
        GUID sessionAuthToken = GUID.generateNew();
        if (!register && CACHE.get((Object)liveSupportId) == null) {
            throw new ClientMessageException("The live support id: '" + liveSupportId + "' was not registered before. Did you use a cached script?");
        }
        CACHE.put((Object)liveSupportId, (Object)sessionAuthToken);
        LiveSupportServerPlugin.LOGGER.debug((Object)("UPDATED preflight token: '" + String.valueOf(sessionAuthToken) + "' for live support id: '" + liveSupportId + "'"));
        return sessionAuthToken;
    }

    public static boolean sessionHasAuthToken(@Nonnull String liveSessionId, @Nonnull GUID token) {
        GUID sessionAuthToken = (GUID)CACHE.get((Object)liveSessionId);
        LiveSupportServerPlugin.LOGGER.debug((Object)("CHECKING preflight session token: '" + String.valueOf(sessionAuthToken) + "' = '" + String.valueOf(token) + "' for session id: '" + liveSessionId + "'"));
        if (sessionAuthToken == null) {
            return false;
        }
        return sessionAuthToken.equals((Object)token);
    }

    static {
        CACHE.addTimeoutListener((CacheTimeoutListener)new CacheTimeoutListener<String, GUID>(){

            public void timeout(String liveSupportId, GUID sessionAuthToken) {
                LiveSupportServerPlugin.LOGGER.debug((Object)("REMOVED preflight session token: '" + String.valueOf(sessionAuthToken) + "' for live support id: '" + liveSupportId + "'"));
            }
        });
    }
}

