/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.server;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigValue;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.plugins.livesupport.LiveSupportServerPlugin;
import com.inet.helpdesk.plugins.livesupport.server.LiveSupportActiveSupporterProvider;
import com.inet.helpdesk.plugins.livesupport.server.session.LiveSupportPreflightSessionCache;
import com.inet.helpdesk.plugins.livesupport.server.webapi.LiveSupportWebAPIAccessProvider;
import com.inet.helpdesk.plugins.livesupport.structure.LiveSupportStructureProvider;
import com.inet.helpdesk.plugins.livesupport.utils.LiveSupportAttachmentHelper;
import com.inet.http.PluginDispatcherServlet;
import com.inet.http.PluginServlet;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.persistence.MaintenanceMode;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.veto.VetoManager;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.remote.gui.angular.AngularContentService;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class LiveSupportServlet
extends HttpServlet
implements PluginServlet {
    public static final String LIVE_SUPPORT_CONTEXT = "/livesupport";
    public static final String APP_KEY = "LiveSupport";
    private static FileCombiner FILE_COMBINER;
    public static final ConfigValue<Boolean> CAN_PROVIDE_SUPPORT;
    private static final ConfigValue<Boolean> SHOW_TIME;
    private static final ConfigValue<LiveSupportStructureProvider.VISIBILITY> REQUIRE_USER_NAME;
    private static final ConfigValue<LiveSupportStructureProvider.VISIBILITY> REQUIRE_USER_EMAIL;
    private static final ConfigValue<Long> MAX_ATTACHMENTS_SIZE;
    protected static final String LAST_ACCESS_SESSION_ATTR = "lastAccesTime";
    private static Boolean HAS_ATTACHMENTS;

    @Nonnull
    public String getPathSpec() {
        return LIVE_SUPPORT_CONTEXT;
    }

    public void service(@Nullable HttpServletRequest request, @Nullable HttpServletResponse response) throws ServletException, IOException {
        Objects.requireNonNull(request);
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || StringFunctions.isEmpty((String)pathInfo)) {
            pathInfo = "/";
        }
        request = new HttpServletRequestWrapper((HttpServletRequest)request){

            public String getContextPath() {
                return super.getContextPath() + LiveSupportServlet.LIVE_SUPPORT_CONTEXT;
            }

            public HttpSession getSession() {
                return this.getSession(true);
            }

            public HttpSession getSession(boolean create) {
                HttpSession session = LiveSupportWebAPIAccessProvider.sessionForRequest((HttpServletRequest)this.getRequest());
                if (session == null) {
                    session = super.getSession(create);
                }
                if (session != null) {
                    double maxIntervalTimout = Math.ceil((System.currentTimeMillis() + 300000L - session.getLastAccessedTime()) / 1000L);
                    session.setMaxInactiveInterval((int)maxIntervalTimout);
                }
                return session;
            }

            public Object getAttribute(String name) {
                if ("webapi-access-provider".equals(name)) {
                    return "LiveSupportWebAPIAccess";
                }
                return super.getAttribute(name);
            }
        };
        SessionStore.setHttpServletRequest((HttpServletRequest)request);
        ResponseWriter.ok((HttpServletResponse)response);
        if (pathInfo.startsWith("/lib/")) {
            FileCombiner combiner = LiveSupportServlet.getFileCombiner();
            FileCombiner.CombinedFile combinedFile = combiner.getCombinedFile(pathInfo.substring(5));
            if (combinedFile != null) {
                SequenceInputStream input = new SequenceInputStream(Collections.enumeration(Arrays.asList(new FastByteArrayInputStream("(function(){var $={id:''};".getBytes()), combinedFile.getStream(), new FastByteArrayInputStream(";this[$.id]=$;}).apply(this)".getBytes()))));
                AngularContentService.serveStaticContent((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)input, (long)combinedFile.getLastModified(), (String)combinedFile.getMimeType(), (boolean)combinedFile.isCachingAllowed());
                return;
            }
            ResponseWriter.forbidden((HttpServletResponse)response);
            throw new AccessDeniedException("This ressource is not available.");
        }
        if ("/preflight".equals(pathInfo)) {
            VetoManager vetoManager = VetoManager.getInstance();
            if (vetoManager.isCurrentlyVetoed() || MaintenanceMode.getState() != MaintenanceMode.NONE) {
                ResponseWriter.unavailable((HttpServletResponse)response);
            } else {
                String liveSupportId = "";
                try (ServletInputStream stream = request.getInputStream();){
                    liveSupportId = LiveSupportServlet.decode((String)new Json().fromJson((InputStream)stream, String.class));
                    boolean restart = liveSupportId.substring(liveSupportId.length() - 1).equals("1");
                    GUID sessionAuthToken = LiveSupportPreflightSessionCache.createSessionAuthToken(liveSupportId.substring(0, liveSupportId.length() - 1), restart);
                    ResponseWriter.json((HttpServletResponse)response, this.getConfiguration(sessionAuthToken));
                }
                catch (Throwable e) {
                    LiveSupportServerPlugin.LOGGER.debug((Object)("Preflight request produced error: " + e.getMessage()));
                    ResponseWriter.unavailable((HttpServletResponse)response);
                    return;
                }
            }
            return;
        }
        if (!(pathInfo.startsWith(WebAPIExtension.getCoreServletPathSpac() + "/ticket/") || LiveSupportServlet.hasAttachments() && LiveSupportAttachmentHelper.pathInfoStartsWithAttachmentsServlet(pathInfo))) {
            ResponseWriter.forbidden((HttpServletResponse)response);
            throw new AccessDeniedException("This ressource is not available.");
        }
        this.forward(pathInfo, (HttpServletRequest)request, response);
    }

    protected void forward(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PluginDispatcherServlet.forward((String)path, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    private static synchronized FileCombiner getFileCombiner() {
        if (FILE_COMBINER == null) {
            FILE_COMBINER = new FileCombiner(APP_KEY);
        }
        return FILE_COMBINER;
    }

    private Map<String, Object> getConfiguration(GUID sessionAuthToken) {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        int supporters = LiveSupportActiveSupporterProvider.getResponsibleUsersForResource(LiveSupportWebAPIAccessProvider.getDispatchToRessource()).size();
        configuration.put("canBeProvided", CAN_PROVIDE_SUPPORT.get());
        configuration.put("userName", ((LiveSupportStructureProvider.VISIBILITY)((Object)REQUIRE_USER_NAME.get())).getValue());
        configuration.put("userEmail", ((LiveSupportStructureProvider.VISIBILITY)((Object)REQUIRE_USER_EMAIL.get())).getValue());
        configuration.put("showTime", SHOW_TIME.get());
        configuration.put("textSize", 2000);
        configuration.put("hasSupporter", supporters > 0);
        configuration.put("hasAttachments", LiveSupportServlet.hasAttachments() ? (Long)MAX_ATTACHMENTS_SIZE.get() : Long.valueOf(0L));
        configuration.put("token", sessionAuthToken);
        return configuration;
    }

    public static boolean hasAttachments() {
        if (HAS_ATTACHMENTS == null) {
            HAS_ATTACHMENTS = ServerPluginManager.getInstance().isPluginLoaded("attachments");
        }
        return HAS_ATTACHMENTS;
    }

    public static String encode(String input) {
        return new String(Base64.getEncoder().encode(input.getBytes(StandardCharsets.ISO_8859_1)), StandardCharsets.ISO_8859_1);
    }

    public static String decode(String input) {
        return new String(Base64.getDecoder().decode(input.getBytes(StandardCharsets.ISO_8859_1)), StandardCharsets.ISO_8859_1);
    }

    static {
        CAN_PROVIDE_SUPPORT = new ConfigValue(LiveSupportStructureProvider.LIVE_SUPPORT_CAN_BE_PROVIDED);
        SHOW_TIME = new ConfigValue(LiveSupportStructureProvider.LIVE_SUPPORT_SHOW_TIME);
        REQUIRE_USER_NAME = new ConfigValue(LiveSupportStructureProvider.LIVE_SUPPORT_USER_NAME_REQUIRED);
        REQUIRE_USER_EMAIL = new ConfigValue(LiveSupportStructureProvider.LIVE_SUPPORT_EMAIL_REQUIRED);
        MAX_ATTACHMENTS_SIZE = new ConfigValue(LiveSupportStructureProvider.LIVE_SUPPORT_MAX_ATTACHMENT_SIZE);
        HAS_ATTACHMENTS = null;
    }
}

