/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.server.webapi;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtension;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.livesupport.server.webapi.LiveSupportWebAPIAccessProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LiveSupportCreateTicketExtension
implements CreateTicketExtensionFactory {
    public static final String TICKET_ATTRIBUTE_ENTRY_LIVE_SUPPORT = "LiveSupport";
    private static final List<String> ALLOWED_TICKET_FIELD_NAMES = Arrays.asList("live-support-user-display-name", "live-support-user-email", Tickets.FIELD_SUBJECT.getKey(), ReaStepVO.FIELD_EMAIL_AN.getKey(), Tickets.FIELD_OWNER_GUID.getKey());
    public static final ExtensionArguments.ExtArg<String> LIVE_SUPPORT_PREVIOUS_TICKET = new ExtensionArguments.JsonizableAndImmutableExtArg("ticketextension.livesupport.previous.ticketId", String.class);

    public CreateTicketExtension createIfApplicable(final OperationChangedTicket ticket, final ExtensionArguments arguments, MutableTicketData ticketFields) {
        if (LiveSupportWebAPIAccessProvider.isLiveSupportAPIAccess()) {
            if (arguments.getIncludedExtArgs().stream().filter(e -> !LIVE_SUPPORT_PREVIOUS_TICKET.getKey().equals(e.getKey())).count() > 0L) {
                throw new ClientMessageException("No values expected.");
            }
            if (ticketFields.getIncludedFields().stream().filter(f -> !ALLOWED_TICKET_FIELD_NAMES.contains(f.getKey())).count() > 0L) {
                throw new ClientMessageException("Too many fields given.");
            }
            return new CreateTicketExtension(){

                public void beforeCreate(OperationChangedTicket newTicket, OperationNewReaStep anfrageStep, TicketSubOperations operations) {
                    String previousTicketId;
                    newTicket.getNewTicketAttributes().put((TicketAttribute)Tickets.ATTRIBUTE_EMAIL_EINGANG, (Object)LiveSupportCreateTicketExtension.TICKET_ATTRIBUTE_ENTRY_LIVE_SUPPORT);
                    GUID dispatchTo = LiveSupportWebAPIAccessProvider.getDispatchToRessource();
                    if (dispatchTo != null) {
                        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
                            UserGroupInfo group = UserGroupManager.getInstance().getGroup(dispatchTo);
                            if (group == null || !group.getType().equals((Object)HDUsersAndGroups.RESOURCE) || !group.isActive()) {
                                return;
                            }
                            MutableReaStepData reaStepData = new MutableReaStepData();
                            ExtensionArguments extensionArgs = ExtensionArguments.create();
                            extensionArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, (Object)ExtensionArguments.ResourceActionExtensionData.forEscalationOfActiveTicket((GUID)dispatchTo, (boolean)true));
                            operations.applyAction(ticket, reaStepData, ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(5), extensionArgs);
                        }
                    }
                    if (!StringFunctions.isEmpty((String)(previousTicketId = (String)arguments.get(LIVE_SUPPORT_PREVIOUS_TICKET)))) {
                        Set ticketLinks = (Set)ticket.getFieldValue((TicketField)Tickets.FIELD_LINKS);
                        int previousTicket = Tickets.decodeTicketID((String)previousTicketId, (boolean)true);
                        ticketLinks.add(previousTicket);
                        MutableTicketData ticketFields = MutableTicketData.ofSingle((TicketField)Tickets.FIELD_LINKS, (Object)ticketLinks);
                        operations.updateTicketData(newTicket, ticketFields);
                        try {
                            OperationChangedTicket previousExistingTicket = newTicket.getParentModel().changeExistingTicket(previousTicket);
                            HashSet<Integer> ticketLinks_2 = (HashSet<Integer>)previousExistingTicket.getFieldValue((TicketField)Tickets.FIELD_LINKS);
                            if (ticketLinks_2 == null) {
                                ticketLinks_2 = new HashSet<Integer>();
                            }
                            ticketLinks_2.add(newTicket.getTicketId());
                            MutableTicketData ticketFields_2 = MutableTicketData.ofSingle((TicketField)Tickets.FIELD_LINKS, ticketLinks_2);
                            operations.updateTicketData(previousExistingTicket, ticketFields_2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            };
        }
        return null;
    }

    public int getExecutionPriority() {
        return Integer.MIN_VALUE;
    }
}

