/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.server;

import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.field.Field;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ExpandableHttpSessionListener;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class LiveSupportActiveSupporterProvider {
    private static final int INACTIVE_TIMEOUT = 900000;

    public static List<GUID> getResponsibleUsersForTicket(@Nonnull Integer ticketId) {
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId.intValue());
        if (ticket == null) {
            return Collections.emptyList();
        }
        GUID resource = (GUID)ticket.getFieldOrAttributeValue((Field)Tickets.FIELD_RESOURCE_GUID);
        return LiveSupportActiveSupporterProvider.getResponsibleUsersForResource(resource);
    }

    public static List<GUID> getResponsibleUsersForResource(GUID resource) {
        Optional<Object> findFirst = Optional.empty();
        if (resource != null) {
            findFirst = UserGroupManager.getInstance().getGroups(HDUsersAndGroups.RESOURCE).stream().filter(g -> resource.equals((Object)g.getID())).findFirst();
        }
        UserGroupInfo resourceGroup = findFirst.orElse(null);
        HashSet<GUID> users = LiveSupportActiveSupporterProvider.getActiveUsers();
        users.removeIf(u -> {
            if (resourceGroup == null) {
                UserAccount account = UserManager.getInstance().getUserAccount(u);
                return !HDUsersAndGroups.isDispatcher((UserAccount)account);
            }
            return !HDUsersAndGroups.hasWritePermissionInResource((GUID)u, (UserGroupInfo)resourceGroup) && !SystemPermissionChecker.hasAnyPermission((GUID)u, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ_WRITE});
        });
        return new ArrayList<GUID>(users);
    }

    private static HashSet<GUID> getActiveUsers() {
        HashSet<GUID> ids = new HashSet<GUID>();
        long inactiveLimit = System.currentTimeMillis() - 900000L;
        Collection activeSessions = ExpandableHttpSessionListener.getActiveSessions();
        for (HttpSession httpSession : activeSessions) {
            try {
                GUID userAccountID;
                LoginProcessor loginProcessor;
                if (httpSession.getLastAccessedTime() < inactiveLimit || !((loginProcessor = LoginManager.getLoginProcessor((HttpSession)httpSession)) instanceof LoginProcessor) || (userAccountID = loginProcessor.getUserAccountID()) == null) continue;
                ids.add(userAccountID);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return ids;
    }
}

