/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport;

import com.inet.classloader.I18nMessages;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.SearchTagTicketTags;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.plugins.livesupport.server.LiveSupportServlet;
import com.inet.helpdesk.plugins.livesupport.server.session.LiveSupportSessionClearer;
import com.inet.helpdesk.plugins.livesupport.server.taskplanner.LiveSupportCanBeProvidedTaskPlannerActionFactory;
import com.inet.helpdesk.plugins.livesupport.server.taskplanner.LiveSupportCanBeProvidedTaskTemplateDefinition;
import com.inet.helpdesk.plugins.livesupport.server.ticket.LiveSupportApplyRendererExtension;
import com.inet.helpdesk.plugins.livesupport.server.ticket.LiveSupportTicketActionExtension;
import com.inet.helpdesk.plugins.livesupport.server.ticket.LiveSupportTicketTag;
import com.inet.helpdesk.plugins.livesupport.server.ticket.LiveSupportView;
import com.inet.helpdesk.plugins.livesupport.server.ticket.field.definition.LiveSupportUserDisplayNameTicketFieldDefinition;
import com.inet.helpdesk.plugins.livesupport.server.ticket.field.definition.LiveSupportUserEmailTicketFieldDefinition;
import com.inet.helpdesk.plugins.livesupport.server.webapi.LiveSupportCreateTicketExtension;
import com.inet.helpdesk.plugins.livesupport.server.webapi.LiveSupportWebAPIAccessProvider;
import com.inet.helpdesk.plugins.livesupport.structure.LiveSupportStructureProvider;
import com.inet.helpdesk.plugins.livesupport.structure.LiveSupportThemeStructureProvider;
import com.inet.helpdesk.plugins.livesupport.utils.LiveSupportCombinedFile;
import com.inet.helpdesk.plugins.livesupport.utils.LiveSupportThemeService;
import com.inet.http.PluginServlet;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.permissions.Permission;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.veto.VetoType;
import com.inet.plugin.webapi.api.WebAPIAccessProvider;
import com.inet.search.veto.UserSearchIndexVetoPower;
import jakarta.servlet.http.HttpSessionListener;
import java.net.URL;
import java.sql.SQLException;
import javax.annotation.Nullable;

@PluginInfo(dependencies="helpdesk;webapi.core;remotegui", optionalDependencies="help;theme;taskplanner;attachments;ticketlist;fieldsettings", group="tickets", id="livesupport", flags="optional", icon="com/inet/helpdesk/plugins/livesupport/structure/livesupport_48.png", version="25.10.219")
public class LiveSupportServerPlugin
implements ServerPlugin,
ServerPluginManagerListener {
    public static final String LIVESUPPORT_JS = "livesupport.js";
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.livesupport.structure.i18n.ConfigStructure", LiveSupportServerPlugin.class);
    public static final Logger LOGGER = LogManager.getLogger((String)"LiveSupport");

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("livesupport", 1432, new Permission[]{null}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("configuration", 9432, new Permission[]{Permission.CONFIGURATION}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("programming", 9433, new Permission[]{Permission.CONFIGURATION}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("taskplanner", 9434, new Permission[]{Permission.valueOfExistingOrCreate((String)"taskplanner")}){}, new String[0]);
    }

    public void registerExtension(final ServerPluginManager spm) {
        spm.register(ServerPluginManagerListener.class, (Object)this);
        spm.register(ConfigStructureProvider.class, (Object)new LiveSupportStructureProvider());
        spm.register(WebAPIAccessProvider.class, (Object)new LiveSupportWebAPIAccessProvider());
        spm.register(CreateTicketExtensionFactory.class, (Object)new LiveSupportCreateTicketExtension());
        spm.register(TicketViewFactory.class, (Object)new LiveSupportView());
        spm.register(SearchTagTicketTags.TicketTag.class, (Object)new LiveSupportTicketTag());
        LiveSupportSessionClearer liveSupportSessionClearer = new LiveSupportSessionClearer();
        spm.register(HttpSessionListener.class, (Object)liveSupportSessionClearer);
        spm.register(TicketActionExtensionFactory.class, (Object)new LiveSupportTicketActionExtension());
        spm.register(TicketField.class, LiveSupportTicketActionExtension.USER_DISPLAY_NAME);
        spm.register(TicketField.class, LiveSupportTicketActionExtension.USER_EMAIL);
        spm.register(ExtensionArguments.ExtArg.class, LiveSupportCreateTicketExtension.LIVE_SUPPORT_PREVIOUS_TICKET);
        spm.register(TicketFieldDefinition.class, (Object)new LiveSupportUserDisplayNameTicketFieldDefinition(5));
        spm.register(TicketFieldDefinition.class, (Object)new LiveSupportUserEmailTicketFieldDefinition(6));
        spm.register(PluginServlet.class, (Object)new LiveSupportServlet());
        LiveSupportCombinedFile combinedFile = new LiveSupportCombinedFile();
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("LiveSupport", 1, LIVESUPPORT_JS, (FileCombiner.CombinedFile)combinedFile));
        combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        combinedFile.add(LiveSupportServerPlugin.class, "client/js/lib/fetch-promise.min.js");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("LiveSupport", 1, "livesupport-fetch-promise.js", (FileCombiner.CombinedFile)combinedFile));
        spm.runIfPluginLoaded("theme", () -> new Executable(){

            public void execute() {
                LiveSupportThemeService.registerExtension(spm);
                spm.register(ConfigStructureProvider.class, (Object)new LiveSupportThemeStructureProvider());
            }
        });
        spm.runIfPluginLoaded("ticketlist", () -> new Executable(){

            public void execute() {
                LiveSupportApplyRendererExtension.registerExtension(spm);
            }
        });
        spm.runIfPluginLoaded("taskplanner", () -> new Executable(){

            public void execute() {
                LiveSupportCanBeProvidedTaskPlannerActionFactory.registerExtension(spm);
                LiveSupportCanBeProvidedTaskTemplateDefinition.registerExtension(spm, Boolean.TRUE);
                LiveSupportCanBeProvidedTaskTemplateDefinition.registerExtension(spm, Boolean.FALSE);
            }
        });
    }

    public void vetoFinished(@Nullable VetoType type) {
        if (type != UserSearchIndexVetoPower.TYPE) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (ActionVO actionVO : LiveSupportTicketActionExtension.LIST_OF_LIVE_SUPPORT_ACTIONS) {
            ActionVO _actionVO = (ActionVO)actionManager.get(actionVO.getId());
            try {
                if (_actionVO == null) {
                    actionManager.add(actionVO);
                    continue;
                }
                if (!_actionVO.isDeleted()) continue;
                actionManager.update(actionVO);
            }
            catch (SQLException e) {
                LOGGER.error((Throwable)e);
            }
        }
    }

    public void init(ServerPluginManager spm) {
    }

    public void reset() {
    }

    public void restart() {
    }
}

