/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.server.ticket;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.livesupport.LiveSupportServerPlugin;
import com.inet.helpdesk.plugins.livesupport.server.LiveSupportServlet;
import com.inet.helpdesk.plugins.livesupport.server.ticket.extension.LiveSupportFinishTicketAndTransformToRegularTicket;
import com.inet.helpdesk.plugins.livesupport.server.ticket.extension.LiveSupportTransformToRegularTicketExtension;
import com.inet.helpdesk.plugins.livesupport.server.ticket.field.LiveSupportTicketFieldUserDisplayName;
import com.inet.helpdesk.plugins.livesupport.server.ticket.field.LiveSupportTicketFieldUserEmail;
import com.inet.helpdesk.plugins.livesupport.server.webapi.LiveSupportWebAPIAccessProvider;
import com.inet.helpdesk.plugins.livesupport.utils.LiveSupportAttachmentHelper;
import com.inet.helpdesk.shared.model.Status;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.SessionStore;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class LiveSupportTicketActionExtension
implements TicketActionExtensionFactory {
    private static final int LIVE_SUPPORT_SUPPORTER_ACTION_ID = -123;
    private static final int LIVE_SUPPORT_CONVERT_TO_TICKET_ID = -124;
    private static final int LIVE_SUPPORT_FINISH_CONVERT_TO_TICKET_ID = -125;
    public static final ActionVO LIVE_SUPPORT_SUPPORTER_ACTION = new ActionVO(-123, "Live Support Antwort", 200, true, 0, 0, 0.0, false, 0, false);
    public static final ActionVO LIVE_SUPPORT_CONVERT_TO_TICKET = new ActionVO(-124, "Live Support in Ticket umwandeln", 100, true, 0, 0, 0.0, false, 0, false);
    public static final ActionVO LIVE_SUPPORT_FINISH_CONVERT_TO_TICKET = new ActionVO(-125, "Beenden und in Ticket umwandeln", 300, true, 0, 0, 0.0, false, 0, false);
    public static final List<ActionVO> LIST_OF_LIVE_SUPPORT_ACTIONS = List.of(LIVE_SUPPORT_SUPPORTER_ACTION, LIVE_SUPPORT_CONVERT_TO_TICKET, LIVE_SUPPORT_FINISH_CONVERT_TO_TICKET);
    public static final TicketField<String> USER_DISPLAY_NAME = new LiveSupportTicketFieldUserDisplayName();
    public static final TicketField<String> USER_EMAIL = new LiveSupportTicketFieldUserEmail();
    private static final ConfigValue<Integer> CONTENT_CHANGEABLE = new ConfigValue(HDConfigKeys.PROCESSING_CONTENT_CHANGEABLE_WHEN_CLOSED);
    private static final List<Integer> ALLOWED_ACTIONS_FOR_SUPPORT = Arrays.asList(-123, -124, -125, 2, 7, 5, 8, -10, -31, -17, -15, -26, -27, -28, 3, -30, -29, -6, -22, -16);
    private static final List<Integer> ALLOWED_ACTIONS_FOR_CLIENT = Arrays.asList(-12, 2);

    public TicketActionExtension createIfApplicable(@Nonnull OperationChangedTicket ticket, @Nonnull ActionVO action, @Nonnull ExtensionArguments arguments, @Nonnull MutableReaStepData reaStepData) {
        int actionID = action.getId();
        if (!LiveSupportWebAPIAccessProvider.isLiveSupportAPIAccess()) {
            if (ticket.getOldTicket().isPresent() && "LiveSupport".equalsIgnoreCase(((TicketVO)ticket.getOldTicket().get()).getEmailEingang())) {
                switch (actionID) {
                    case -124: {
                        return new LiveSupportTransformToRegularTicketExtension();
                    }
                    case -125: {
                        return new LiveSupportFinishTicketAndTransformToRegularTicket();
                    }
                }
            }
            return null;
        }
        Set extArgs = arguments.getIncludedExtArgs();
        Set fields = reaStepData.getIncludedFields();
        String pathInfo = "";
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        if (httpServletRequest != null) {
            pathInfo = Objects.requireNonNullElse(httpServletRequest.getPathInfo(), "");
        }
        if (actionID == 5 && extArgs.size() == 1 && extArgs.contains(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA) && pathInfo.endsWith("create") && fields.size() == 0) {
            return null;
        }
        if (ALLOWED_ACTIONS_FOR_CLIENT.contains(actionID)) {
            boolean throwException;
            Set<ExtensionArguments.ExtArg<Object>> collectedExtArgs = extArgs.stream().filter(e -> !e.getClass().isAssignableFrom(ExtensionArguments.JsonizableAndImmutableExtArg.class)).collect(Collectors.toSet());
            boolean bl = throwException = !collectedExtArgs.isEmpty();
            if (actionID == -12 && collectedExtArgs.size() == 1 && LiveSupportServlet.hasAttachments()) {
                boolean bl2 = throwException = !LiveSupportAttachmentHelper.hasAttachmentExtensionArgument(collectedExtArgs);
            }
            if (throwException) {
                if (LiveSupportServerPlugin.LOGGER.isDebug()) {
                    LiveSupportServerPlugin.LOGGER.debug((Object)("No values expected. Given values: " + String.join((CharSequence)", ", extArgs.stream().map(e -> e.getKey()).collect(Collectors.toList()))));
                }
                throw new ClientMessageException("No values expected.");
            }
        }
        int count = 0;
        count += fields.contains(ReaStepVO.FIELD_PROCESSING_TIME) ? 1 : 0;
        if (ALLOWED_ACTIONS_FOR_CLIENT.contains(actionID) && fields.size() > 0) {
            count += fields.contains(ReaStepVO.FIELD_EMAIL_IN) ? 1 : 0;
            if (fields.size() == (count += fields.contains(ReaStepVO.FIELD_USER_DISPLAY_NAME) ? 1 : 0)) {
                return null;
            }
        }
        if (fields.size() > count) {
            if (LiveSupportServerPlugin.LOGGER.isDebug()) {
                LiveSupportServerPlugin.LOGGER.debug((Object)("Too many fields given. Given fields: " + String.join((CharSequence)", ", fields.stream().map(e -> e.getKey()).collect(Collectors.toList()))));
            }
            throw new ClientMessageException("Too many fields given.");
        }
        if (actionID == -2) {
            throw new ClientMessageException("Ticket already closed.");
        }
        return null;
    }

    public String checkActionPreconditions(TicketVO ticket, ActionVO action, TicketPermissionContext ticketPermissionInfo) {
        if (ticket == null || action == null) {
            return LiveSupportServerPlugin.MSG.getMsg("livesupport.action.emptyAction", new Object[0]);
        }
        if (!"LiveSupport".equalsIgnoreCase(ticket.getEmailEingang())) {
            return null;
        }
        boolean apiAccess = LiveSupportWebAPIAccessProvider.isLiveSupportAPIAccess();
        if (apiAccess && ticket.getStatusID() == 0 && LiveSupportWebAPIAccessProvider.getDispatchToRessource() != null && action.getId() == 5) {
            return null;
        }
        if (apiAccess && !ALLOWED_ACTIONS_FOR_CLIENT.contains(action.getId())) {
            return LiveSupportServerPlugin.MSG.getMsg("livesupport.action.forbiddenForClient", new Object[0]);
        }
        if (!apiAccess && !ALLOWED_ACTIONS_FOR_SUPPORT.contains(action.getId())) {
            return LiveSupportServerPlugin.MSG.getMsg("livesupport.action.forbiddenForSupporter", new Object[0]);
        }
        if ((Integer)CONTENT_CHANGEABLE.get() != 2 && Status.isClosedOrDeletedStatus((int)ticket.getStatusID()) && action.getId() == LIVE_SUPPORT_CONVERT_TO_TICKET.getId()) {
            return LiveSupportServerPlugin.MSG.getMsg("livesupport.action.conversionNotAvailable", new Object[0]);
        }
        return null;
    }

    public List<ActionVO> additionalActionsForTicket(TicketVO ticket) {
        if (!"LiveSupport".equalsIgnoreCase(ticket.getEmailEingang())) {
            return Collections.emptyList();
        }
        boolean apiAccess = LiveSupportWebAPIAccessProvider.isLiveSupportAPIAccess();
        if (apiAccess) {
            return Collections.emptyList();
        }
        if (Status.isClosedStatus((int)ticket.getStatusID())) {
            return Arrays.asList(this.transformAction(-124));
        }
        return Arrays.asList(this.transformAction(-123), this.transformAction(-125));
    }

    private ActionVO transformAction(int actionId) {
        ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionId);
        if (actionVO == null) {
            throw new IllegalStateException("The live support action is missing: " + actionId);
        }
        return new ActionVO(actionId, actionVO.getDisplayValue(), actionVO.getStatusID(), false, actionVO.getBillingType(), actionVO.getLumpSumType(), actionVO.getFixedCharge(), actionVO.isDeleted(), actionVO.getSpecial(), actionVO.isHidden());
    }

    public int getExecutionPriority() {
        return Integer.MIN_VALUE;
    }
}

