/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.model.ticket.FormField;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachment;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachmentConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseUtils;
import com.inet.helpdesk.plugins.knowledgebase.server.ai.kbcreator.KnowledgeBaseEntryCreationExecutor;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.AbstractKnowledgeBaseHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.DataHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.FieldCondition;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.GetArticleFieldsRequestData;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.GetArticleFieldsResponseData;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ai.api.AIProviderManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GetArticleFields
extends AbstractKnowledgeBaseHandler<GetArticleFieldsRequestData, GetArticleFieldsResponseData> {
    public String getMethodName() {
        return "web_knowledgebase_getarticlefields";
    }

    @Override
    protected GetArticleFieldsResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, GetArticleFieldsRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        Article article;
        if (!SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_EDIT_DELETE)) {
            throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.forbidden.edit", new Object[0]));
        }
        Article article2 = article = input.getArticleId() == -1 ? null : this.getArticleIfPermitted(input.getArticleId(), currentUser);
        if (article == null && input.getTicketId() != -1) {
            boolean useAI = input.isUseAI();
            article = useAI ? new KnowledgeBaseEntryCreationExecutor(input.getTicketId(), input.getClientId(), AIProviderManager.getInstance()).getAIGeneratedArticle() : this.convertTicketToArticle(input.getTicketId(), request);
        }
        ArrayList<Entry> languages = DataHandler.getLanguageEntries();
        Map locations = HDUsersAndGroups.FIELD_LOCATION_ID.getSearchTag().getMapData();
        ArrayList<FormField> fields = new ArrayList<FormField>();
        fields.add(new FormField(Article.ArticleKeys.ARTICLE_TITLE.name(), article == null ? "" : article.getTitle(), null, null, null, 3, 0, -1));
        int categoryId = article == null ? 0 : article.getCategoryId();
        ArrayList<Entry> categories = DataHandler.getCategoryEntries();
        Entry category = this.findKeyEntry(categories, categoryId);
        int typeCategoryId = 4;
        if (category != null) {
            fields.add(new FormField(Article.ArticleKeys.ARTICLE_CATEGORYID.name(), String.valueOf(category.getId()), category.getDisplayName(), null, null, 3, 2, typeCategoryId));
        } else {
            String displayName = null;
            try {
                displayName = CategoryManager.getInstance().findCategoryPathOrThrow(Integer.valueOf(categoryId));
            }
            catch (Throwable t) {
                displayName = KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.category.deleted.missing", new Object[]{String.valueOf(categoryId)});
            }
            fields.add(new FormField(Article.ArticleKeys.ARTICLE_CATEGORYID.name(), String.valueOf(categoryId), displayName, null, null, 3, 2, typeCategoryId));
        }
        Entry language = null;
        String languageStr = null;
        languageStr = article != null ? article.getLanguageId() : ClientLocale.getThreadLocale().getLanguage().toLowerCase();
        language = this.findStringKeyEntry(languages, languageStr);
        if (language == null) {
            languageStr = "en";
            language = this.findStringKeyEntry(languages, languageStr);
        }
        if (language == null) {
            languageStr = Locale.getDefault().getLanguage().toLowerCase();
            language = this.findStringKeyEntry(languages, languageStr);
        }
        if (language == null && languages.size() > 0) {
            language = languages.get(0);
        }
        int languageTypeId = 18;
        fields.add(new FormField(Article.ArticleKeys.ARTICLE_LANGUAGEID.name(), language == null ? languageStr : language.getStringKey(), language == null ? null : language.getDisplayName(), null, null, 3, 2, languageTypeId));
        PublishState ps = article == null ? PublishState.INREVIEW : article.getPublishState();
        String psDisplayName = "";
        psDisplayName = ps == PublishState.LOCATION ? HDUsersAndGroups.FIELD_LOCATION_ID.getLabel() : KnowledgeBaseServerPlugin.CLIENT_MSG.getMsg("knowledgebase.PublishState." + ps.name(), new Object[0]);
        int publishStateTypeId = 19;
        fields.add(new FormField(Article.ArticleKeys.ARTICLE_PUBLISHSTATE.name(), ps.name(), psDisplayName, null, null, 3, 2, publishStateTypeId));
        Integer locationId = article == null || article.getLocationId() == -1 ? 0 : article.getLocationId();
        String locationDisplayName = (String)locations.get(locationId);
        int locationTypeId = 5;
        LocationVO locationVO = (LocationVO)LocationManager.getInstance().get(locationId.intValue());
        String image = locationVO != null && locationVO.isDeleted() ? "-1" : null;
        fields.add(new FormField(Article.ArticleKeys.ARTICLE_LOCATIONID.name(), locationDisplayName == null ? "0" : String.valueOf(locationId), locationDisplayName == null ? null : locationDisplayName, null, image, 0, 2, locationTypeId));
        String problem = KnowledgeBaseUtils.convertAttachmentPathsToClient(article == null ? "" : article.getProblem());
        fields.add(new FormField(Article.ArticleKeys.ARTICLE_PROBLEM.name(), problem, null, null, null, 64, 1, -1));
        String solution = KnowledgeBaseUtils.convertAttachmentPathsToClient(article == null ? "" : article.getSolution());
        fields.add(new FormField(Article.ArticleKeys.ARTICLE_SOLUTION.name(), solution, null, null, null, 67, 1, -1));
        List<KnowledgeBaseAttachment> attachments = null;
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            if (input.getTicketId() != -1) {
                attachments = KnowledgeBaseUtils.getTicketAttachments(input.getTicketId());
            } else {
                KnowledgeBaseAttachmentConnector kbac = (KnowledgeBaseAttachmentConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseAttachmentConnector.class);
                attachments = kbac.getAttachments(input.getArticleId(), true);
            }
            fields.add(new FormField("ARTICLE_ATTACHMENTS", "", null, null, null, 0, -1, -1));
        }
        if (ServerPluginManager.getInstance().isPluginLoaded("ticketlist")) {
            FormField refTicketField = new FormField(Article.ArticleKeys.ARTICLE_REFTICKETID.name(), article == null || article.getRefTicketId() < 0 ? "" : String.valueOf(article.getRefTicketId()), null, null, null, 0, 0, -1);
            fields.add(refTicketField);
        }
        HashMap<String, FieldCondition> conditions = new HashMap<String, FieldCondition>();
        conditions.put(Article.ArticleKeys.ARTICLE_LOCATIONID.name(), FieldCondition.visible(Article.ArticleKeys.ARTICLE_PUBLISHSTATE.name(), FieldCondition.OP.equals, PublishState.LOCATION.name()));
        GetArticleFieldsResponseData articleFieldResponse = new GetArticleFieldsResponseData(fields, conditions, attachments);
        return articleFieldResponse;
    }

    private Article convertTicketToArticle(int ticketId, HttpServletRequest request) throws ServerDataException {
        try {
            TicketVO ticket = TicketManager.getReader().getTicket(ticketId);
            if (ticket == null) {
                throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.ticketnotfound", new Object[0]));
            }
            ServerValuesConnector svc = (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
            Font defaultFont = svc.getDefaultFont();
            Article articleFromTicket = KnowledgeBaseUtils.getArticleFromTicket(ticketId, defaultFont);
            articleFromTicket.setPublishState(PublishState.INREVIEW);
            return articleFromTicket;
        }
        catch (AccessDeniedException e) {
            throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.ticketforbidden", new Object[0]));
        }
        catch (Exception e) {
            throw new ServerDataException(e);
        }
    }

    private Entry findKeyEntry(ArrayList<Entry> data, int key) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        for (Entry e : data) {
            Entry found;
            if (e.getId() == key) {
                return e;
            }
            ArrayList children = e.getChildren();
            if (children == null || (found = this.findKeyEntry(children, key)) == null) continue;
            return found;
        }
        return null;
    }

    private Entry findStringKeyEntry(ArrayList<Entry> data, String stringKey) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        for (Entry e : data) {
            Entry found;
            if (e.getStringKey().equals(stringKey)) {
                return e;
            }
            ArrayList children = e.getChildren();
            if (children == null || (found = this.findStringKeyEntry(children, stringKey)) == null) continue;
            return found;
        }
        return null;
    }
}

