/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseUtils;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public abstract class AbstractKnowledgeBaseHandler<InputType, OutputType>
extends ServiceMethod<InputType, OutputType> {
    public short getMethodType() {
        return 1;
    }

    public OutputType invoke(HttpServletRequest req, HttpServletResponse resp, InputType payload) throws IOException {
        try {
            return this.handleRequest(req, resp, payload, UserManager.getInstance().getCurrentUserAccount());
        }
        catch (ServerDataException e) {
            KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
            Throwable cause = e;
            if (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof ClientMessageException) {
                throw (ClientMessageException)cause;
            }
            throw new ClientMessageException(cause.getMessage());
        }
    }

    protected abstract OutputType handleRequest(HttpServletRequest var1, HttpServletResponse var2, InputType var3, UserAccount var4) throws ClientMessageException, ServerDataException;

    protected Article getArticleIfPermitted(int articleId, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        KnowledgeBaseConnector knowledgeBaseConnector = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
        Article article = knowledgeBaseConnector.getArticle(articleId);
        KnowledgeBaseUtils.checkPermissionToReadArticle(currentUser, article);
        return article;
    }
}

