/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.api;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AccessForbiddenException;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachment;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseUtils;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.List;

@InternalApi
public interface KnowledgeBaseAttachmentConnector {
    public static final AttachmentOwnerType KNOWLEDGE_BASE_ATTACHMENTS = new AttachmentOwnerType(18, "knowledgebase"){

        public String getDisplayName() {
            return KnowledgeBaseServerPlugin.MSG.getMsg("datacare.attachment.detail.type.knowledgebase", new Object[0]);
        }

        public void checkPermission(UserAccount userAccount, AttachmentKey key) throws AccessForbiddenException {
            KnowledgeBaseConnector c = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
            try {
                Article article = c.getArticle(key.getOwnerId());
                KnowledgeBaseUtils.checkPermissionToReadArticle(userAccount, article);
            }
            catch (ServerDataException e) {
                throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("attachment.cannotaccess", new Object[0]));
            }
        }
    };

    public void updateArticleAttachments(int var1, LargeContent[] var2, List<KnowledgeBaseAttachment> var3, List<KnowledgeBaseAttachment> var4) throws ServerDataException;

    public List<KnowledgeBaseAttachment> getAttachments(int var1, boolean var2) throws ServerDataException;

    public void deleteAttachment(int var1, String var2) throws ServerDataException;

    public void deleteAllAttachments(int var1) throws ServerDataException;
}

