/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.ArticleSearchResult;
import com.inet.helpdesk.plugins.knowledgebase.api.Category;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.AbstractKnowledgeBaseHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.ArticlePreview;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.GetFuzzySearchRequest;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.GetFuzzySearchResponse;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.FuzzySearch;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GetFuzzySearchHandler
extends AbstractKnowledgeBaseHandler<GetFuzzySearchRequest, GetFuzzySearchResponse> {
    private static final int MAX_ENTRIES = 5;

    public String getMethodName() {
        return "web_knowledgebase_getfuzzysearch";
    }

    @Override
    protected GetFuzzySearchResponse handleRequest(HttpServletRequest request, HttpServletResponse response, GetFuzzySearchRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        ArrayList<ArticlePreview> resultArticles;
        block9: {
            Object phrase;
            Set<Integer> favoriteArticleIds;
            KnowledgeBaseConnector connector;
            block8: {
                Integer id;
                Article article;
                TicketVO ticket;
                connector = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
                resultArticles = new ArrayList<ArticlePreview>();
                if (!SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE})) {
                    return new GetFuzzySearchResponse(resultArticles);
                }
                favoriteArticleIds = connector.getFavoriteArticleIds(HDUsersAndGroups.getUserID((UserAccount)currentUser));
                phrase = input.getPhrase();
                if (phrase == null) {
                    phrase = "";
                }
                if (!((String)phrase).isEmpty()) break block8;
                Integer ticketId = input.getTicketId();
                if (ticketId != null && (ticket = TicketManager.getReader().getTicket(ticketId.intValue())) != null) {
                    String reaStepText;
                    phrase = (String)phrase + ticket.getSubject();
                    ReaStepTextVO reaStep = TicketManager.getReader().getReaStepText(ticket.getInitialReaStepID());
                    if (reaStep != null && (reaStepText = reaStep.getText()) != null) {
                        if (!((String)phrase).endsWith(" ")) {
                            phrase = (String)phrase + " ";
                        }
                        if (reaStep.hasHtmlContent()) {
                            reaStepText = HtmlConverter.html2text((String)reaStepText);
                        }
                        phrase = (String)phrase + reaStepText;
                    }
                }
                if (((String)phrase).isEmpty()) break block9;
                FuzzySearch<Integer> search = connector.createFuzzySearch(Article.ArticleKeys.ARTICLE_PROBLEM, Article.ArticleKeys.ARTICLE_SOLUTION, Article.ArticleKeys.ARTICLE_TITLE);
                List result = search.search((String)phrase);
                List<Category> articleCategories = connector.getArticleCategories(currentUser, new HashSet<Integer>(result), -1);
                Iterator iterator = result.iterator();
                while (iterator.hasNext() && !this.createResultArticle(resultArticles, article = connector.getArticle(id = (Integer)iterator.next()), articleCategories, favoriteArticleIds)) {
                }
                break block9;
            }
            ArticleSearchResult searchArticles = connector.searchArticles(currentUser, (String)phrase, "", -1, "", 5);
            List<Article> articles = searchArticles.getArticles();
            for (Article article : articles) {
                if (this.createResultArticle(resultArticles, article, searchArticles.getCategories(), favoriteArticleIds)) break;
            }
        }
        return new GetFuzzySearchResponse(resultArticles);
    }

    public boolean createResultArticle(ArrayList<ArticlePreview> resultArticles, Article article, List<Category> articleCategories, Set<Integer> favoriteArticleIds) {
        Category category = articleCategories.stream().filter(c -> c.getId() == article.getCategoryId()).findFirst().orElse(null);
        String categoryName = category != null ? category.getDisplayName() : KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.category.none", new Object[0]);
        resultArticles.add(new ArticlePreview(article.getArticleId(), article.getTitle(), categoryName, article.getLastModified(), article.isPinned(), favoriteArticleIds.contains(article.getArticleId())));
        return resultArticles.size() >= 5;
    }
}

