/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.config.ConfigValue;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.ArticleSearchResult;
import com.inet.helpdesk.plugins.knowledgebase.api.Category;
import com.inet.helpdesk.plugins.knowledgebase.api.Feedback;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseUtils;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.i18n.DisplayableKey;
import com.inet.lib.i18n.DisplayableMapCache;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.veto.VetoPower;
import com.inet.plugin.veto.VetoSemaphore;
import com.inet.plugin.veto.VetoType;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.FuzzySearch;
import com.inet.search.SearchDataCache;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.search.SearchDataType;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.SearchTag;
import com.inet.search.SuggestedValue;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.IndexerStatus;
import com.inet.search.tokenizers.HtmlSearchTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import com.inet.search.veto.SearchIndexVeto;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class KnowledgeBaseConnectorImpl
extends AbstractSearchDataCache<Integer>
implements KnowledgeBaseConnector,
VetoPower {
    private static final String KNOWLEDGE_BASE_INDEX_VERSION = "Index:2.3";
    private static final String SQL_GET_COUNT_OF_ALL_ARTICLE_IDS = "SELECT COUNT(articleId) FROM tblKnowledgeBase";
    private static final String SQL_GET_ALL_ARTICLE_IDS = "SELECT articleId FROM tblKnowledgeBase";
    static final String SQL_GET_ALL_ARTICLE_CATEGORYIDS = "SELECT articleId, categoryId FROM tblKnowledgeBase";
    static final String SQL_GET_ALL_ARTICLES_WITH_DELETED_CATEGORIES = "SELECT articleId, categoryId FROM tblKnowledgeBase LEFT OUTER JOIN tblBetreffs ON categoryId = BetID WHERE BetID IS NULL OR geloescht<>0";
    private static final String SQL_GET_ALL_LOCATIONS = "SELECT locationId FROM tblKnowledgeBase GROUP BY locationId";
    static final String SQL_GET_ALL_ARTICLE_LANGUAGES = "SELECT articleId, languageId, Sprache FROM tblKnowledgeBase LEFT OUTER JOIN tblSprachen ON tblKnowledgeBase.languageId = tblSprachen.SprID";
    static final String SQL_GET_ARTICLE = "SELECT * FROM tblKnowledgeBase LEFT OUTER JOIN tblKnowledgeBaseProblem ON tblKnowledgeBase.articleId = tblKnowledgeBaseProblem.articleId WHERE tblKnowledgeBase.articleId=?";
    static final String SQL_GET_ARTICLE_FOR_INSERT = "SELECT * FROM tblKnowledgeBase WHERE articleId=?";
    private static final String SQL_GET_ARTICLEPROBLEM_FOR_INSERT = "SELECT * FROM tblKnowledgeBaseProblem WHERE articleId=?";
    static final String SQL_GET_FAVORITE_ARTICLES_FOR_USERID = "SELECT articleId FROM tblKnowledgeBaseFavorites WHERE userId=?";
    static final String SQL_GET_FAVORITE_ARTICLES_FOR_USERID_AND_ARTICLEID = "SELECT * FROM tblKnowledgeBaseFavorites WHERE userId=? AND articleId=?";
    private static final String SQL_GET_FEEDBACK_FOR_USERID = "SELECT * FROM tblKnowledgeBaseFeedback WHERE userId=? AND articleId=?";
    private static final String SQL_GET_FEEDBACK_FOR_ARTICLEID = "SELECT COUNT(userId) AS votes, rating FROM tblKnowledgeBaseFeedback WHERE articleId=? GROUP BY rating";
    static final String SQL_DELETE_ARTICLE = "DELETE FROM tblKnowledgeBase WHERE articleId=?";
    static final String SQL_DELETE_ARTICLEPROBLEM = "DELETE FROM tblKnowledgeBaseProblem WHERE articleId=?";
    static final String SQL_DELETE_ARTICLEFAVORITES = "DELETE FROM tblKnowledgeBaseFavorites WHERE articleId=?";
    static final String SQL_DELETE_ARTICLEFEEDBACK = "DELETE FROM tblKnowledgeBaseFeedback WHERE articleId=?";
    private static final ConfigValue<DatabaseConfigInfoList> DB_LIST = new ConfigValue(HDConfigKeys.DB_CONFIGS);
    private final MemoryStoreMap<Integer, Map> knowledgeBaseCache = new MemoryStoreMap(900, true);
    private IndexSearchEngine<Integer> searchEngine;
    private KnowledgeBaseConnector.KnowledgeBaseIndexer indexer = new KnowledgeBaseIndexerImpl();
    private ConnectionFactory connectionFactory;
    private final SearchIndexVeto kbIndexVeto = new SearchIndexVeto("Knowledge Base Index");
    private final AtomicBoolean startedInitialization = new AtomicBoolean(false);
    private boolean alreadyInitialized = false;

    private IndexSearchEngine<Integer> createSearchEngine() {
        DatabaseConfigInfo hds = ((DatabaseConfigInfoList)DB_LIST.get()).get("HDS");
        String reindexKey = null;
        if (hds != null) {
            reindexKey = hds.getUrl() + ";" + hds.getUser() + ";Index:2.3";
        }
        return new IndexSearchEngine("knowledgebase", reindexKey, true, Integer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws IOException {
        KnowledgeBaseConnectorImpl knowledgeBaseConnectorImpl = this;
        synchronized (knowledgeBaseConnectorImpl) {
            if (this.alreadyInitialized) {
                return;
            }
            boolean tableExists = false;
            try (Connection con = this.getConnection();
                 Statement stm = con.createStatement();
                 ResultSet rs = stm.executeQuery(SQL_GET_COUNT_OF_ALL_ARTICLE_IDS);){
                if (rs.next()) {
                    tableExists = true;
                }
            }
            catch (SQLException sqle) {
                KnowledgeBaseServerPlugin.LOGGER.error((Throwable)sqle);
            }
            if (!tableExists) {
                KnowledgeBaseServerPlugin.LOGGER.error((Object)"Could not initialize cache and index. Knowledge base tables may be missing.");
                return;
            }
            this.alreadyInitialized = true;
        }
        this.searchEngine = this.createSearchEngine();
        TextSearchTokenizer textTok = TextSearchTokenizer.DEFAULT;
        HtmlSearchTokenizer htmlTok = new HtmlSearchTokenizer();
        try {
            SearchTag artikleId = new SearchTag(Article.ArticleKeys.ARTICLE_ID.name(), (SearchTokenizer)textTok, 10);
            this.searchEngine.addTag(artikleId);
            this.searchEngine.setPrimaryTag(artikleId);
            this.searchEngine.addTag(new SearchTag(Article.ArticleKeys.ARTICLE_PROBLEM.name(), (SearchTokenizer)htmlTok, 50, () -> KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_PROBLEM", new Object[0])));
            this.searchEngine.addTag(new SearchTag(Article.ArticleKeys.ARTICLE_SOLUTION.name(), (SearchTokenizer)htmlTok, 50, () -> KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_SOLUTION", new Object[0])));
            this.searchEngine.addTag(new SearchTag(Article.ArticleKeys.ARTICLE_TITLE.name(), (SearchTokenizer)textTok, 100, () -> KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_TITLE", new Object[0])));
            if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                this.searchEngine.addTag(new SearchTag(Article.ArticleKeys.ARTICLE_ATTACHMENT.name(), (SearchTokenizer)textTok, 100, () -> KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_ATTACHMENT", new Object[0])));
            }
            this.searchEngine.addTag(new SearchTag(Article.ArticleKeys.ARTICLE_PUBLISHSTATE.name(), SearchDataType.StringMap, false, new SearchTokenizer(){

                @Nonnull
                public Set<String> tokens(@Nullable Object value, int type) {
                    if (value == null) {
                        return Collections.emptySet();
                    }
                    return Collections.singleton(value.toString());
                }
            }, 10, () -> KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_PUBLISHSTATE", new Object[0]), true){

                @Nonnull
                public Map<? extends Comparable<?>, String> getMapData() {
                    return DisplayableMapCache.getMap((DisplayableKey[])PublishState.values(), PublishState.class, (int)0);
                }
            });
            this.searchEngine.addTag(new SearchTag(Article.ArticleKeys.ARTICLE_CATEGORYID.name(), (SearchTokenizer)textTok, 20));
            this.searchEngine.addTag(new SearchTag(Article.ArticleKeys.ARTICLE_LOCATIONID.name(), (SearchTokenizer)textTok, 10));
            this.searchEngine.addTag(new SearchTag(Article.ArticleKeys.ARTICLE_LANGUAGEID.name(), (SearchTokenizer)textTok, 10));
            this.searchEngine.addTag(new SearchTag(Article.ArticleKeys.ARTICLE_LASTEDITORID.name(), new SearchTokenizer(){
                final /* synthetic */ SearchTokenizer val$textTok;
                {
                    this.val$textTok = searchTokenizer;
                }

                @Nonnull
                public Set<String> tokens(@Nullable Object value, int type) {
                    UserAccount user;
                    int userId;
                    if ((type & 3) == 3 && value != null && (userId = ((Integer)value).intValue()) >= 0 && (user = HDUsersAndGroups.getUserAccount((int)userId, (UserManager)UserManager.getInstance())) != null) {
                        return this.val$textTok.tokens((Object)user.getID().toString(), type);
                    }
                    return Collections.EMPTY_SET;
                }
            }, 20));
            this.searchEngine.addTag(new SearchTag(Article.ArticleKeys.ARTICLE_PINNED.name(), (SearchTokenizer)textTok, 10));
            this.searchEngine.addTag(new SearchTag(Article.ArticleKeys.ARTICLE_LASTMODIFIED.name(), (SearchTokenizer)textTok, 1));
            this.kbIndexVeto.setStatusToStartingInitOfIndex(this.searchEngine);
            this.searchEngine.setData((SearchDataCache)this);
            this.kbIndexVeto.setStatusToFinishedInitOfIndex();
        }
        catch (Throwable ex) {
            this.kbIndexVeto.setStatusToFailedInitOfIndex();
            throw ex;
        }
    }

    public VetoSemaphore checkForVeto() {
        if (!this.startedInitialization.getAndSet(true)) {
            new Thread(() -> {
                try {
                    this.initialize();
                }
                catch (IOException ex) {
                    KnowledgeBaseServerPlugin.LOGGER.error((Throwable)ex);
                }
            }, "Knowledge Base Initializer").start();
        }
        return this.kbIndexVeto.getVetoSemaphore();
    }

    public Map<String, Object> getCacheEntry(@Nonnull Integer cacheId) {
        try {
            return this.getArticle(cacheId);
        }
        catch (ServerDataException e) {
            KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws SQLException {
        KnowledgeBaseConnectorImpl knowledgeBaseConnectorImpl = this;
        synchronized (knowledgeBaseConnectorImpl) {
            if (this.connectionFactory == null) {
                this.connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
            }
        }
        return this.connectionFactory.getConnection();
    }

    public Iterator<Integer> iterator() {
        try {
            ResultSet rs;
            final Connection con = this.getConnection();
            final AtomicInteger totalArticleCount = new AtomicInteger(-1);
            try (Statement stm = con.createStatement();){
                rs = stm.executeQuery(SQL_GET_COUNT_OF_ALL_ARTICLE_IDS);
                try {
                    if (rs.next()) {
                        totalArticleCount.set(rs.getInt(1));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            final PreparedStatement pst = con.prepareStatement(SQL_GET_ALL_ARTICLE_IDS);
            rs = pst.executeQuery();
            return new Iterator<Integer>(){
                private int processedEntries = 0;

                @Override
                public boolean hasNext() {
                    try {
                        boolean next = rs.next();
                        if (next) {
                            return next;
                        }
                    }
                    catch (SQLException e) {
                        KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
                    }
                    try {
                        rs.close();
                        pst.close();
                        con.close();
                    }
                    catch (SQLException e) {
                        KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
                    }
                    return false;
                }

                @Override
                public Integer next() {
                    try {
                        Integer value = rs.getInt(1);
                        KnowledgeBaseConnectorImpl.this.kbIndexVeto.setProgress(++this.processedEntries, totalArticleCount.get());
                        return value;
                    }
                    catch (SQLException e) {
                        KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
                        return null;
                    }
                }
            };
        }
        catch (SQLException e) {
            KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
            return Collections.emptyListIterator();
        }
    }

    private void notifyListeners(NotifyType type, int articleId, Article oldEntry) {
        SearchDataCacheChangeListener[] listeners;
        Integer id = articleId;
        block5: for (SearchDataCacheChangeListener searchDataCacheChangeListener : listeners = this.getListeners()) {
            switch (type) {
                case added: {
                    searchDataCacheChangeListener.entryAdded((Object)id, this.getCacheEntry(id));
                    continue block5;
                }
                case removed: {
                    searchDataCacheChangeListener.entryRemoved((Object)id, (Map)oldEntry);
                    continue block5;
                }
                case modified: {
                    searchDataCacheChangeListener.entryChanged((Object)id, (Map)oldEntry, this.getCacheEntry(id));
                }
            }
        }
    }

    @Override
    public KnowledgeBaseConnector.KnowledgeBaseIndexer getIndexer() {
        return this.indexer;
    }

    @Override
    public Article getArticle(int articleId) throws ServerDataException {
        Map<String, Object> cachedArticle = (Map<String, Object>)this.knowledgeBaseCache.get((Object)articleId);
        if (cachedArticle == null) {
            try (Connection con = this.getConnection();
                 PreparedStatement pst = con.prepareStatement(SQL_GET_ARTICLE);){
                pst.setInt(1, articleId);
                try (ResultSet rs = pst.executeQuery();){
                    if (rs.next()) {
                        Article article = new Article();
                        article.setArticleId(rs.getInt("articleId"));
                        String problem = rs.getString("problem");
                        article.setProblem(problem == null ? "" : problem);
                        String solution = rs.getString("solution");
                        article.setSolution(solution == null ? "" : solution);
                        String title = rs.getString("title");
                        article.setTitle(title == null ? "" : title);
                        article.setPublishState(PublishState.valueOf(rs.getString("publishState")));
                        article.setCategoryId(rs.getInt("categoryId"));
                        article.setLocationId(rs.getInt("locationId"));
                        article.setLanguageId(rs.getString("languageId"));
                        article.setLastEditorId(rs.getInt("lastEditorId"));
                        article.setLastModified(rs.getLong("lastModified"));
                        article.setPinned(rs.getInt("pinned") != 0);
                        article.setRefTicketId(rs.getInt("refTicketId"));
                        KnowledgeBaseUtils.updateAttachmentNames(article);
                        cachedArticle = Collections.unmodifiableMap(article);
                        this.knowledgeBaseCache.put((Object)articleId, cachedArticle);
                    }
                }
            }
            catch (SQLException e) {
                throw new ServerDataException((Exception)e);
            }
        }
        if (cachedArticle != null) {
            Article value = new Article();
            value.putAll(cachedArticle);
            return value;
        }
        return null;
    }

    private void executePreSearch(KnowledgeBaseSearchExpressions knowledgeBaseSearchExpressions, SearchID searchID, String searchQuery, HashSet<Integer> allArticleIdsWithoutLanguageFiltering, HashSet<Integer> allArticleIdsWithoutCategoryFiltering) throws ServerDataException {
        TextSearchCommandBuilder builder = new TextSearchCommandBuilder(this.searchEngine, "");
        SearchCommand searchCommand = builder.build();
        searchCommand.setID(searchID);
        knowledgeBaseSearchExpressions.addPermissionSearchExpression(searchCommand);
        SearchResult searchResult = this.searchEngine.search(searchCommand);
        List entries = searchResult.getEntries();
        for (SearchResultEntry sre : entries) {
            allArticleIdsWithoutLanguageFiltering.add((Integer)sre.getId());
        }
        builder = new TextSearchCommandBuilder(this.searchEngine, searchQuery);
        searchCommand = builder.build();
        searchCommand.setID(searchID);
        knowledgeBaseSearchExpressions.addPermissionSearchExpression(searchCommand);
        knowledgeBaseSearchExpressions.addLanguageSearchExpression(searchCommand);
        searchResult = this.searchEngine.search(searchCommand);
        entries = searchResult.getEntries();
        for (SearchResultEntry sre : entries) {
            allArticleIdsWithoutCategoryFiltering.add((Integer)sre.getId());
        }
    }

    @Override
    public List<SuggestedValue> getSuggestedValues(String searchQuery) {
        return this.searchEngine.getSuggestedValues(searchQuery, 10, null);
    }

    @Override
    public ArticleSearchResult searchArticles(UserAccount user, String searchQuery, String searchIDString, int categoryId, String language, int limit) throws ServerDataException {
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)user, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE})) {
            return new ArticleSearchResult(new ArrayList<Article>(), new ArrayList<Category>(), new ArrayList<LocalizedKey>(), 0, false);
        }
        SearchID searchID = searchIDString == null ? null : new SearchID((Object)searchIDString);
        ArrayList<Article> articles = new ArrayList<Article>();
        int draftCount = 0;
        HashSet<Integer> allArticleIdsWithoutLanguageFiltering = new HashSet<Integer>();
        HashSet<Integer> allArticleIdsWithoutCategoryFiltering = new HashSet<Integer>();
        KnowledgeBaseSearchExpressions knowledgeBaseSearchExpressions = new KnowledgeBaseSearchExpressions(user, categoryId, language);
        this.executePreSearch(knowledgeBaseSearchExpressions, searchID, searchQuery, allArticleIdsWithoutLanguageFiltering, allArticleIdsWithoutCategoryFiltering);
        TextSearchCommandBuilder builder = new TextSearchCommandBuilder(this.searchEngine, searchQuery);
        SearchCommand searchCommand = builder.build();
        searchCommand.setID(searchID);
        knowledgeBaseSearchExpressions.addPermissionSearchExpression(searchCommand);
        knowledgeBaseSearchExpressions.addLanguageSearchExpression(searchCommand);
        knowledgeBaseSearchExpressions.addCategorySearchExpression(searchCommand);
        OrSearchExpression pinnedOrFavoriteIdsOrExpression = new OrSearchExpression();
        pinnedOrFavoriteIdsOrExpression.add((Object)new SearchCondition(Article.ArticleKeys.ARTICLE_PINNED.name(), SearchCondition.SearchTermOperator.Equals, (Object)"t"));
        Set<Integer> favoriteArticleIds = this.getFavoriteArticleIds(HDUsersAndGroups.getUserID((UserAccount)user));
        if (favoriteArticleIds != null && favoriteArticleIds.size() > 0) {
            favoriteArticleIds.forEach(fa -> pinnedOrFavoriteIdsOrExpression.add((Object)new SearchCondition(Article.ArticleKeys.ARTICLE_ID.name(), SearchCondition.SearchTermOperator.Equals, (Object)fa.toString())));
        }
        searchCommand.addBoostingExpression((SearchExpression)pinnedOrFavoriteIdsOrExpression);
        SearchResult searchResult = this.searchEngine.search(searchCommand);
        List foundEntries = searchResult.getEntries();
        for (SearchResultEntry sre : foundEntries) {
            Article article = this.getArticle((Integer)sre.getId());
            Long lastModified = Long.MIN_VALUE;
            if (article != null) {
                lastModified = -article.getLastModified();
            }
            sre.setDisplayName((Comparable)lastModified);
        }
        Collections.sort(foundEntries);
        List<Category> articleCategories = this.getArticleCategories(user, allArticleIdsWithoutCategoryFiltering, categoryId);
        HashSet visibleCategoryIds = new HashSet();
        articleCategories.forEach(c -> visibleCategoryIds.add(c.getId()));
        final ArrayList<Integer> categorySorting = new ArrayList<Integer>();
        final ArrayList<Integer> idSorting = new ArrayList<Integer>();
        int i = 0;
        int count = 0;
        int maxArticles = Math.min(limit, foundEntries.size());
        while (i < maxArticles && count < foundEntries.size()) {
            Integer catId;
            SearchResultEntry sre = (SearchResultEntry)foundEntries.get(count);
            ++count;
            Article article = this.getArticle((Integer)sre.getId());
            if (article == null || !visibleCategoryIds.contains(catId = Integer.valueOf(article.getCategoryId()))) continue;
            if (categorySorting.indexOf(catId) == -1) {
                categorySorting.add(catId);
            }
            idSorting.add(article.getArticleId());
            articles.add(article);
            ++i;
        }
        boolean hasMoreEntries = i < foundEntries.size();
        Collections.sort(articles, new Comparator<Article>(){

            @Override
            public int compare(Article o1, Article o2) {
                int c2;
                int c1 = categorySorting.indexOf(o1.getCategoryId());
                int value = c1 - (c2 = categorySorting.indexOf(o2.getCategoryId()));
                if (value != 0) {
                    return value;
                }
                return idSorting.indexOf(o1.getArticleId()) - idSorting.indexOf(o2.getArticleId());
            }
        });
        return new ArticleSearchResult(articles, articleCategories, this.getArticleLanguages(allArticleIdsWithoutLanguageFiltering), draftCount, hasMoreEntries);
    }

    @Override
    public ArticleSearchResult getFrontArticles(UserAccount user, int categoryId, String language, int minLimit, int maxLimit) throws ServerDataException {
        SearchResult searchResult;
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)user, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE})) {
            return new ArticleSearchResult(new ArrayList<Article>(), new ArrayList<Category>(), new ArrayList<LocalizedKey>(), 0, false);
        }
        ArrayList<Article> articles = new ArrayList<Article>();
        int draftCount = 0;
        HashSet<Integer> allArticleIdsWithoutLanguageFiltering = new HashSet<Integer>();
        HashSet<Integer> allArticleIdsWithoutCategoryFiltering = new HashSet<Integer>();
        KnowledgeBaseSearchExpressions knowledgeBaseSearchExpressions = new KnowledgeBaseSearchExpressions(user, categoryId, language);
        this.executePreSearch(knowledgeBaseSearchExpressions, null, "", allArticleIdsWithoutLanguageFiltering, allArticleIdsWithoutCategoryFiltering);
        TextSearchCommandBuilder builder = new TextSearchCommandBuilder(this.searchEngine, "");
        SearchCommand searchCommand = builder.build();
        if (SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_EDIT_DELETE)) {
            searchCommand = builder.build();
            searchCommand.getSearchExpression().add((SearchExpression)new SearchCondition(Article.ArticleKeys.ARTICLE_PUBLISHSTATE.name(), SearchCondition.SearchTermOperator.Equals, (Object)PublishState.INREVIEW.name()));
            knowledgeBaseSearchExpressions.addLanguageSearchExpression(searchCommand);
            searchResult = this.searchEngine.search(searchCommand);
            draftCount = searchResult.getEntries().size();
        }
        searchCommand = builder.build();
        searchCommand.getSearchExpression().add((SearchExpression)new SearchCondition(Article.ArticleKeys.ARTICLE_PINNED.name(), SearchCondition.SearchTermOperator.Equals, (Object)"t"));
        knowledgeBaseSearchExpressions.addPermissionSearchExpression(searchCommand);
        knowledgeBaseSearchExpressions.addCategorySearchExpression(searchCommand);
        knowledgeBaseSearchExpressions.addLanguageSearchExpression(searchCommand);
        searchResult = this.searchEngine.search(searchCommand);
        List pinnedEntries = searchResult.getEntries();
        Set<Integer> favoriteArticleIds = this.getFavoriteArticleIds(HDUsersAndGroups.getUserID((UserAccount)user));
        HashSet<Object> selectedCategories = null;
        if (knowledgeBaseSearchExpressions.categorySearchExpression != null) {
            for (SearchExpression se : knowledgeBaseSearchExpressions.categorySearchExpression) {
                SearchCondition sc;
                Object catId;
                if (!(se instanceof SearchCondition) || (catId = Integer.valueOf((String)(sc = (SearchCondition)se).getRightOperand())) == null) continue;
                if (selectedCategories == null) {
                    selectedCategories = new HashSet<Object>();
                }
                selectedCategories.add(catId);
            }
        }
        List<Category> articleCategories = this.getArticleCategories(user, allArticleIdsWithoutCategoryFiltering, categoryId);
        HashSet categoryIds = new HashSet();
        articleCategories.forEach(c -> categoryIds.add(c.getId()));
        HashSet<Integer> addedArticleIds = new HashSet<Integer>();
        for (Object sre : pinnedEntries) {
            Article article = this.getArticle((Integer)sre.getId());
            Long lastModified = Long.MIN_VALUE;
            if (article != null) {
                lastModified = -article.getLastModified();
            }
            sre.setDisplayName((Comparable)lastModified);
        }
        Collections.sort(pinnedEntries);
        ArrayList<Object> pinnedArticles = new ArrayList<Object>();
        for (SearchResultEntry sre : pinnedEntries) {
            Article article = this.getArticle((Integer)sre.getId());
            if (article == null || !categoryIds.contains(article.getCategoryId()) || selectedCategories != null && !selectedCategories.contains(article.getCategoryId())) continue;
            pinnedArticles.add(article);
            addedArticleIds.add((Integer)sre.getId());
            if (pinnedArticles.size() < maxLimit) continue;
            break;
        }
        TreeSet<Integer> sortedFavoriteArticleIds = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                Article a1 = null;
                Article a2 = null;
                try {
                    a1 = KnowledgeBaseConnectorImpl.this.getArticle(o1);
                }
                catch (ServerDataException e) {
                    KnowledgeBaseServerPlugin.LOGGER.warn((Object)e);
                }
                try {
                    a2 = KnowledgeBaseConnectorImpl.this.getArticle(o2);
                }
                catch (ServerDataException e) {
                    KnowledgeBaseServerPlugin.LOGGER.warn((Object)e);
                }
                if (a1 == null) {
                    if (a2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (a2 == null) {
                    return -1;
                }
                long l1 = a1.getLastModified();
                long l2 = a2.getLastModified();
                long diff = l2 - l1;
                return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
            }
        });
        sortedFavoriteArticleIds.addAll(favoriteArticleIds);
        ArrayList<Article> favoriteArticles = new ArrayList<Article>();
        for (Integer id : sortedFavoriteArticleIds) {
            Article article;
            if (addedArticleIds.contains(id) || (article = this.getArticle(id)) == null || article.isPinned() || !allArticleIdsWithoutCategoryFiltering.contains(id) || !categoryIds.contains(article.getCategoryId()) || selectedCategories != null && !selectedCategories.contains(article.getCategoryId()) || language != null && !language.isEmpty() && !language.equalsIgnoreCase(article.getLanguageId())) continue;
            favoriteArticles.add(article);
            addedArticleIds.add(id);
            if (favoriteArticles.size() < maxLimit) continue;
            break;
        }
        int newestArticleSize = Math.min(Math.max(Math.max(pinnedArticles.size(), favoriteArticles.size()), minLimit), maxLimit);
        ArrayList<Article> newestArticles = new ArrayList<Article>();
        SearchTag searchTag = this.searchEngine.getTag(Article.ArticleKeys.ARTICLE_LASTMODIFIED.name());
        Iterator idsIterator = this.searchEngine.createIdsIterator(searchTag, false);
        int newArticleAcount = 0;
        while (idsIterator.hasNext() && newArticleAcount < newestArticleSize) {
            Article article;
            Integer id = (Integer)idsIterator.next();
            if (id == null || (article = this.getArticle(id)) == null || !allArticleIdsWithoutCategoryFiltering.contains(id) || !categoryIds.contains(article.getCategoryId()) || selectedCategories != null && !selectedCategories.contains(article.getCategoryId()) || language != null && !language.isEmpty() && !language.equalsIgnoreCase(article.getLanguageId())) continue;
            ++newArticleAcount;
            if (addedArticleIds.contains(id)) continue;
            newestArticles.add(article);
            addedArticleIds.add(id);
        }
        articles.addAll(newestArticles);
        articles.addAll(pinnedArticles);
        articles.addAll(favoriteArticles);
        return new ArticleSearchResult(articles, articleCategories, this.getArticleLanguages(allArticleIdsWithoutLanguageFiltering), draftCount, idsIterator.hasNext());
    }

    private void addCategorySearchCondition(OrSearchExpression orSearchExpression, List<CategoryVO> allCategories, int categoryId) {
        if (allCategories == null) {
            return;
        }
        for (CategoryVO category : allCategories) {
            if (category.getId() == categoryId) {
                this.addCategoryChildIds(orSearchExpression, allCategories, category);
                break;
            }
            List<CategoryVO> children = allCategories.stream().filter(c -> Integer.valueOf(category.getId()).equals(c.getParentCategoryID())).collect(Collectors.toList());
            this.addCategorySearchCondition(orSearchExpression, children, categoryId);
        }
    }

    private void addCategoryChildIds(OrSearchExpression orSearchExpression, List<CategoryVO> allCategories, CategoryVO category) {
        orSearchExpression.add((Object)new SearchCondition(Article.ArticleKeys.ARTICLE_CATEGORYID.name(), SearchCondition.SearchTermOperator.Equals, (Object)String.valueOf(category.getId())));
        List children = allCategories.stream().filter(c -> Integer.valueOf(category.getId()).equals(c.getParentCategoryID())).collect(Collectors.toList());
        for (CategoryVO vo : children) {
            this.addCategoryChildIds(orSearchExpression, allCategories, vo);
        }
    }

    @Override
    public Set<Integer> getFavoriteArticleIds(int userId) throws ServerDataException {
        HashSet<Integer> favorites = new HashSet<Integer>();
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(SQL_GET_FAVORITE_ARTICLES_FOR_USERID);){
            pst.setInt(1, userId);
            try (ResultSet rs = pst.executeQuery();){
                while (rs.next()) {
                    favorites.add(rs.getInt("articleId"));
                }
            }
        }
        catch (SQLException e) {
            throw new ServerDataException((Exception)e);
        }
        return favorites;
    }

    @Override
    public void saveFavState(int articleId, boolean isFavorit, int userId) throws ServerDataException {
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(SQL_GET_FAVORITE_ARTICLES_FOR_USERID_AND_ARTICLEID, 1005, 1008);){
            pst.setInt(1, userId);
            pst.setInt(2, articleId);
            try (ResultSet rs = pst.executeQuery();){
                boolean hasRow = rs.next();
                if (!hasRow && isFavorit) {
                    rs.moveToInsertRow();
                    rs.updateInt("articleId", articleId);
                    rs.updateInt("userId", userId);
                    rs.insertRow();
                } else if (hasRow && !isFavorit) {
                    rs.deleteRow();
                }
            }
        }
        catch (SQLException e) {
            throw new ServerDataException((Exception)e);
        }
    }

    @Override
    public void savePinState(int articleId, boolean isPinned) throws ServerDataException {
        block21: {
            try (Connection con = this.getConnection();
                 PreparedStatement pst = con.prepareStatement(SQL_GET_ARTICLE_FOR_INSERT, 1005, 1008);){
                pst.setInt(1, articleId);
                try (ResultSet rs = pst.executeQuery();){
                    if (rs.next()) {
                        rs.updateInt("pinned", isPinned ? 1 : 0);
                        rs.updateRow();
                        Article oldArticle = this.getArticle(articleId);
                        this.knowledgeBaseCache.remove((Object)articleId);
                        this.notifyListeners(NotifyType.modified, articleId, oldArticle);
                        break block21;
                    }
                    throw new ServerDataException((Exception)new IllegalArgumentException(String.valueOf(articleId)));
                }
            }
            catch (SQLException e) {
                throw new ServerDataException((Exception)e);
            }
        }
    }

    @Override
    public void saveFeedback(int articleId, boolean upVote, int userId) throws ServerDataException {
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(SQL_GET_FEEDBACK_FOR_USERID, 1005, 1008);){
            pst.setInt(1, userId);
            pst.setInt(2, articleId);
            try (ResultSet rs = pst.executeQuery();){
                if (!rs.next()) {
                    rs.moveToInsertRow();
                    rs.updateInt("rating", upVote ? 1 : -1);
                    rs.updateInt("articleId", articleId);
                    rs.updateInt("userId", userId);
                    rs.insertRow();
                } else {
                    rs.updateInt("rating", upVote ? 1 : -1);
                    rs.updateRow();
                }
            }
        }
        catch (SQLException e) {
            throw new ServerDataException((Exception)e);
        }
    }

    @Override
    public Feedback getFeedback(int articleId, int userId) throws ServerDataException {
        int upVotes = 0;
        int downVotes = 0;
        boolean hasVotedUp = false;
        boolean hasVotedDown = false;
        try (Connection con = this.getConnection();){
            int rating;
            ResultSet rs;
            try (PreparedStatement pst = con.prepareStatement(SQL_GET_FEEDBACK_FOR_ARTICLEID);){
                pst.setInt(1, articleId);
                rs = pst.executeQuery();
                try {
                    while (rs.next()) {
                        rating = rs.getInt("rating");
                        int votes = rs.getInt("votes");
                        if (rating == 1) {
                            upVotes += votes;
                            continue;
                        }
                        downVotes += votes;
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            pst = con.prepareStatement(SQL_GET_FEEDBACK_FOR_USERID);
            try {
                pst.setInt(1, userId);
                pst.setInt(2, articleId);
                rs = pst.executeQuery();
                try {
                    if (rs.next()) {
                        rating = rs.getInt("rating");
                        if (rating == 1) {
                            hasVotedUp = true;
                        } else {
                            hasVotedDown = true;
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pst != null) {
                    pst.close();
                }
            }
        }
        catch (SQLException e) {
            throw new ServerDataException((Exception)e);
        }
        return new Feedback(upVotes, downVotes, hasVotedUp, hasVotedDown);
    }

    @Override
    public void deleteArticle(int articleId) throws ServerDataException {
        Article oldArticle = this.getArticle(articleId);
        try {
            DatabaseTransactionUtils.executeAsTransaction((ConnectionFactory)this.connectionFactory, con -> {
                try (PreparedStatement pst = con.prepareStatement(SQL_DELETE_ARTICLEFEEDBACK);){
                    pst.setInt(1, articleId);
                    pst.executeUpdate();
                }
                pst = con.prepareStatement(SQL_DELETE_ARTICLEFAVORITES);
                try {
                    pst.setInt(1, articleId);
                    pst.executeUpdate();
                }
                finally {
                    if (pst != null) {
                        pst.close();
                    }
                }
                pst = con.prepareStatement(SQL_DELETE_ARTICLEPROBLEM);
                try {
                    pst.setInt(1, articleId);
                    pst.executeUpdate();
                }
                finally {
                    if (pst != null) {
                        pst.close();
                    }
                }
                pst = con.prepareStatement(SQL_DELETE_ARTICLE);
                try {
                    pst.setInt(1, articleId);
                    pst.executeUpdate();
                }
                finally {
                    if (pst != null) {
                        pst.close();
                    }
                }
                return null;
            });
        }
        catch (SQLException e) {
            throw new ServerDataException((Exception)e);
        }
        this.knowledgeBaseCache.remove((Object)articleId);
        this.notifyListeners(NotifyType.removed, articleId, oldArticle);
    }

    @Override
    public int createArticle(Article article) throws ServerDataException {
        return this.updateOrInsertArticle(article, -1);
    }

    @Override
    public void updateArticle(Article article) throws ServerDataException {
        this.updateOrInsertArticle(article, article.getArticleId());
    }

    @Override
    public ArrayList<Integer> getArticleLocations() throws ServerDataException {
        ArrayList<Integer> locationIds = new ArrayList<Integer>();
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(SQL_GET_ALL_LOCATIONS);
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                locationIds.add(rs.getInt("locationId"));
            }
        }
        catch (SQLException e) {
            throw new ServerDataException((Exception)e);
        }
        return locationIds;
    }

    private int updateOrInsertArticle(Article article, int articleId) throws ServerDataException {
        Article oldArticle = articleId >= 0 ? this.getArticle(articleId) : null;
        AtomicInteger currentArticleId = new AtomicInteger(articleId);
        AtomicBoolean existingArticle = new AtomicBoolean(false);
        try {
            DatabaseTransactionUtils.executeAsTransaction((ConnectionFactory)((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)), con -> {
                try (PreparedStatement pst = con.prepareStatement(SQL_GET_ARTICLE_FOR_INSERT, 1005, 1008);){
                    pst.setInt(1, currentArticleId.get());
                    try (ResultSet rs = pst.executeQuery();){
                        Object title;
                        if (currentArticleId.get() >= 0) {
                            if (!rs.next()) {
                                throw new SQLException(new IllegalArgumentException("Article with ID " + currentArticleId.get() + " does not exist anymore."));
                            }
                            existingArticle.set(true);
                        } else {
                            rs.moveToInsertRow();
                        }
                        Object object = title = article.getTitle() == null ? "" : article.getTitle();
                        if (StringFunctions.isEmpty((String)title)) {
                            String solution;
                            String problem = article.getProblem();
                            if (problem != null) {
                                HtmlConverter.ConvertResult html2text = HtmlConverter.html2text((String)problem, (int)50);
                                title = html2text.getContent();
                                if (!html2text.isComplete()) {
                                    title = ((String)title).substring(0, 47) + "...";
                                }
                            }
                            if (StringFunctions.isEmpty((String)title) && (solution = article.getSolution()) != null) {
                                HtmlConverter.ConvertResult html2text = HtmlConverter.html2text((String)solution, (int)50);
                                title = html2text.getContent();
                                if (!html2text.isComplete()) {
                                    title = ((String)title).substring(0, 47) + "...";
                                }
                            }
                            if (StringFunctions.isEmpty((String)title)) {
                                title = "[No Title]";
                            }
                        }
                        rs.updateString("solution", article.getSolution() == null ? "" : article.getSolution());
                        rs.updateString("title", (String)title);
                        rs.updateString("publishState", article.getPublishState().name());
                        rs.updateString("languageId", article.getLanguageId());
                        rs.updateInt("categoryId", article.getCategoryId());
                        int targetLocationId = article.getPublishState() == PublishState.LOCATION ? (article.getLocationId() == -1 ? 0 : article.getLocationId()) : -1;
                        rs.updateInt("locationId", targetLocationId);
                        rs.updateInt("lastEditorId", article.getLastEditorId());
                        rs.updateInt("categoryId", article.getCategoryId());
                        rs.updateInt("refTicketId", article.getRefTicketId());
                        rs.updateLong("lastModified", article.getLastModified());
                        if (currentArticleId.get() >= 0) {
                            rs.updateRow();
                        } else {
                            rs.insertRow();
                            rs.last();
                            currentArticleId.set(rs.getInt("articleId"));
                        }
                    }
                }
                boolean hasProblem = article.getProblem() != null && !article.getProblem().isEmpty();
                try (PreparedStatement pst = con.prepareStatement(SQL_GET_ARTICLEPROBLEM_FOR_INSERT, 1005, 1008);){
                    pst.setInt(1, currentArticleId.get());
                    boolean existingRow = false;
                    try (ResultSet rs = pst.executeQuery();){
                        if (rs.next()) {
                            if (!hasProblem) {
                                rs.deleteRow();
                            } else {
                                existingRow = true;
                            }
                        } else if (hasProblem) {
                            rs.moveToInsertRow();
                        }
                        if (existingRow || hasProblem) {
                            rs.updateInt("articleId", currentArticleId.get());
                            rs.updateString("problem", article.getProblem() == null ? "" : article.getProblem());
                        }
                        if (existingRow) {
                            rs.updateRow();
                        } else if (hasProblem) {
                            rs.insertRow();
                        }
                    }
                }
                return null;
            });
            if (existingArticle.get()) {
                this.knowledgeBaseCache.remove((Object)currentArticleId.get());
                this.notifyListeners(NotifyType.modified, currentArticleId.get(), oldArticle);
            } else {
                this.notifyListeners(NotifyType.added, currentArticleId.get(), null);
            }
            return currentArticleId.get();
        }
        catch (SQLException e) {
            throw new ServerDataException((Exception)e);
        }
    }

    @Override
    public ArrayList<Category> getAllDeletedCategories(UserAccount user, Set<Integer> articleIDs) throws ServerDataException {
        ArrayList<Category> deletedCategories = new ArrayList<Category>();
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)user, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_EDIT_DELETE})) {
            return deletedCategories;
        }
        HashMap<Integer, Integer> categoryArticleCount = new HashMap<Integer, Integer>();
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(SQL_GET_ALL_ARTICLES_WITH_DELETED_CATEGORIES);
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                int articleId = rs.getInt("articleId");
                if (articleIDs != null && !articleIDs.contains(articleId)) continue;
                int categoryId = rs.getInt("categoryId");
                Integer count = (Integer)categoryArticleCount.get(categoryId);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                categoryArticleCount.put(categoryId, count);
            }
        }
        catch (SQLException e) {
            throw new ServerDataException((Exception)e);
        }
        for (Map.Entry e : categoryArticleCount.entrySet()) {
            String displayName;
            CategoryVO cat = (CategoryVO)CategoryManager.getInstance().get(((Integer)e.getKey()).intValue());
            if (cat != null) {
                displayName = KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.category.deleted", new Object[]{cat.getDisplayValue()});
                deletedCategories.add(new Category((Integer)e.getKey(), cat.getPath(), this.getLevel(0, cat), displayName, (Integer)e.getValue()));
                continue;
            }
            displayName = KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.category.deleted.missing", new Object[]{((Integer)e.getKey()).toString()});
            deletedCategories.add(new Category((Integer)e.getKey(), displayName, 0, displayName, (Integer)e.getValue()));
        }
        return deletedCategories;
    }

    @Override
    public List<Category> getArticleCategories(UserAccount user, Set<Integer> articleIDs, int selectedCategoryId) throws ServerDataException {
        List allCategories = CategoryManager.getInstance().getAll(true);
        HashMap<Integer, Integer> usedCategoryIds = new HashMap<Integer, Integer>();
        if (selectedCategoryId >= 0) {
            usedCategoryIds.put(selectedCategoryId, 0);
        }
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(SQL_GET_ALL_ARTICLE_CATEGORYIDS);
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                int articleId;
                if (articleIDs != null && !articleIDs.contains(articleId = rs.getInt("articleId"))) continue;
                Integer catKey = rs.getInt("categoryId");
                Integer catArticleCount = (Integer)usedCategoryIds.get(catKey);
                if (catArticleCount == null) {
                    usedCategoryIds.put(catKey, 1);
                    continue;
                }
                usedCategoryIds.put(catKey, catArticleCount + 1);
            }
        }
        catch (SQLException e) {
            throw new ServerDataException((Exception)e);
        }
        ArrayList<Category> categories = new ArrayList<Category>();
        List allUsedCategories = allCategories.stream().filter(c -> this.isCategoryUsed((CategoryVO)c, allCategories, (Map<Integer, Integer>)usedCategoryIds)).sorted((a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getPath(), b.getPath())).collect(Collectors.toList());
        for (CategoryVO categoryVO : allUsedCategories) {
            if (categoryVO.getId() == 0) continue;
            int articleCount = this.getNumberOfArticles(categoryVO, allCategories, usedCategoryIds);
            String displayName = categoryVO.getDisplayValue();
            if (displayName == null || displayName.isEmpty()) {
                displayName = KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.category.none", new Object[0]);
            }
            categories.add(new Category(categoryVO.getId(), categoryVO.getPath(), this.getLevel(0, categoryVO), displayName, articleCount));
        }
        categories.addAll(this.getAllDeletedCategories(user, articleIDs));
        return categories;
    }

    private int getLevel(int level, CategoryVO categoryVO) {
        if (categoryVO.getParentCategoryID() == null) {
            return level;
        }
        CategoryVO parent = (CategoryVO)CategoryManager.getInstance().get(categoryVO.getParentCategoryID().intValue());
        if (parent == null || parent.getId() == 0) {
            return level;
        }
        return this.getLevel(level + 1, parent);
    }

    private boolean isCategoryUsed(CategoryVO category, List<CategoryVO> allCategories, Map<Integer, Integer> usedCategoryIds) {
        if (usedCategoryIds.containsKey(category.getId())) {
            return true;
        }
        List children = allCategories.stream().filter(c -> Integer.valueOf(category.getId()).equals(c.getParentCategoryID())).collect(Collectors.toList());
        for (CategoryVO child : children) {
            if (!this.isCategoryUsed(child, allCategories, usedCategoryIds)) continue;
            return true;
        }
        return false;
    }

    private int getNumberOfArticles(CategoryVO category, List<CategoryVO> allCategories, Map<Integer, Integer> usedCategoryIds) {
        int count = 0;
        Integer usedCategoryEntry = usedCategoryIds.get(category.getId());
        if (usedCategoryEntry != null) {
            count += usedCategoryEntry.intValue();
        }
        List children = allCategories.stream().filter(c -> Integer.valueOf(category.getId()).equals(c.getParentCategoryID())).collect(Collectors.toList());
        for (CategoryVO c2 : children) {
            count += this.getNumberOfArticles(c2, allCategories, usedCategoryIds);
        }
        return count;
    }

    private List<LocalizedKey> getArticleLanguages(Set<Integer> articleIDs) throws ServerDataException {
        ArrayList<LocalizedKey> usedLanguages = new ArrayList<LocalizedKey>();
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(SQL_GET_ALL_ARTICLE_LANGUAGES);
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                String languageDisplayName;
                int articleId;
                if (articleIDs != null && !articleIDs.contains(articleId = rs.getInt("articleId"))) continue;
                String language = rs.getString("languageId");
                LocalizedKey lang = new LocalizedKey(language, (languageDisplayName = rs.getString("Sprache")) == null ? language : languageDisplayName);
                if (usedLanguages.contains(lang)) continue;
                usedLanguages.add(lang);
            }
        }
        catch (SQLException e) {
            throw new ServerDataException((Exception)e);
        }
        Collections.sort(usedLanguages, new Comparator<LocalizedKey>(){

            @Override
            public int compare(LocalizedKey o1, LocalizedKey o2) {
                return o1.getKey().compareToIgnoreCase(o2.getKey());
            }
        });
        return usedLanguages;
    }

    @Override
    public void updateArticleCacheAndIndex(int articleId) throws ServerDataException {
        Article oldArticle = this.getArticle(articleId);
        this.knowledgeBaseCache.remove((Object)articleId);
        this.notifyListeners(NotifyType.modified, articleId, oldArticle);
    }

    @Nonnull
    public VetoType getType() {
        return KnowledgeBaseServerPlugin.VETO_TYPE;
    }

    @Override
    @Nonnull
    public FuzzySearch<Integer> createFuzzySearch(Article.ArticleKeys ... keys) {
        List<String> names = Arrays.asList(keys).stream().map(Enum::name).collect(Collectors.toList());
        KnowledgeBaseSearchExpressions knowledgeBaseSearchExpressions = new KnowledgeBaseSearchExpressions(UserManager.getInstance().getCurrentUserAccount(), -1, "");
        SearchCommand searchCommand = new SearchCommand(new SearchExpression[0]);
        knowledgeBaseSearchExpressions.addPermissionSearchExpression(searchCommand);
        return new FuzzySearch(this.searchEngine, searchCommand, names.toArray(new String[names.size()]));
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="No String can be injected in sql")
    public List<Integer> getArticlesUsingLocation(List<LocationVO> locations) throws ServerDataException {
        ArrayList<Integer> articleIds = new ArrayList<Integer>();
        if (locations.isEmpty()) {
            return articleIds;
        }
        String sql = "SELECT articleId FROM tblKnowledgeBase WHERE locationId IN (" + locations.stream().map(l -> String.valueOf(l.getId())).collect(Collectors.joining(",")) + ")";
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(sql);
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                articleIds.add(rs.getInt("articleId"));
            }
        }
        catch (SQLException e) {
            throw new ServerDataException((Exception)e);
        }
        return articleIds;
    }

    @Override
    @Nonnull
    public IndexSearchEngine<Integer> getSearchEngine() {
        return this.searchEngine;
    }

    @InternalApi
    public final class KnowledgeBaseIndexerImpl
    implements KnowledgeBaseConnector.KnowledgeBaseIndexer {
        @Override
        public synchronized void reIndex() {
            KnowledgeBaseConnectorImpl.this.searchEngine.reIndexAsync();
        }

        @Override
        public int getIndexCount() {
            if (KnowledgeBaseConnectorImpl.this.searchEngine == null) {
                return 0;
            }
            return KnowledgeBaseConnectorImpl.this.searchEngine.getIndexCountOfIDs();
        }

        @Override
        public boolean isRunning() {
            return KnowledgeBaseConnectorImpl.this.searchEngine != null && KnowledgeBaseConnectorImpl.this.searchEngine.isReindexRunning();
        }

        @Override
        public IndexerStatus getIndexerStatus() {
            if (KnowledgeBaseConnectorImpl.this.searchEngine == null) {
                return new IndexerStatus(false, 0L, 0L, 0L);
            }
            return KnowledgeBaseConnectorImpl.this.searchEngine.getIndexerStatus((long)this.getIndexCount());
        }
    }

    private static enum NotifyType {
        modified,
        added,
        removed;

    }

    public final class KnowledgeBaseSearchExpressions {
        private OrSearchExpression permissionSearchExpression;
        private AndSearchExpression languageSearchExpression;
        private OrSearchExpression categorySearchExpression;

        public KnowledgeBaseSearchExpressions(UserAccount user, int categoryId, String language) {
            this.permissionSearchExpression = this.preparePermissionSearchExpression(user);
            this.languageSearchExpression = this.prepareLanguageSearchExpression(language);
            this.categorySearchExpression = this.prepareCategorySearchExpression(user, categoryId);
        }

        private void addCategorySearchExpression(SearchCommand searchCommand) {
            if (this.categorySearchExpression != null) {
                searchCommand.getSearchExpression().add((SearchExpression)this.categorySearchExpression);
            }
        }

        private void addLanguageSearchExpression(SearchCommand searchCommand) {
            if (this.languageSearchExpression != null) {
                searchCommand.getSearchExpression().add((SearchExpression)this.languageSearchExpression);
            }
        }

        private void addPermissionSearchExpression(SearchCommand searchCommand) {
            if (this.permissionSearchExpression != null) {
                searchCommand.getSearchExpression().add((SearchExpression)this.permissionSearchExpression);
            }
        }

        private OrSearchExpression prepareCategorySearchExpression(UserAccount user, int categoryId) {
            OrSearchExpression categorySearchExpression = null;
            if (categoryId >= 0) {
                categorySearchExpression = new OrSearchExpression();
                categorySearchExpression.add((Object)new SearchCondition(Article.ArticleKeys.ARTICLE_CATEGORYID.name(), SearchCondition.SearchTermOperator.Equals, (Object)String.valueOf(categoryId)));
                List allCategories = CategoryManager.getInstance().getAll(false);
                KnowledgeBaseConnectorImpl.this.addCategorySearchCondition(categorySearchExpression, allCategories, categoryId);
            }
            return categorySearchExpression;
        }

        private AndSearchExpression prepareLanguageSearchExpression(String language) {
            AndSearchExpression languageSearchExpression = null;
            if (language != null && !language.isEmpty()) {
                languageSearchExpression = new AndSearchExpression();
                languageSearchExpression.add((SearchExpression)new SearchCondition(Article.ArticleKeys.ARTICLE_LANGUAGEID.name(), SearchCondition.SearchTermOperator.Equals, (Object)language));
            }
            return languageSearchExpression;
        }

        private OrSearchExpression preparePermissionSearchExpression(UserAccount user) {
            OrSearchExpression permissionSearchExpression = null;
            if (SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE)) {
                permissionSearchExpression = new OrSearchExpression();
                permissionSearchExpression.add((Object)new SearchCondition(Article.ArticleKeys.ARTICLE_PUBLISHSTATE.name(), SearchCondition.SearchTermOperator.Equals, (Object)PublishState.ALL.name()));
                AndSearchExpression myLocationSearchExpression = new AndSearchExpression();
                myLocationSearchExpression.add((SearchExpression)new SearchCondition(Article.ArticleKeys.ARTICLE_PUBLISHSTATE.name(), SearchCondition.SearchTermOperator.Equals, (Object)PublishState.LOCATION.name()));
                Integer userLocation = (Integer)user.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
                if (userLocation != null) {
                    myLocationSearchExpression.add((SearchExpression)new SearchCondition(Article.ArticleKeys.ARTICLE_LOCATIONID.name(), SearchCondition.SearchTermOperator.Equals, (Object)userLocation.toString()));
                }
                permissionSearchExpression.add((Object)myLocationSearchExpression);
            }
            if (permissionSearchExpression != null && SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_ALL_LOCATIONS)) {
                permissionSearchExpression.add((Object)new SearchCondition(Article.ArticleKeys.ARTICLE_PUBLISHSTATE.name(), SearchCondition.SearchTermOperator.Equals, (Object)PublishState.LOCATION.name()));
            }
            if (permissionSearchExpression != null && SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_SUPPORTER)) {
                permissionSearchExpression.add((Object)new SearchCondition(Article.ArticleKeys.ARTICLE_PUBLISHSTATE.name(), SearchCondition.SearchTermOperator.Equals, (Object)PublishState.SUPPORTER.name()));
            }
            if (permissionSearchExpression != null && SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_EDIT_DELETE)) {
                permissionSearchExpression.add((Object)new SearchCondition(Article.ArticleKeys.ARTICLE_PUBLISHSTATE.name(), SearchCondition.SearchTermOperator.Equals, (Object)PublishState.INREVIEW.name()));
            }
            return permissionSearchExpression;
        }
    }
}

