/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;

@InternalApi
public class CheckArticlePermission
implements UserDefinedFunction {
    private KnowledgeBaseConnector kbc;

    public boolean hasAccessToKnowledgeBaseArticle(int articleId) {
        Article article;
        if (!SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE)) {
            return false;
        }
        if (this.kbc == null) {
            ServerPluginManager manager = ServerPluginManager.getInstance();
            this.kbc = (KnowledgeBaseConnector)manager.getSingleInstance(KnowledgeBaseConnector.class);
        }
        try {
            article = this.kbc.getArticle(articleId);
        }
        catch (ServerDataException e) {
            KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
            return false;
        }
        if (article == null) {
            return false;
        }
        PublishState publishState = article.getPublishState();
        switch (publishState) {
            case INREVIEW: {
                return SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_EDIT_DELETE);
            }
            case SUPPORTER: {
                return SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_SUPPORTER);
            }
            case LOCATION: {
                Integer locationId;
                if (SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_ALL_LOCATIONS)) {
                    return true;
                }
                UserAccount user = UserManager.getInstance().getCurrentUserAccount();
                if (user != null && (locationId = (Integer)user.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID)) != null) {
                    return locationId.intValue() == article.getLocationId();
                }
                return false;
            }
            case ALL: {
                return true;
            }
        }
        return false;
    }
}

