/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase;

import com.inet.classloader.I18nMessages;
import com.inet.collaboration.bot.BotCommand;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.core.data.AdditionalFieldSetting;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCareExtension;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseAngularApplicationServlet;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseModule;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachmentConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.bot.KnowledgeBaseInfoBotCommand;
import com.inet.helpdesk.plugins.knowledgebase.bot.KnowledgeBaseSearchBotCommand;
import com.inet.helpdesk.plugins.knowledgebase.server.ArticleFieldSettings;
import com.inet.helpdesk.plugins.knowledgebase.server.ArticlePrintPermissionChecker;
import com.inet.helpdesk.plugins.knowledgebase.server.CheckArticlePermission;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseAttachmentConnectorImpl;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseConnectorImpl;
import com.inet.helpdesk.plugins.knowledgebase.server.cache.KnowledgebaseSearchCacheAction;
import com.inet.helpdesk.plugins.knowledgebase.server.cache.KnowledgebaseSearchCacheExtension;
import com.inet.helpdesk.plugins.knowledgebase.server.datacare.KnowledgeBaseAttachmentDataCareExtension;
import com.inet.helpdesk.plugins.knowledgebase.server.datacare.MaintenanceDeactivatedLocationCleanupExt;
import com.inet.helpdesk.plugins.knowledgebase.server.datacare.MaintenanceLocationCleanupExtensionImpl;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.CreateArticlePdf;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.CreateOrUpdateArticle;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.DataHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.DeleteArticle;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.FavArticle;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.GetArticleFields;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.GetFuzzySearchHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.InitKnowledgeBaseHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.LoadArticleDetails;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.LoadArticlePreviews;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.LoadSuggestedValues;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.PinArticle;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.SaveViewConfigHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.VoteArticle;
import com.inet.helpdesk.plugins.knowledgebase.server.ticketextension.FuzzySearchArticleExtension;
import com.inet.helpdesk.plugins.knowledgebase.setup.ImageAttachmentMigrationStep;
import com.inet.helpdesk.plugins.knowledgebase.setup.KnowledgeBaseSetupStep;
import com.inet.helpdesk.plugins.knowledgebase.setup.PublicArticleMigrationStep;
import com.inet.helpdesk.plugins.knowledgebase.structure.KBAIStructureProvider;
import com.inet.helpdesk.plugins.knowledgebase.taskplanner.action.CreateKnowledgeBaseEntryActionFactory;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.MaintenanceDeactivatedLocationCleanupExtension;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.MaintenanceLocationCleanupExtension;
import com.inet.http.PluginServlet;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.maintenance.api.cache.MaintenanceCacheAction;
import com.inet.maintenance.api.cache.MaintenanceCacheExtension;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionManager;
import com.inet.permissions.url.PluginPermissionChecker;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.veto.VetoPower;
import com.inet.plugin.veto.VetoType;
import com.inet.remote.gui.IModule;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.setupwizard.api.SetupStep;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.theme.server.ThemeResource;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import java.net.URL;

@PluginInfo(id="knowledgebase", dependencies="helpdesk;remotegui;htmlengine", optionalDependencies="attachments;theme;reporting;help;maintenance;maintenance.helpdesk;setupwizard;helpdesksetupwizard;collaboration;ai;taskplanner;taskplanner.helpdesk", internal="", packages="com.inet.helpdesk.plugins.knowledgebase.api", group="applications;tickets", flags="", version="25.10.314", icon="com/inet/helpdesk/plugins/knowledgebase/server/images/knowledgebase_48.png")
public class KnowledgeBaseServerPlugin
implements ServerPlugin {
    public static final String PLUGIN_ID = "knowledgebase";
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.knowledgebase.structure.i18n.ConfigStructure", KnowledgeBaseServerPlugin.class);
    public static final I18nMessages CLIENT_MSG = new I18nMessages("com.inet.helpdesk.plugins.knowledgebase.client.i18n.knowledgebase.LanguageResources", KnowledgeBaseServerPlugin.class);
    public static final Logger LOGGER = LogManager.getLogger((String)"KnowledgeBase");
    public static final VetoType VETO_TYPE = new VetoType("knowledgebaseindex", 600);
    private static final String CATEGORY_KNOWLEDGEBASE = "knowledgebase";
    public static final Permission KNOWLEDGE_BASE = SystemPermissionManager.add((String)"knowledgeBase", (String)"knowledgebase", null, (int)2100, (boolean)false, KnowledgeBaseServerPlugin.class);
    public static final Permission KNOWLEDGE_BASE_ALL_LOCATIONS = SystemPermissionManager.add((String)"knowledgeBaseAllCustomers", (String)"knowledgebase", (String)KNOWLEDGE_BASE.getKey(), (int)2200, (boolean)false, KnowledgeBaseServerPlugin.class);
    public static final Permission KNOWLEDGE_BASE_SUPPORTER = SystemPermissionManager.add((String)"knowledgeBaseExperts", (String)"knowledgebase", (String)KNOWLEDGE_BASE.getKey(), (int)2300, (boolean)false, KnowledgeBaseServerPlugin.class);
    public static final Permission KNOWLEDGE_BASE_EDIT_DELETE = SystemPermissionManager.add((String)"knowledgeBaseEditDelete", (String)"knowledgebase", (String)KNOWLEDGE_BASE.getKey(), (int)2400, (boolean)false, KnowledgeBaseServerPlugin.class);
    public static final UserField<String> USERFIELD_KNOWLEDGEBASEVIEWCONFIG;
    private KnowledgeBaseConnectorImpl knowledgeBaseConnector;

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("ticketlist", 1312, new Permission[]{KNOWLEDGE_BASE}){}, new String[]{"ticketlist"});
        container.add((HelpProvider)new HelpProviderImpl("knowledgebase", 1401, new Permission[]{KNOWLEDGE_BASE}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("taskplanner", 9227, new Permission[]{KNOWLEDGE_BASE}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("usersandgroups", 9225, new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("maintenance", 9451, new Permission[]{Permission.valueOfExistingOrCreate((String)"configuration")}){}, new String[0]);
    }

    public void registerExtension(final ServerPluginManager spm) {
        this.knowledgeBaseConnector = new KnowledgeBaseConnectorImpl();
        spm.register(KnowledgeBaseConnector.class, (Object)this.knowledgeBaseConnector);
        spm.register(VetoPower.class, (Object)this.knowledgeBaseConnector);
        spm.runIfPluginLoaded("attachments", () -> new Executable(){

            public void execute() {
                spm.register(KnowledgeBaseAttachmentConnector.class, (Object)new KnowledgeBaseAttachmentConnectorImpl());
                spm.register(AttachmentDataCareExtension.class, (Object)new KnowledgeBaseAttachmentDataCareExtension());
            }
        });
        spm.runIfPluginLoaded("reporting", () -> new Executable(){

            public void execute() {
                spm.register(UserDefinedFunction.class, (Object)new CheckArticlePermission());
                spm.register(PluginPermissionChecker.class, (Object)new ArticlePrintPermissionChecker());
            }
        });
        spm.register(UserField.class, USERFIELD_KNOWLEDGEBASEVIEWCONFIG);
        spm.runIfPluginLoaded("helpdesksetupwizard", () -> new Executable(){

            public void execute() {
                spm.register(SetupStep.class, (Object)new KnowledgeBaseSetupStep(KnowledgeBaseServerPlugin.this.knowledgeBaseConnector));
                spm.register(SetupStep.class, (Object)new ImageAttachmentMigrationStep(KnowledgeBaseServerPlugin.this.knowledgeBaseConnector));
                spm.register(SetupStep.class, (Object)new PublicArticleMigrationStep(KnowledgeBaseServerPlugin.this.knowledgeBaseConnector));
            }
        });
        spm.register(AdditionalFieldSetting.class, (Object)new ArticleFieldSettings());
        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        combinedFile.add(this.getClass(), "/com/inet/helpdesk/plugins/knowledgebase/client/knowledgebase/articleDialog.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "knowledgebase_articleDialog.html", combinedFile));
        combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        combinedFile.add(this.getClass(), "/com/inet/helpdesk/plugins/knowledgebase/client/knowledgebase/articleEditDialog.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "knowledgebase_articleEditDialog.html", combinedFile));
        combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        combinedFile.add(this.getClass(), "/com/inet/helpdesk/plugins/knowledgebase/client/knowledgebase/articleDetails.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "knowledgebase_articleDetails.html", combinedFile));
        combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        combinedFile.add(this.getClass(), "/com/inet/helpdesk/plugins/knowledgebase/client/knowledgebase/articlePreviewShort.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "knowledgebase_articlePreviewShort.html", combinedFile));
        combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        combinedFile.add(this.getClass(), "/com/inet/helpdesk/plugins/knowledgebase/client/knowledgebase/controllerKnowledgeBase.js");
        combinedFile.add(this.getClass(), "/com/inet/helpdesk/plugins/knowledgebase/client/knowledgebase/controllerArticleDetails.js");
        combinedFile.add(this.getClass(), "/com/inet/helpdesk/plugins/knowledgebase/client/knowledgebase/controllerArticleDialog.js");
        combinedFile.add(this.getClass(), "/com/inet/helpdesk/plugins/knowledgebase/client/knowledgebase/controllerArticleEditDialog.js");
        combinedFile.add(this.getClass(), "/com/inet/helpdesk/plugins/knowledgebase/client/knowledgebase/knowledgeBaseFactory.js");
        combinedFile.addMessages(CLIENT_MSG);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "knowledgebase.js", combinedFile));
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 107, "defaulttheme.css", new FileCombiner.CombinedFile("text/css", new URL[]{this.getClass().getClassLoader().getResource("com/inet/helpdesk/plugins/knowledgebase/client/css/knowledgebasedefault.css")})));
        spm.runIfPluginLoaded("theme", () -> new Executable(){

            public void execute() {
                spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getClassLoader().getResource("com/inet/helpdesk/plugins/knowledgebase/client/css/knowledgebase.less")));
                spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getClassLoader().getResource("com/inet/helpdesk/plugins/knowledgebase/client/css/knowledgebase-sprites.less")));
            }
        });
        spm.runIfPluginLoaded("maintenance", () -> new Executable(){

            public void execute() {
                KnowledgebaseSearchCacheAction cacheAction = new KnowledgebaseSearchCacheAction();
                spm.register(MaintenanceCacheAction.class, (Object)cacheAction);
                spm.register(ServerPluginManagerListener.class, (Object)cacheAction);
                spm.register(MaintenanceCacheExtension.class, (Object)new KnowledgebaseSearchCacheExtension(cacheAction));
            }
        });
        spm.runIfPluginLoaded("maintenance.helpdesk", () -> new Executable(){

            public void execute() {
                spm.register(MaintenanceLocationCleanupExtension.class, (Object)new MaintenanceLocationCleanupExtensionImpl());
                spm.register(MaintenanceDeactivatedLocationCleanupExtension.class, (Object)new MaintenanceDeactivatedLocationCleanupExt());
            }
        });
        spm.runIfPluginLoaded("ticketlist", () -> new Executable(){

            public void execute() {
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/knowledgebase/client/knowledgebase/ticketlist.extension.js");
                combinedFile.addMessages(new I18nMessages("com.inet.helpdesk.plugins.knowledgebase.client.i18n.ticketlist.LanguageResources", KnowledgeBaseServerPlugin.class));
                spm.register(TicketPageExtension.class, (Object)new FuzzySearchArticleExtension());
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/knowledgebase/server/ticketextension/fuzzysearcharticleextension.js");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 222, "helpdesk.ticket.extensions.js", combinedFile));
            }
        });
        spm.runIfPluginLoaded("collaboration", () -> new Executable(){

            public void execute() {
                spm.register(BotCommand.class, (Object)new KnowledgeBaseInfoBotCommand());
                spm.register(BotCommand.class, (Object)new KnowledgeBaseSearchBotCommand());
            }
        });
        spm.runIfPluginLoaded("ai", () -> new Executable(){

            public void execute() {
                spm.register(ConfigStructureProvider.class, (Object)new KBAIStructureProvider());
            }
        });
        spm.runIfPluginLoaded("taskplanner.helpdesk", () -> new Executable(){

            public void execute() {
                spm.register(ResultActionFactory.class, (Object)new CreateKnowledgeBaseEntryActionFactory());
            }
        });
        KnowledgeBaseModule module = new KnowledgeBaseModule();
        spm.register(IModule.class, (Object)module);
        final KnowledgeBaseAngularApplicationServlet moduleHandler = new KnowledgeBaseAngularApplicationServlet(module.getPath());
        spm.register(PluginServlet.class, (Object)moduleHandler);
        moduleHandler.addServiceMethod(new LoadArticlePreviews());
        moduleHandler.addServiceMethod(new LoadArticleDetails());
        moduleHandler.addServiceMethod(new GetArticleFields());
        moduleHandler.addServiceMethod(new VoteArticle());
        moduleHandler.addServiceMethod(new PinArticle());
        moduleHandler.addServiceMethod(new FavArticle());
        moduleHandler.addServiceMethod(new CreateOrUpdateArticle());
        moduleHandler.addServiceMethod(new DeleteArticle());
        moduleHandler.addServiceMethod(new InitKnowledgeBaseHandler());
        moduleHandler.addServiceMethod(new SaveViewConfigHandler());
        moduleHandler.addServiceMethod(new DataHandler());
        moduleHandler.addServiceMethod(new LoadSuggestedValues());
        spm.register(ServiceMethod.class, (Object)new GetFuzzySearchHandler());
        spm.runIfPluginLoaded("reporting", () -> new Executable(){

            public void execute() {
                moduleHandler.addServiceMethod(new CreateArticlePdf());
            }
        });
    }

    public void init(ServerPluginManager spm) {
    }

    public void reset() {
    }

    public void restart() {
    }

    static {
        Permission.createCategory((String)"knowledgebase", (int)2000, HdPermissions.class);
        HdPermissions.addFreePermission((Permission)KNOWLEDGE_BASE);
        HdPermissions.addFreePermission((Permission)KNOWLEDGE_BASE_SUPPORTER);
        HdPermissions.addFreePermission((Permission)KNOWLEDGE_BASE_ALL_LOCATIONS);
        USERFIELD_KNOWLEDGEBASEVIEWCONFIG = new UserField<String>("knowledgebaseviewconfig"){};
    }
}

