/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.taskplanner.action;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.plugins.knowledgebase.taskplanner.action.CreateKnowledgeBaseEntryAction;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.SelectInputField;
import com.inet.taskplanner.server.api.field.TextAreaField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CreateKnowledgeBaseEntryActionFactory
extends ResultActionFactory<CreateKnowledgeBaseEntryAction> {
    public static final String EXTENSION_NAME = "result.createkbentry";
    public static final String PROPERTY_TICKET_REFERENCE = "ticketReference";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_CATEGORY_ID = "categoryId";
    public static final String PROPERTY_LANGUAGE = "language";
    public static final String PROPERTY_PUBLISH_STATE = "publishState";
    public static final String PROPERTY_PROBLEM = "problem";
    public static final String PROPERTY_SOLUTION = "solution";
    public static final String PROPERTY_LOCATION = "CustomerLocation";
    public static final String PROPERTY_LOCATION_CUSTOM = "locationCustom";
    private static final String LOCATION_OTHER_VALUE = "__OTHER__";

    public CreateKnowledgeBaseEntryActionFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Collections.singletonList(ResultFlavor.NONE);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String name = KnowledgeBaseServerPlugin.MSG.getMsg("CreateKnowledgeBaseEntryAction.Name", new Object[0]);
        String description = KnowledgeBaseServerPlugin.MSG.getMsg("CreateKnowledgeBaseEntryAction.Description", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/knowledgebase/server/images/knowledgebase_add_32.svg");
        String helpKey = "taskplanner.action.create-kb-entry";
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField ticketRef = new TextField(PROPERTY_TICKET_REFERENCE, KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_REFTICKETID", new Object[0]));
        ticketRef.setValue("{Ticket ID}");
        HDPlaceholders.setPlaceholderDynamicallyForTextFieldInAction((GUID)taskID, (TextField)ticketRef);
        fields.add(ticketRef);
        TextField titleField = new TextField(PROPERTY_TITLE, KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_TITLE", new Object[0]));
        titleField.setValue("");
        fields.add(titleField);
        List categories = CategoryManager.getInstance().getAll(true);
        categories.sort(Comparator.comparing(CategoryVO::getPath, String.CASE_INSENSITIVE_ORDER));
        ArrayList<LocalizedKey> categoryOptions = new ArrayList<LocalizedKey>();
        for (CategoryVO c : categories) {
            categoryOptions.add(new LocalizedKey(String.valueOf(c.getId()), c.getPath()));
        }
        SelectField categoryField = new SelectField(PROPERTY_CATEGORY_ID, KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_CATEGORYID", new Object[0]), categoryOptions);
        if (!categoryOptions.isEmpty()) {
            categoryField.setValue(((LocalizedKey)categoryOptions.get(0)).getKey());
            categoryField.setLabel("Category");
        }
        fields.add(categoryField);
        ArrayList<LocalizedKey> langOptions = new ArrayList<LocalizedKey>();
        langOptions.add(new LocalizedKey("", KnowledgeBaseServerPlugin.MSG.getMsg("default", new Object[0])));
        langOptions.add(new LocalizedKey("de", "Deutsch"));
        langOptions.add(new LocalizedKey("en", "English"));
        SelectField langField = new SelectField(PROPERTY_LANGUAGE, KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_LANGUAGEID", new Object[0]), langOptions);
        langField.setValue("");
        fields.add(langField);
        ArrayList<LocalizedKey> psOptions = new ArrayList<LocalizedKey>();
        for (PublishState ps : PublishState.values()) {
            psOptions.add(new LocalizedKey(ps.name(), ps.getDisplayName()));
        }
        SelectField publishField = new SelectField(PROPERTY_PUBLISH_STATE, KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_PUBLISHSTATE", new Object[0]), psOptions);
        publishField.setValue(PublishState.INREVIEW.name());
        fields.add(publishField);
        SelectInputField locationField = new SelectInputField(PROPERTY_LOCATION, KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_LOCATION", new Object[0]), 5);
        locationField.setAllowCustomValues(true);
        locationField.setValue("");
        locationField.setConditions(Collections.singletonList(FieldCondition.visible((Field)publishField, (FieldCondition.OP)FieldCondition.OP.equals, (String)PublishState.LOCATION.name())));
        fields.add(locationField);
        TextField problemField = new TextField(PROPERTY_PROBLEM, KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_PROBLEM", new Object[0]));
        problemField.setValue("{ticket.inquirytext}");
        fields.add(problemField);
        TextAreaField solutionField = new TextAreaField(PROPERTY_SOLUTION, KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_SOLUTION", new Object[0]));
        solutionField.setValue("{ticket.reastephistory}");
        fields.add(solutionField);
        return new ResultActionInfo(this.getExtensionName(), name, description, iconURL, helpKey, fields);
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        String location;
        String ticketRef = definition.getProperty(PROPERTY_TICKET_REFERENCE);
        if (ticketRef == null || ticketRef.trim().isEmpty()) {
            throw new ValidationException(new String[]{KnowledgeBaseServerPlugin.MSG.getMsg("result.createknowledgebaseentry.error.ticketreference", new Object[0])});
        }
        String categoryId = definition.getProperty(PROPERTY_CATEGORY_ID);
        if (categoryId == null || categoryId.trim().isEmpty()) {
            throw new ValidationException(new String[]{KnowledgeBaseServerPlugin.MSG.getMsg("result.createknowledgebaseentry.error.category", new Object[0])});
        }
        String title = definition.getProperty(PROPERTY_TITLE);
        if (title == null || title.trim().isEmpty()) {
            throw new ValidationException(new String[]{KnowledgeBaseServerPlugin.MSG.getMsg("result.createknowledgebaseentry.error.title", new Object[0])});
        }
        String problem = definition.getProperty(PROPERTY_PROBLEM);
        if (problem == null || problem.trim().isEmpty()) {
            throw new ValidationException(new String[]{KnowledgeBaseServerPlugin.MSG.getMsg("result.createknowledgebaseentry.error.problem", new Object[0])});
        }
        String solution = definition.getProperty(PROPERTY_SOLUTION);
        if (solution == null || solution.trim().isEmpty()) {
            throw new ValidationException(new String[]{KnowledgeBaseServerPlugin.MSG.getMsg("result.createknowledgebaseentry.error.solution", new Object[0])});
        }
        String publishState = definition.getProperty(PROPERTY_PUBLISH_STATE);
        if (PublishState.LOCATION.name().equals(publishState) && ((location = definition.getProperty(PROPERTY_LOCATION)) == null || location.trim().isEmpty())) {
            throw new ValidationException(new String[]{KnowledgeBaseServerPlugin.MSG.getMsg("result.createknowledgebaseentry.error.location", new Object[0])});
        }
    }

    protected CreateKnowledgeBaseEntryAction createInstanceFrom(ResultActionDefinition definition, GUID taskID) {
        String locationValue;
        int ticketId = Integer.parseInt(definition.getProperty(PROPERTY_TICKET_REFERENCE));
        int categoryId = Integer.parseInt(definition.getProperty(PROPERTY_CATEGORY_ID));
        String language = definition.getProperty(PROPERTY_LANGUAGE);
        if (language == null) {
            language = "";
        }
        PublishState publishState = PublishState.valueOf(definition.getProperty(PROPERTY_PUBLISH_STATE));
        String title = definition.getProperty(PROPERTY_TITLE);
        String problem = definition.getProperty(PROPERTY_PROBLEM);
        String solution = definition.getProperty(PROPERTY_SOLUTION);
        int locationId = 0;
        if (PublishState.LOCATION.equals((Object)publishState) && (locationValue = definition.getProperty(PROPERTY_LOCATION)) != null && !locationValue.trim().isEmpty()) {
            if (locationValue.matches("\\d+")) {
                locationId = Integer.parseInt(locationValue);
            } else {
                List locations = LocationManager.getInstance().getAll(true);
                locationId = locations.stream().filter(l -> locationValue.equalsIgnoreCase(l.getDisplayValue())).map(FieldVO::getId).findFirst().orElse(0);
            }
        }
        return new CreateKnowledgeBaseEntryAction(ticketId, categoryId, language, publishState, title, problem, solution, taskID, locationId);
    }

    public boolean isAvailable() {
        return SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_SUPPORTER);
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String title = definition.getProperty(PROPERTY_TITLE);
        summary.add(new SummaryEntry(KnowledgeBaseServerPlugin.MSG.getMsg("result.createknowledgebaseentry.summary.title", new Object[0]), title != null ? title : ""));
        String publishStateValue = definition.getProperty(PROPERTY_PUBLISH_STATE);
        if (publishStateValue != null) {
            PublishState publishState = PublishState.valueOf(publishStateValue);
            summary.add(new SummaryEntry(KnowledgeBaseServerPlugin.MSG.getMsg("result.createknowledgebaseentry.summary.publishstate", new Object[0]), publishState.getDisplayName()));
            if (PublishState.LOCATION.equals((Object)publishState)) {
                String locProp = definition.getProperty(PROPERTY_LOCATION);
                String locationLabel = "";
                if (locProp != null && !locProp.isEmpty()) {
                    List locations = LocationManager.getInstance().getAll(true);
                    locationLabel = locations.stream().filter(l -> String.valueOf(l.getId()).equals(locProp)).map(LocationVO::getDisplayValue).findFirst().orElse(locProp);
                }
                summary.add(new SummaryEntry(KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_LOCATION", new Object[0]), locationLabel));
            }
        }
        return new SummaryInfo(summary);
    }
}

