/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.cache;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.http.ClientMessageException;
import com.inet.maintenance.api.cache.MaintenanceCacheAction;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.veto.VetoType;
import com.inet.search.index.IndexerStatus;
import javax.annotation.Nullable;

@JsonData
public class KnowledgebaseSearchCacheAction
extends MaintenanceCacheAction
implements ServerPluginManagerListener {
    private static final int INDEXER_COUNT_NOT_AVAILABLE = -1;
    private IndexerStatus indexerStatus = new IndexerStatus(false, 0L, -1L, 0L);
    private boolean knowledgeBaseInitialized;

    public KnowledgebaseSearchCacheAction() {
        super("reloadKnowledgebaseSearchCache");
    }

    public void updateAction() {
        this.indexerStatus = ((KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class)).getIndexer().getIndexerStatus();
        this.setDefaultState(this.indexerStatus.isRunning());
        this.setEnabled(!this.indexerStatus.isRunning() && this.knowledgeBaseInitialized);
    }

    public String executeAction() throws ClientMessageException {
        ((KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class)).getIndexer().reIndex();
        return KnowledgebaseSearchCacheAction.getDefaultExecuteActionMessage();
    }

    public void vetoFinished(@Nullable VetoType type) {
        if (type == KnowledgeBaseServerPlugin.VETO_TYPE || type == null) {
            this.knowledgeBaseInitialized = true;
        }
    }

    public IndexerStatus getIndexerStatus() {
        return this.indexerStatus;
    }
}

