/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDuplicator;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.ExternalImageAttachmentAdder;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachment;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachmentConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseUtils;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.http.upload.AttachmentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class KnowledgeBaseAttachmentConnectorImpl
implements KnowledgeBaseAttachmentConnector {
    public KnowledgeBaseAttachmentConnectorImpl() {
        KnowledgeBaseServerPlugin.LOGGER.debug((Object)("Created attachment meta information for knowledge base (id: " + KNOWLEDGE_BASE_ATTACHMENTS.getId() + ", context: " + KNOWLEDGE_BASE_ATTACHMENTS.getAttachmentSubContext() + " )"));
    }

    @Override
    public List<KnowledgeBaseAttachment> getAttachments(int articleId, boolean includeEmbeddedImages) throws ServerDataException {
        ArrayList<KnowledgeBaseAttachment> attachments = new ArrayList<KnowledgeBaseAttachment>();
        ServerPluginManager spm = ServerPluginManager.getInstance();
        try {
            AttachmentService attachmentService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
            Map fullAttachmentDataFor = attachmentService.getFullAttachmentDataFor(KNOWLEDGE_BASE_ATTACHMENTS, Arrays.asList(articleId));
            for (Map.Entry entry : fullAttachmentDataFor.entrySet()) {
                AttachmentRow key = (AttachmentRow)entry.getKey();
                if (!includeEmbeddedImages && key.isEmbedded()) continue;
                AttachmentFileRow value = (AttachmentFileRow)entry.getValue();
                AttachmentDescription description = AttachmentService.createDescriptionFrom((AttachmentRow)key, (AttachmentFileRow)value);
                KnowledgeBaseAttachment kba = new KnowledgeBaseAttachment(description.getAttachmentType().getAttachmentSubContext(), description.getOwnerId(), -1, description.getFileName(), description.getRESTfulFilePath(), description.getLastModified(), description.getFilesize(), key.isEmbedded());
                attachments.add(kba);
            }
        }
        catch (Exception e) {
            throw new ServerDataException(e);
        }
        Collections.sort(attachments, new Comparator<KnowledgeBaseAttachment>(){

            @Override
            public int compare(KnowledgeBaseAttachment o1, KnowledgeBaseAttachment o2) {
                int nameCompare = o1.getName().compareToIgnoreCase(o2.getName());
                if (nameCompare != 0) {
                    return nameCompare;
                }
                long lmCompare = o1.getLastModified() - o2.getLastModified();
                return lmCompare == 0L ? 0 : (lmCompare < 0L ? -1 : 1);
            }
        });
        return attachments;
    }

    @Override
    public void deleteAttachment(int articleId, String fileName) throws ServerDataException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        try {
            AttachmentService attachmentService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
            attachmentService.deleteAttachment(KNOWLEDGE_BASE_ATTACHMENTS, articleId, -1, fileName);
        }
        catch (Exception sqle) {
            throw new ServerDataException(sqle);
        }
    }

    @Override
    public void deleteAllAttachments(int articleId) throws ServerDataException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        try {
            AttachmentService attachmentService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
            Map fullAttachmentDataFor = attachmentService.getFullAttachmentDataFor(KNOWLEDGE_BASE_ATTACHMENTS, Arrays.asList(articleId));
            for (Map.Entry entry : fullAttachmentDataFor.entrySet()) {
                AttachmentRow key = (AttachmentRow)entry.getKey();
                attachmentService.deleteAttachment(key.getType(), key.getOwnerId().intValue(), key.getStepId() == null ? -1 : key.getStepId(), key.getFileName());
            }
        }
        catch (Exception sqle) {
            throw new ServerDataException(sqle);
        }
    }

    @Override
    public void updateArticleAttachments(int articleId, LargeContent[] added, List<KnowledgeBaseAttachment> copied, List<KnowledgeBaseAttachment> deleted) throws ServerDataException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        try {
            KnowledgeBaseConnector kbc = (KnowledgeBaseConnector)spm.getSingleInstance(KnowledgeBaseConnector.class);
            Article article = kbc.getArticle(articleId);
            AttachmentService attachmentService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
            if (deleted != null && !deleted.isEmpty()) {
                for (KnowledgeBaseAttachment knowledgeBaseAttachment : deleted) {
                    attachmentService.deleteAttachment(AttachmentOwnerType.getTypeForSubContext((String)knowledgeBaseAttachment.getType()), knowledgeBaseAttachment.getId(), knowledgeBaseAttachment.getStepId(), knowledgeBaseAttachment.getName());
                }
            }
            if (copied != null && !copied.isEmpty()) {
                AttachmentDuplicator attDuplicator = (AttachmentDuplicator)ServerPluginManager.getInstance().getSingleInstance(AttachmentDuplicator.class);
                for (KnowledgeBaseAttachment knowledgeBaseAttachment : copied) {
                    if (knowledgeBaseAttachment.isEmbedded()) continue;
                    AttachmentKey attKey = new AttachmentKey(AttachmentOwnerType.getTypeForSubContext((String)knowledgeBaseAttachment.getType()), Integer.valueOf(knowledgeBaseAttachment.getId()), Integer.valueOf(knowledgeBaseAttachment.getStepId()), Integer.valueOf(-1), knowledgeBaseAttachment.getName());
                    try {
                        attDuplicator.duplicateAttachments(Collections.singletonList(attKey), KNOWLEDGE_BASE_ATTACHMENTS, articleId, -1, -1);
                    }
                    catch (Throwable t) {
                        KnowledgeBaseServerPlugin.LOGGER.error((Object)("Attachment '" + knowledgeBaseAttachment.getName() + "' from ticket #" + knowledgeBaseAttachment.getId() + " could not be copied to the new article: " + t.getMessage()));
                        KnowledgeBaseServerPlugin.LOGGER.error(t);
                    }
                }
            }
            ExternalImageAttachmentAdder attachmentAdder = (ExternalImageAttachmentAdder)ServerPluginManager.getInstance().getSingleInstance(ExternalImageAttachmentAdder.class);
            if (added != null && added.length > 0) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (LargeContent data : added) {
                    AttachmentDescription desc = attachmentAdder.addAttachment(KNOWLEDGE_BASE_ATTACHMENTS, articleId, -1, data);
                    if (data.getContentType() != AttachmentType.EmbeddedImage) continue;
                    hashMap.put(data.getName(), desc.getRESTfulFilePath());
                }
                if (!hashMap.isEmpty()) {
                    if (article.getProblem() != null) {
                        article.setProblem(HtmlConverter.getCompactHtmlText((String)article.getProblem(), hashMap, null, (boolean)true));
                    }
                    if (article.getSolution() != null) {
                        article.setSolution(HtmlConverter.getCompactHtmlText((String)article.getSolution(), hashMap, null, (boolean)true));
                    }
                    kbc.updateArticle(article);
                }
            }
            String string = attachmentAdder.convertExternalImagesToAttachments(KNOWLEDGE_BASE_ATTACHMENTS, articleId, -1, article.getProblem());
            String string2 = attachmentAdder.convertExternalImagesToAttachments(KNOWLEDGE_BASE_ATTACHMENTS, articleId, -1, article.getSolution());
            if (string != null || string2 != null) {
                if (string != null) {
                    article.setProblem(string);
                }
                if (string2 != null) {
                    article.setSolution(string2);
                }
                kbc.updateArticle(article);
            }
            List<KnowledgeBaseAttachment> attachments = this.getAttachments(articleId, true);
            HashSet<KnowledgeBaseAttachment> deleteable = new HashSet<KnowledgeBaseAttachment>();
            for (KnowledgeBaseAttachment kba : attachments) {
                String artSolution;
                if (!kba.isEmbedded()) continue;
                String attSrc = "src=\"" + kba.getServerpath() + "\"";
                String artProblem = article.getProblem() == null ? "" : article.getProblem();
                String string3 = artSolution = article.getSolution() == null ? "" : article.getSolution();
                if (artProblem.contains(attSrc) || artSolution.contains(attSrc)) continue;
                deleteable.add(kba);
            }
            if (!deleteable.isEmpty()) {
                for (KnowledgeBaseAttachment att : deleteable) {
                    this.deleteAttachment(att.getId(), att.getName());
                }
            }
            KnowledgeBaseUtils.updateAttachmentNames(article);
            kbc.updateArticleCacheAndIndex(articleId);
        }
        catch (Exception sqle) {
            throw new ServerDataException(sqle);
        }
    }
}

