/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler.data;

import com.inet.annotations.JsonData;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;

@JsonData
public class ArticlePreview {
    private static final int PREVIEW_MAX_PROBLEM_LENGTH = 200;
    private int articleId;
    private String problem;
    private String title;
    private PublishState publishState;
    private String category;
    private int categoryId;
    private String location;
    private long lastModified;
    private boolean pinned;
    private boolean favorite;
    private transient Article articleReference;

    private ArticlePreview() {
    }

    public ArticlePreview(int articleId, String title, String problem, PublishState publishState, String category, int categoryId, String location, long lastModified, boolean pinned, boolean favorite) {
        this.articleId = articleId;
        this.title = title;
        this.problem = problem;
        this.publishState = publishState;
        this.category = category;
        this.categoryId = categoryId;
        this.location = location;
        this.lastModified = lastModified;
        this.pinned = pinned;
        this.favorite = favorite;
    }

    public ArticlePreview(int articleId, String title, String category, long lastModified, boolean pinned, boolean favorite) {
        this.articleId = articleId;
        this.title = title;
        this.category = category;
        this.lastModified = lastModified;
        this.pinned = pinned;
        this.favorite = favorite;
    }

    public int getArticleId() {
        return this.articleId;
    }

    public String getProblem() {
        return this.problem;
    }

    public String getTitle() {
        return this.title;
    }

    public PublishState getPublishState() {
        return this.publishState;
    }

    public String getCategory() {
        return this.category;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public String getLocation() {
        return this.location;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void setArticleReference(Article articleReference) {
        this.articleReference = articleReference;
    }

    public void generatePreviewText() {
        if (this.articleReference == null) {
            return;
        }
        Object problem = "";
        String htmlProblem = this.articleReference.getProblem();
        if (htmlProblem == null || htmlProblem.isEmpty()) {
            htmlProblem = this.articleReference.getSolution();
        }
        problem = HtmlConverter.html2text((String)htmlProblem, (int)400).getContent();
        if (((String)(problem = ((String)problem).replace("\r", "").replace("\n", " ").replace("  ", " "))).length() > 200) {
            problem = ((String)problem).substring(0, 197) + "...";
        }
        this.problem = problem;
    }

    public String toString() {
        return "Article #" + this.articleId;
    }
}

