/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.AbstractKnowledgeBaseHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.LoadSuggestedValuesRequestData;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.LoadSuggestedValuesResponseData;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SuggestedValue;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class LoadSuggestedValues
extends AbstractKnowledgeBaseHandler<LoadSuggestedValuesRequestData, LoadSuggestedValuesResponseData> {
    public String getMethodName() {
        return "web_knowledgebase_loadsuggestedvalues";
    }

    @Override
    protected LoadSuggestedValuesResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, LoadSuggestedValuesRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        KnowledgeBaseConnector knowledgeBaseConnector = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
        List<SuggestedValue> suggestedValues = knowledgeBaseConnector.getSuggestedValues(input.getSearchTerm());
        suggestedValues.sort(Comparator.naturalOrder());
        ArrayList<LocalizedKey> tags = new ArrayList<LocalizedKey>();
        for (SuggestedValue value : suggestedValues) {
            tags.add(new LocalizedKey(value.getKey(), StringFunctions.encodeHTML((String)value.getDisplayName())));
            if (value.getType() == SuggestedValue.SuggestedValueType.VALUE) continue;
        }
        return new LoadSuggestedValuesResponseData(tags);
    }
}

