/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachmentConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseUtils;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.AbstractKnowledgeBaseHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.CreateOrUpdateArticleRequestData;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.CreateOrUpdateArticleResponseData;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.upload.AttachmentDescription;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CreateOrUpdateArticle
extends AbstractKnowledgeBaseHandler<CreateOrUpdateArticleRequestData, CreateOrUpdateArticleResponseData> {
    public String getMethodName() {
        return "web_knowledgebase_createorupdatearticle";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateOrUpdateArticleResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, CreateOrUpdateArticleRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        if (!SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_EDIT_DELETE)) {
            throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.forbidden.edit", new Object[0]));
        }
        final ArrayList openStream = new ArrayList();
        ArrayList<LargeContent> addedAttachments = new ArrayList<LargeContent>();
        try {
            if (input.getAttachments() != null) {
                int attachmentNumber = 0;
                for (AttachmentDescription ad : input.getAttachments()) {
                    try {
                        final Part f = request.getPart("attachment" + attachmentNumber++);
                        if (f == null) continue;
                        LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                            public InputStream getStream() {
                                try {
                                    InputStream inputStream = f.getInputStream();
                                    openStream.add(inputStream);
                                    return inputStream;
                                }
                                catch (Exception e) {
                                    KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
                                    return null;
                                }
                            }

                            public long getSize() {
                                return f.getSize();
                            }
                        });
                        lc.setContentType(ad.getAttachmentType());
                        lc.setLastModified(ad.getLastModified());
                        lc.setName(ad.getName());
                        addedAttachments.add(lc);
                    }
                    catch (ServletException | IOException f) {
                        // empty catch block
                    }
                }
            }
            KnowledgeBaseConnector knowledgeBaseConnector = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
            int articleId = input.getArticleId();
            if (articleId == -1) {
                articleId = knowledgeBaseConnector.createArticle(this.updateArticleValues(new Article(), input.getData(), currentUser));
            } else {
                Article article = this.getArticleIfPermitted(input.getArticleId(), currentUser);
                knowledgeBaseConnector.updateArticle(this.updateArticleValues(article, input.getData(), currentUser));
            }
            if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                KnowledgeBaseAttachmentConnector kbac = (KnowledgeBaseAttachmentConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseAttachmentConnector.class);
                kbac.updateArticleAttachments(articleId, addedAttachments.toArray(new LargeContent[addedAttachments.size()]), input.getAttachmentsCopied(), input.getAttachmentsDeleted());
            }
            CreateOrUpdateArticleResponseData createOrUpdateArticleResponseData = new CreateOrUpdateArticleResponseData(articleId);
            return createOrUpdateArticleResponseData;
        }
        finally {
            for (InputStream stream : openStream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
                }
            }
        }
    }

    private Article updateArticleValues(Article article, HashMap<String, String> data, UserAccount currentUser) {
        for (Map.Entry<String, String> entry : data.entrySet()) {
            switch (entry.getKey()) {
                case "ARTICLE_CATEGORYID": {
                    article.setCategoryId(Integer.parseInt(entry.getValue()));
                    break;
                }
                case "ARTICLE_ID": {
                    article.setArticleId(Integer.parseInt(entry.getValue()));
                    break;
                }
                case "ARTICLE_LANGUAGEID": {
                    article.setLanguageId(entry.getValue());
                    break;
                }
                case "ARTICLE_LASTEDITORID": {
                    article.setLastEditorId(Integer.parseInt(entry.getValue()));
                    break;
                }
                case "ARTICLE_LASTMODIFIED": {
                    article.setLastModified(Long.parseLong(entry.getValue()));
                    break;
                }
                case "ARTICLE_LOCATIONID": {
                    article.setLocationId(Integer.parseInt(entry.getValue()));
                    break;
                }
                case "ARTICLE_PINNED": {
                    article.setPinned(Boolean.parseBoolean(entry.getValue()));
                    break;
                }
                case "ARTICLE_PROBLEM": {
                    String problem = KnowledgeBaseUtils.convertAttachmentPathsToServer(entry.getValue());
                    problem = HtmlConverter.getCompactHtmlText((String)problem, null);
                    article.setProblem(problem);
                    break;
                }
                case "ARTICLE_PUBLISHSTATE": {
                    article.setPublishState(PublishState.valueOf(entry.getValue()));
                    break;
                }
                case "ARTICLE_REFTICKETID": {
                    String value = entry.getValue();
                    try {
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || value.isEmpty()) {
                            article.setRefTicketId(-1);
                            break;
                        }
                        String numberValue = value.replaceAll("[^-?0-9]+", "");
                        int i = Integer.parseInt(numberValue);
                        TicketDataConnector tdc = (TicketDataConnector)ServerPluginManager.getInstance().getSingleInstance(TicketDataConnector.class);
                        if (i != -1 && tdc.getTicket(ContextType.supporter, i, TicketDataConnector.TicketText.NONE) == null) {
                            throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.refIDNotATicket", new Object[]{String.valueOf(i)}));
                        }
                        article.setRefTicketId(i);
                        break;
                    }
                    catch (ClientMessageException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        KnowledgeBaseServerPlugin.LOGGER.warn((Object)e);
                        throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.refIDNotANumber", new Object[]{value}));
                    }
                }
                case "ARTICLE_SOLUTION": {
                    String solution = KnowledgeBaseUtils.convertAttachmentPathsToServer(entry.getValue());
                    solution = HtmlConverter.getCompactHtmlText((String)solution, null);
                    article.setSolution(solution);
                    break;
                }
                case "ARTICLE_TITLE": {
                    article.setTitle(entry.getValue());
                    break;
                }
                case "ARTICLE_ATTACHMENT": {
                    article.setTitle(entry.getValue());
                }
            }
        }
        if (data.size() > 0) {
            article.setLastModified(System.currentTimeMillis());
            article.setLastEditorId(HDUsersAndGroups.getUserID((UserAccount)currentUser));
        }
        return article;
    }
}

