/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server;

import com.inet.editor.HtmlConverter;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.attachments.server.api.TicketAttachmentProvider;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescriptionList;
import com.inet.helpdesk.plugins.attachments.shared.BooleanMatcher;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachment;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseAttachmentConnectorImpl;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Font;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class KnowledgeBaseUtils {
    private static final String SQL_SELECT_CATEGORIES = "SELECT BetID, ParentID, Betreff FROM tblBetreffs WHERE BetID>0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, Integer> collectCategories(Connection connection) throws SQLException {
        boolean ownConnection = false;
        if (connection == null) {
            connection = ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
            ownConnection = true;
        }
        try {
            HashMap<Integer, String> names = new HashMap<Integer, String>();
            HashMap<Integer, Integer> parents = new HashMap<Integer, Integer>();
            try (PreparedStatement pst = connection.prepareStatement(SQL_SELECT_CATEGORIES);
                 ResultSet rs = pst.executeQuery();){
                while (rs.next()) {
                    Integer id = rs.getInt("BetID");
                    Integer parent = rs.getInt("ParentID");
                    String name = rs.getString("Betreff");
                    names.put(id, name);
                    parents.put(id, parent);
                }
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            for (Map.Entry e : names.entrySet()) {
                String strKey = (String)e.getValue();
                strKey = KnowledgeBaseUtils.updateKey(names, parents, (Integer)e.getKey(), strKey);
                result.put(strKey, (Integer)e.getKey());
            }
            HashMap<String, Integer> hashMap = result;
            return hashMap;
        }
        finally {
            if (ownConnection && connection != null) {
                connection.close();
            }
        }
    }

    private static String updateKey(HashMap<Integer, String> names, HashMap<Integer, Integer> parents, Integer id, String strKey) {
        Integer parent = parents.get(id);
        if (parent != null && parent > 0) {
            strKey = names.get(parent) + "\\" + (String)strKey;
            strKey = KnowledgeBaseUtils.updateKey(names, parents, parent, (String)strKey);
        }
        return strKey;
    }

    public static Article getArticleFromTicket(int ticketId, Font defaultFont) {
        UserAccount ownerAccount;
        int currentUserAccountID;
        UserAccount currentUserAccount;
        TicketReader reader = TicketManager.getReader();
        TicketVO ticket = reader.getTicket(ticketId);
        Integer categoryKey = ticket.getCategoryID();
        String subject = ticket.getSubject();
        ReaStepTextVO problemText = reader.getReaStepText(ticket.getInitialReaStepID());
        GUID ownerID = ticket.getOwnerID();
        int status = ticket.getStatusID();
        Integer publishFlag = 0;
        long lastModified = ticket.getLastChanged();
        StringBuilder solutionBuffer = new StringBuilder();
        String solution = "";
        int lastEditorId = -1;
        String languageId = Locale.getDefault().getLanguage().toLowerCase();
        int locationId = -1;
        String problem = problemText.getText();
        if (problem != null && !problem.isEmpty()) {
            if (!problemText.hasHtmlContent()) {
                problem = HtmlConverter.text2html((String)problem, (Font)defaultFont, (boolean)true);
            }
            problem = HtmlConverter.getCompactHtmlText((String)problem, null);
        }
        List stepsForTicket = reader.getReaStepsForTicket(ticketId, BundleStepsFilter.WITH_BUNDLE_STEPS);
        stepsForTicket.stream().filter(step -> step.getActionID() != 4 && step.getActionID() != -6).sorted((step1, step2) -> {
            int diff = Long.compare(step1.getEndDate(), step2.getEndDate());
            if (diff != 0) {
                return diff;
            }
            return Integer.compare(step1.getID(), step2.getID());
        }).map(step -> {
            ReaStepTextVO reaStepText = null;
            reaStepText = step.getActionID() == -4 ? KnowledgeBaseUtils.manualSelectTextFromReaStep(step.getID()) : reader.getReaStepText(step.getID());
            String was = reaStepText.getTextWithoutDuplicate(step);
            boolean isHtml = reaStepText.hasHtmlContent();
            if (was != null && !was.isEmpty()) {
                if (!isHtml) {
                    was = HtmlConverter.text2html((String)was, (Font)defaultFont, (boolean)true);
                }
                was = KnowledgeBaseUtils.getInlinedHtml(was);
                return was;
            }
            return null;
        }).forEach(solutionText -> {
            if (solutionText != null && !solutionText.isEmpty()) {
                if (solutionBuffer.length() > 0) {
                    solutionBuffer.append("<p><br></p><hr><p><br></p>");
                }
                solutionBuffer.append((String)solutionText);
            }
        });
        if (solutionBuffer.length() > 0) {
            solution = HtmlConverter.getCompactHtmlText((String)solutionBuffer.toString(), null);
        }
        if ((currentUserAccount = UserManager.getInstance().getCurrentUserAccount()) != null && !UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)currentUserAccount.getID()) && (currentUserAccountID = HDUsersAndGroups.getUserID((UserAccount)currentUserAccount)) != -1) {
            lastEditorId = currentUserAccountID;
        }
        if (ownerID != null && (ownerAccount = UserManager.getInstance().getUserAccount(ownerID)) != null) {
            String userLanguageId = (String)ownerAccount.getValue((UserField)HDUsersAndGroups.FIELD_LANGUAGE);
            locationId = (Integer)ownerAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
            if (userLanguageId != null && !userLanguageId.isEmpty() && !"xx".equals(userLanguageId)) {
                languageId = userLanguageId;
            }
        }
        PublishState publishState = publishFlag == 1 ? PublishState.SUPPORTER : (publishFlag == 2 ? PublishState.ALL : PublishState.LOCATION);
        Article article = new Article();
        article.setCategoryId(categoryKey == null ? 0 : categoryKey);
        article.setLanguageId(languageId);
        article.setLastEditorId(lastEditorId);
        article.setLastModified(lastModified);
        article.setLocationId(locationId);
        article.setPinned(false);
        article.setProblem(problem);
        article.setPublishState(publishState);
        article.setRefTicketId(status == -200 ? -1 : ticketId);
        article.setSolution(solution);
        article.setTitle(subject);
        KnowledgeBaseUtils.updateAttachmentNames(article);
        return article;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ReaStepTextVO manualSelectTextFromReaStep(int id) {
        DatabaseConnectionFactory f = (DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class);
        try (Connection c = f.getConnectionFromCurrentConfiguration();
             PreparedStatement pst = c.prepareStatement("SELECT was, ishtml FROM tblRealisierung WHERE ReaID = ?");){
            pst.setInt(1, id);
            try (ResultSet rs = pst.executeQuery();){
                if (!rs.next()) throw new PersistenceException("No ReaStep with id " + id);
                ReaStepTextVO reaStepTextVO = ReaStepTextVO.of((String)rs.getString("was"), (boolean)rs.getBoolean("ishtml"));
                return reaStepTextVO;
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public static List<KnowledgeBaseAttachment> getTicketAttachments(int ticketId) {
        if (!ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            return null;
        }
        ArrayList<KnowledgeBaseAttachment> attachmentsCopied = new ArrayList<KnowledgeBaseAttachment>();
        TicketAttachmentProvider tap = (TicketAttachmentProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAttachmentProvider.class);
        AttachmentDescriptionList attachmentsForTicket = tap.getAttachmentsForTicket(Integer.valueOf(ticketId), ContextType.supporter);
        List allEmbedded = attachmentsForTicket.getAttachments().getMatched(BooleanMatcher.ANY, BooleanMatcher.ONLY_TRUE);
        for (AttachmentDescription description : allEmbedded) {
            KnowledgeBaseAttachment kba = new KnowledgeBaseAttachment(description.getAttachmentType().getAttachmentSubContext(), description.getOwnerId(), description.getStepId(), description.getFileName(), description.getRESTfulFilePath(), description.getLastModified(), description.getFilesize(), true);
            attachmentsCopied.add(kba);
        }
        List allAttached = attachmentsForTicket.getAttachments().getMatched(BooleanMatcher.ANY, BooleanMatcher.ONLY_FALSE);
        for (AttachmentDescription description : allAttached) {
            KnowledgeBaseAttachment kba = new KnowledgeBaseAttachment(description.getAttachmentType().getAttachmentSubContext(), description.getOwnerId(), description.getStepId(), description.getFileName(), description.getRESTfulFilePath(), description.getLastModified(), description.getFilesize(), false);
            attachmentsCopied.add(kba);
        }
        return attachmentsCopied;
    }

    static String getInlinedHtml(String htmlText) {
        return HtmlConverter.getInlinedHtml((String)htmlText);
    }

    public static String convertAttachmentPathsToServer(String content) {
        String rootURL;
        if (content != null && (rootURL = SessionStore.getRootURL()) != null) {
            content = content.replace("\"" + rootURL + "Attachments/", "\"Attachments/");
            content = content.replace("\"" + rootURL + "Attachments_", "\"/Attachments_");
        }
        return content;
    }

    public static String convertAttachmentPathsToClient(String content) {
        String rootURL;
        if (content != null && (rootURL = SessionStore.getRootURL()) != null) {
            content = content.replace("\"Attachments/", "\"" + rootURL + "Attachments/");
            content = content.replace("\"/Attachments_", "\"" + rootURL + "Attachments_");
        }
        return content;
    }

    public static void updateAttachmentNames(Article article) {
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            KnowledgeBaseAttachmentConnectorImpl i = new KnowledgeBaseAttachmentConnectorImpl();
            try {
                List<KnowledgeBaseAttachment> attachments = i.getAttachments(article.getArticleId(), true);
                List<String> collect = attachments.stream().map(n -> n.getName()).collect(Collectors.toList());
                article.setAttachment(collect);
            }
            catch (Exception e) {
                KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
            }
        }
    }

    public static void checkPermissionToReadArticle(UserAccount currentUser, Article article) {
        if (article == null) {
            throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.notfound", new Object[0]));
        }
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE})) {
            throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.articleforbidden", new Object[0]));
        }
        if (article.getPublishState() == PublishState.SUPPORTER) {
            if (!SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_SUPPORTER})) {
                throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.articleforbidden", new Object[0]));
            }
        } else if (article.getPublishState() == PublishState.INREVIEW) {
            if (!SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_EDIT_DELETE})) {
                throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.articleforbidden", new Object[0]));
            }
        } else if (article.getPublishState() == PublishState.LOCATION) {
            Integer userLocation = (Integer)currentUser.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
            int locationId = article.getLocationId();
            if (!SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_ALL_LOCATIONS}) && !Integer.valueOf(locationId).equals(userLocation)) {
                throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.articleforbidden", new Object[0]));
            }
        }
    }
}

