/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.setup;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.ArticleSearchResult;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachmentConnector;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseConnectorImpl;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.lib.util.IOFunctions;
import com.inet.mail.api.MailAttachmentUtilities;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.SuppressFBWarnings;

public class ImageAttachmentMigrationStep
extends AutoSetupStep {
    private KnowledgeBaseConnectorImpl knowledgeBaseConnector;

    public ImageAttachmentMigrationStep(KnowledgeBaseConnectorImpl knowledgeBaseConnector) {
        this.knowledgeBaseConnector = knowledgeBaseConnector;
    }

    public StepKey stepKey() {
        return new StepKey("knowledgebase.migrate.base64images");
    }

    public Version getMigrationVersion() {
        return new Version("22.4.266");
    }

    public String getStepDisplayName() {
        return KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.migrate.base64images.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        return true;
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        try {
            this.knowledgeBaseConnector.initialize();
            try (UserAccountScope priv = UserAccountScope.createPrivileged();){
                UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
                ArticleSearchResult searchResult = this.knowledgeBaseConnector.searchArticles(userAccount, "", null, -1, null, Integer.MAX_VALUE);
                for (Article article : searchResult.getArticles()) {
                    String newSolution;
                    String newProblem;
                    ArrayList<LargeContent> largeContents = new ArrayList<LargeContent>();
                    if (article.getProblem().indexOf(" src=\"data:") >= 0 && (newProblem = this.doReplaceImg(article.getProblem(), largeContents)) != null) {
                        article.setProblem(newProblem);
                        this.knowledgeBaseConnector.updateArticle(article);
                    }
                    if (article.getSolution().indexOf(" src=\"data:") >= 0 && (newSolution = this.doReplaceImg(article.getSolution(), largeContents)) != null) {
                        article.setSolution(newSolution);
                        this.knowledgeBaseConnector.updateArticle(article);
                    }
                    if (largeContents.isEmpty() || !ServerPluginManager.getInstance().isPluginLoaded("attachments")) continue;
                    KnowledgeBaseAttachmentConnector kbac = (KnowledgeBaseAttachmentConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseAttachmentConnector.class);
                    kbac.updateArticleAttachments(article.getArticleId(), largeContents.toArray(new LargeContent[largeContents.size()]), null, null);
                }
            }
        }
        catch (Throwable t) {
            throw new StepExecutionException(t);
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="We open the image data url that is already in the article html and we cut it out eventual.")
    private String doReplaceImg(String sourceHtml, ArrayList<LargeContent> largeContents) throws ServerDataException {
        if (sourceHtml == null) {
            return null;
        }
        int indexOfStartIMG = 0;
        while ((indexOfStartIMG = sourceHtml.indexOf("<img ", indexOfStartIMG)) >= 0) {
            String imageTag;
            int indexOfEndIMG = sourceHtml.indexOf(">", indexOfStartIMG + 5);
            if (indexOfEndIMG <= indexOfStartIMG) {
                ++indexOfStartIMG;
                continue;
            }
            String replacedImageTag = imageTag = sourceHtml.substring(indexOfStartIMG, indexOfEndIMG);
            int indexEmbeddedImageAttr = imageTag.indexOf(" data-embeddedimage=\"true\"");
            if (indexEmbeddedImageAttr >= 0) {
                block15: {
                    replacedImageTag = replacedImageTag.replace(" data-embeddedimage=\"true\"", "");
                    if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                        String imageSource;
                        int indexOfSrcAttrEnd;
                        int indexOfNameAttrEnd;
                        String imageName = "image.png";
                        int indexOfNameAttr = replacedImageTag.indexOf(" name=\"");
                        if (indexOfNameAttr >= 0 && (indexOfNameAttrEnd = replacedImageTag.indexOf("\"", indexOfNameAttr + 7)) > indexOfNameAttr) {
                            imageName = replacedImageTag.substring(indexOfNameAttr + 7, indexOfNameAttrEnd);
                        }
                        imageName = MailAttachmentUtilities.normalisiertenFileName((String)imageName);
                        imageName = AttachmentFilePathBuilder.getUniqueFileName((String)imageName, largeContents.stream().map(LargeContent::getName).collect(Collectors.toList()));
                        int indexOfSrcAttr = replacedImageTag.indexOf(" src=\"");
                        if (indexOfSrcAttr >= 0 && (indexOfSrcAttrEnd = replacedImageTag.indexOf("\"", indexOfSrcAttr + 6)) > indexOfSrcAttr && (imageSource = replacedImageTag.substring(indexOfSrcAttr + 6, indexOfSrcAttrEnd)).startsWith("data:")) {
                            try {
                                URL url = new URL(imageSource);
                                URLConnection openConnection = url.openConnection();
                                String contentType = openConnection.getContentType();
                                if (!contentType.startsWith("image/")) break block15;
                                try (InputStream stream = openConnection.getInputStream();){
                                    final byte[] bytes = IOFunctions.readBytes((InputStream)stream);
                                    LargeContent largeContent = new LargeContent(new LargeContent.InputStreamProvider(){

                                        public long getSize() {
                                            return bytes.length;
                                        }

                                        public InputStream getStream() {
                                            return new ByteArrayInputStream(bytes);
                                        }
                                    });
                                    largeContent.setContentType(AttachmentType.EmbeddedImage);
                                    largeContent.setName(imageName);
                                    largeContents.add(largeContent);
                                }
                                replacedImageTag = replacedImageTag.replace(" src=\"" + imageSource + "\"", " src=\"" + imageName + "\"");
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                sourceHtml = sourceHtml.replace(imageTag, replacedImageTag);
            }
            ++indexOfStartIMG;
        }
        return sourceHtml;
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5666);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.migrate.base64images.info", new Object[0]);
    }
}

