/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.bot;

import com.inet.collaboration.bot.BotCommand;
import com.inet.collaboration.bot.BotCommandContext;
import com.inet.collaboration.bot.BotResponseFormatter;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.bot.KnowledgeBaseBotUtils;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class KnowledgeBaseInfoBotCommand
implements BotCommand {
    private static final String KB_ID_REGEX = "(?i)(kb|wb|faq)\\s*#\\d+.*";

    public String getCommandRegex() {
        return KB_ID_REGEX;
    }

    public void respondToCommand(BotCommandContext context, String text, BotResponseFormatter botResponseFormatter) {
        try {
            AtomicBoolean postedSomethingToFormatter = new AtomicBoolean(false);
            KnowledgeBaseBotUtils.extractKnowledgeBaseArticlesFromText(text, article -> {
                postedSomethingToFormatter.set(true);
                KnowledgeBaseBotUtils.postArticleToFormatter(botResponseFormatter, article);
            });
            if (!postedSomethingToFormatter.get()) {
                botResponseFormatter.formatResponse(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.noarticlesfound", new Object[0]));
            }
        }
        catch (Exception e) {
            KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
        }
    }

    public List<String> getSyntaxExamples() {
        if (SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE)) {
            return List.of(KnowledgeBaseServerPlugin.MSG.getMsg("bot.help.kbinfoshortcut", new Object[0]), KnowledgeBaseServerPlugin.MSG.getMsg("bot.help.kbinfoshortcut2", new Object[0]));
        }
        return new ArrayList<String>();
    }

    public String getHelpDescription() {
        if (SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE)) {
            return KnowledgeBaseServerPlugin.MSG.getMsg("bot.help.kbinfo", new Object[0]);
        }
        return null;
    }
}

