/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.AbstractKnowledgeBaseHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.PinArticleRequestData;
import com.inet.http.ClientMessageException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class PinArticle
extends AbstractKnowledgeBaseHandler<PinArticleRequestData, Void> {
    public String getMethodName() {
        return "web_knowledgebase_pinarticle";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, PinArticleRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        this.getArticleIfPermitted(input.getArticleId(), currentUser);
        if (!SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_EDIT_DELETE)) {
            throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.forbidden.edit", new Object[0]));
        }
        KnowledgeBaseConnector knowledgeBaseConnector = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
        knowledgeBaseConnector.savePinState(input.getArticleId(), input.isPinned());
        return null;
    }
}

