/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.datacare;

import com.inet.helpdesk.plugins.attachments.server.ExternalImageAttachmentAdder;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCareExtension;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachmentConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.plugin.ServerPluginManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class KnowledgeBaseAttachmentDataCareExtension
implements AttachmentDataCareExtension {
    public AttachmentOwnerType getAttachmentType() {
        return KnowledgeBaseAttachmentConnector.KNOWLEDGE_BASE_ATTACHMENTS;
    }

    public List<Integer> findUnrelatedAttachments(Connection connection) throws Exception {
        ArrayList<Integer> attachmentIDs = new ArrayList<Integer>();
        String sql = "SELECT attachmentId FROM tblAttachments WHERE type = ? AND isEmbedded = 0 AND ownerId NOT IN (SELECT articleId FROM tblKnowledgeBase)";
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setInt(1, this.getAttachmentType().getId());
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    int attId = rs.getInt(1);
                    attachmentIDs.add(attId);
                }
            }
        }
        ServerPluginManager spm = ServerPluginManager.getInstance();
        KnowledgeBaseConnector kbConnector = (KnowledgeBaseConnector)spm.getSingleInstance(KnowledgeBaseConnector.class);
        ExternalImageAttachmentAdder externalImageAttAdder = (ExternalImageAttachmentAdder)spm.getSingleInstance(ExternalImageAttachmentAdder.class);
        sql = "SELECT attachmentId, ownerId, fileName FROM tblAttachments WHERE type = ? AND isEmbedded = 1";
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setInt(1, this.getAttachmentType().getId());
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    int attId = rs.getInt(1);
                    Integer ownerId = rs.getInt(2);
                    Article article = kbConnector.getArticle(ownerId);
                    if (article == null) {
                        attachmentIDs.add(attId);
                        continue;
                    }
                    String fileName = new String(rs.getBytes(3), "UTF-8");
                    AttachmentKey attKey = new AttachmentKey(this.getAttachmentType(), ownerId, Integer.valueOf(-1), Integer.valueOf(-1), fileName);
                    if (this.isEmbeddedAttachmentReferencedByHtmlContent(attKey, article.getProblem(), externalImageAttAdder) || this.isEmbeddedAttachmentReferencedByHtmlContent(attKey, article.getSolution(), externalImageAttAdder)) continue;
                    attachmentIDs.add(attId);
                }
            }
        }
        return attachmentIDs;
    }

    private boolean isEmbeddedAttachmentReferencedByHtmlContent(AttachmentKey attKey, String htmlContent, ExternalImageAttachmentAdder externalImageAttAdder) {
        Set namesOfReferencedAttachments = externalImageAttAdder.findNamesOfReferencedAttachments(this.getAttachmentType(), attKey.getOwnerId().intValue(), attKey.getStepId().intValue(), htmlContent);
        return namesOfReferencedAttachments.contains(attKey.getFileName());
    }
}

