/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jpeg2000;

import com.inet.config.ConfigKey;
import com.inet.lib.core.OS;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.ArchiveFile;
import de.digitalcollections.openjpeg.OpenJpeg;
import de.digitalcollections.openjpeg.imageio.OpenJp2ImageReaderSpi;
import de.digitalcollections.openjpeg.imageio.OpenJp2ImageWriterSpi;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.zip.ZipEntry;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

@PluginInfo(group="system", id="jpeg2000", version="25.10.233", internal="imageio-openjpeg.jar;jnr-ffi.jar;jffi.jar;jffi-native.jar;asm.jar", icon="com/inet/jpeg2000/structure/jpeg2000_48.png", flags="designer")
public class Jpeg2000ServerPlugin
implements ServerPlugin {
    private static boolean a;

    public Jpeg2000ServerPlugin() {
        IIORegistry.getDefaultInstance();
        if (a || "true".equals(System.getProperty("inetuninstall"))) {
            return;
        }
        Map map = (Map)ConfigKey.PLUGINS_ACTIVATED.getCurrent();
        Boolean bl = (Boolean)map.get("jpeg2000");
        if (bl == null || Boolean.TRUE.equals(bl)) {
            a = true;
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            ForkJoinPool.commonPool().execute(() -> AccessController.doPrivileged(() -> {
                this.a(serverPluginManager);
                return null;
            }));
        }
    }

    public void registerExtension(ServerPluginManager spm) {
    }

    public void init(ServerPluginManager spm) {
        if (a) {
            return;
        }
        ForkJoinPool.commonPool().execute(() -> AccessController.doPrivileged(() -> {
            this.a(spm);
            return null;
        }));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input used")
    private void a(ServerPluginManager serverPluginManager) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ArchiveFile archiveFile;
        Object object6;
        Object object7;
        File file = serverPluginManager.getTempDir();
        String string = file.getAbsolutePath();
        String string2 = null;
        if (OS.isWindows()) {
            object7 = "windows";
        } else if (OS.isMac()) {
            if ("aarch64".equals(System.getProperty("os.arch"))) {
                object7 = null;
                string = "/opt/local/lib:/opt/homebrew/lib:/usr/local/lib";
                string2 = "Library libopenjp2.dylib was not loaded. Try to install it with: brew install openjpeg";
            } else {
                object7 = "macos";
            }
        } else {
            object7 = OS.isMuslLibrary() ? "musl" : "linux";
        }
        if (object7 != null) {
            try {
                ServerPluginDescription serverPluginDescription = serverPluginManager.getPluginDescription("jpeg2000");
                object6 = serverPluginDescription.getLocation();
                archiveFile = object6.createArchiveFile();
                try {
                    object7 = "openjpeg/" + (String)object7 + "/";
                    while ((object5 = archiveFile.getNextEntry()) != null) {
                        object4 = ((ZipEntry)object5).getName();
                        if (!((String)object4).startsWith((String)object7) || ((ZipEntry)object5).isDirectory()) continue;
                        object3 = archiveFile.getInputStream((ZipEntry)object5);
                        object2 = new File(file, ((String)object4).substring(((String)object7).length()));
                        if (((File)object2).exists()) continue;
                        object = new FileOutputStream((File)object2);
                        try {
                            IOFunctions.copyData((InputStream)object3, (OutputStream)object);
                        }
                        finally {
                            ((OutputStream)object).close();
                        }
                    }
                }
                finally {
                    if (archiveFile != null) {
                        archiveFile.close();
                    }
                }
            }
            catch (Throwable throwable) {
                LogManager.getApplicationLogger().error("Unable to load Jpeg2000 native library. Jpeg2000 images will not be displayed.", throwable);
                serverPluginManager.setPluginLoadError("jpeg2000", throwable);
                return;
            }
        }
        try {
            System.setProperty("jffi.unsafe.disabled", "true");
            String string3 = System.getProperty("jnr.ffi.library.path", "");
            System.setProperty("jnr.ffi.library.path", string3 + File.pathSeparator + string);
            new OpenJpeg();
            object6 = IIORegistry.getDefaultInstance();
            archiveFile = new OpenJp2ImageReaderSpi();
            ((ServiceRegistry)object6).registerServiceProvider(archiveFile);
            ((ServiceRegistry)object6).registerServiceProvider(new OpenJp2ImageWriterSpi());
            object5 = this.getClass().getResourceAsStream("verification.jp2");
            try {
                object4 = ImageIO.read((InputStream)object5);
                if (object4 != null) return;
                object3 = new StringBuilder();
                object2 = this.getClass().getResourceAsStream("verification.jp2");
                try {
                    object = archiveFile.createReaderInstance();
                    ImageReadParam imageReadParam = ((ImageReader)object).getDefaultReadParam();
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(object2);
                    ((StringBuilder)object3).append("\n\tImageReaders: ").append(ImageIO.getImageReaders(imageInputStream).hasNext());
                    ((StringBuilder)object3).append("\n\tIIORegistry: ").append(object6 == IIORegistry.getDefaultInstance());
                    ((ImageReader)object).setInput(imageInputStream);
                    object4 = ((ImageReader)object).read(0, imageReadParam);
                    ((StringBuilder)object3).append("\n\tImage2: ").append(object4);
                }
                finally {
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                }
                object2 = this.getClass().getResourceAsStream("verification.jp2");
                try {
                    ((StringBuilder)object3).append("\n\tImage3: ").append(ImageIO.read((InputStream)object2));
                }
                finally {
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                }
                LogManager.getApplicationLogger().error(object3);
                throw new IOException("OpenJpeg library not initalized correctly, Jpeg2000 images will not be displayed.");
            }
            finally {
                if (object5 != null) {
                    ((InputStream)object5).close();
                }
            }
        }
        catch (Throwable throwable) {
            void var6_11;
            object6 = LogManager.getApplicationLogger();
            object6.error("Unable to load Jpeg2000 Java library. Jpeg2000 images will not be displayed.\n    Java VM:\t" + System.getProperty("java.vm.name") + "\n    OS:\t" + System.getProperty("os.name") + "\n", throwable);
            if (string2 != null && throwable instanceof UnsatisfiedLinkError) {
                object6.error((Object)string2);
                UnsatisfiedLinkError unsatisfiedLinkError = new UnsatisfiedLinkError(string2);
            }
            serverPluginManager.setPluginLoadError("jpeg2000", (Throwable)var6_11);
        }
    }

    public void reset() {
    }

    public void restart() {
    }
}

