/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.openjpeg;

import java.awt.color.ColorSpace;

class CMYKColorSpace
extends ColorSpace {
    private final ColorSpace sRGB = CMYKColorSpace.getInstance(1000);

    CMYKColorSpace() {
        super(9, 4);
    }

    @Override
    public float[] toRGB(float[] cmyk) {
        float k = 1.0f - cmyk[3];
        return new float[]{(1.0f - cmyk[0]) * k, (1.0f - cmyk[1]) * k, (1.0f - cmyk[2]) * k};
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        float c = 1.0f - rgbvalue[0];
        float m = 1.0f - rgbvalue[1];
        float y = 1.0f - rgbvalue[2];
        float k = Math.min(c, Math.min(m, y));
        return new float[]{c - k, m - k, y - k, k};
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        return this.sRGB.toCIEXYZ(this.toRGB(colorvalue));
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        return this.sRGB.fromCIEXYZ(this.fromRGB(colorvalue));
    }
}

