/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.tree;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeGrouping;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeNode;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.ClientTreeSettings;
import com.inet.helpdesk.plugins.inventory.server.webapi.InventoryWebAPIExtension;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryTreeEntry;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryTreeRequest;
import com.inet.http.ClientMessageException;
import com.inet.plugin.webapi.api.PathTokenizer;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventoryTreeHandler
extends RequestHandlerBase<InventoryTreeRequest, List<InventoryTreeEntry>> {
    public InventoryTreeHandler() {
        super(new String[]{"tree"});
    }

    public String getHelpPageKey() {
        return "webapi.inventory.tree";
    }

    @Operation(summary="Get inventory asset tree", description="Retrieves a hierarchical tree structure of inventory assets with optional filtering, grouping, and depth control", responses={@ApiResponse(responseCode="200", description="Asset tree retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=InventoryTreeEntry.class)))}), @ApiResponse(responseCode="400", description="Invalid tree filter or visibility settings"), @ApiResponse(responseCode="401", description="User not authorized to access asset tree")})
    public List<InventoryTreeEntry> handle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable InventoryTreeRequest payload, @Nonnull List<String> pathTokens, boolean previewModeEnabled) throws IOException {
        if (payload == null) {
            payload = InventoryTreeRequest.defaultRequest();
        }
        AssetNodeIdentifier assetNodeId = AssetNodeIdentifier.ROOT;
        List path = PathTokenizer.originalTokensFor((String)request.getPathInfo(), pathTokens);
        if (path.size() > 0) {
            assetNodeId = AssetNodeIdentifier.valueOf((String)path.get(0));
        }
        List<String> groupingKeys = payload.getGroupingKeys();
        TreeGrouping treeGrouping = new TreeGrouping(groupingKeys.stream().map(k -> AssetFields.getFieldFor(k)).filter(f -> f != null).filter(f -> f instanceof AssetFieldWithDefinition).map(f -> (AssetFieldWithDefinition)f).collect(Collectors.toList()));
        ClientTreeSettings.TreeVisibility treeVisibility = this.safeEnum(ClientTreeSettings.TreeVisibility.class, payload.getTreeVisibility(), "tree.filter.missing");
        ClientTreeSettings.TreeFilter treeFilter = this.safeEnum(ClientTreeSettings.TreeFilter.class, payload.getTreeFilter(), "tree.filter.missing");
        ClientTreeSettings settings = new ClientTreeSettings(payload.getQuery(), treeGrouping, treeVisibility, treeFilter);
        TreeNode rootNode = AssetManager.getInstance().view().searchAssets(settings, assetNodeId, payload.getDepth(), 50);
        InventoryTreeEntry rootEntry = InventoryTreeEntry.rootNode();
        this.convertChildren(rootNode, rootEntry);
        return rootEntry.getChildren();
    }

    private void convertChildren(TreeNode rootNode, InventoryTreeEntry entryList) {
        List<TreeNode> children = rootNode.getChildren();
        if (children != null) {
            for (TreeNode nodeInfo : children) {
                InventoryTreeEntry treeEntry = InventoryTreeEntry.from(nodeInfo);
                entryList.addChild(treeEntry);
                this.convertChildren(nodeInfo, treeEntry);
            }
        }
    }

    @Nonnull
    private <T extends Enum<T>> T safeEnum(Class<T> enumClass, String value, String errorMessage) throws ClientMessageException {
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (IllegalArgumentException e) {
            String availableValues = Arrays.toString(enumClass.getEnumConstants());
            throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg(errorMessage, new Object[]{availableValues}));
        }
    }
}

