/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.ticket;

import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDescription;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.taskplanner.server.api.TaskPlanner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AdditionalReaStepFieldDefinitionAssetId
extends AdditionalReaStepFieldDefinition<GUID> {
    public AdditionalReaStepFieldDefinitionAssetId() {
        super((ReaStepField)AssetFields.FIELD_INVENTORY_ASSETID);
    }

    public List<AdditionalReaStepFieldDescription> convertToDescriptions(ReaStepVO step, Set<Integer> availableStepsIds) {
        if (step == null) {
            return null;
        }
        GUID assetId = (GUID)step.getValue((ReaStepField)AssetFields.FIELD_INVENTORY_ASSETID);
        if (assetId == null) {
            return null;
        }
        ArrayList<AdditionalReaStepFieldDescription> list = new ArrayList<AdditionalReaStepFieldDescription>();
        try {
            AssetView asset = AssetManager.getInstance().getAsset(assetId);
            if (asset != null) {
                HashMap<String, Object> linkValues = new HashMap<String, Object>();
                linkValues.put("url", "inventory/asset/" + assetId.toString());
                linkValues.put("iconclass", "icon-additionalreastepfield-inventory");
                linkValues.put("title", InventoryServerPlugin.CLIENT_MSG.getMsg("inventory.integration.ticketlist.additionalreastepfield.assetlink.title", new Object[]{asset.getName()}));
                list.add(new AdditionalReaStepFieldDescription("externallink", linkValues));
            }
        }
        catch (AccessDeniedException ade) {
            return null;
        }
        if (list.isEmpty()) {
            list = null;
        }
        return list;
    }

    protected TaskPlanner getTaskPlannerInstance() {
        return TaskPlanner.getInstance();
    }
}

