/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal.tree;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeGrouping;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeNodeInfo;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.ClientTreeSettings;
import com.inet.helpdesk.plugins.inventory.server.api.search.SearchTagArchived;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetTreeListener;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetTreeUpdateEvent;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetClientHandlingImpl;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.BaseClientHandling;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.DisplayNameIterator;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.InternalTreeNode;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.NodeWithParent;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.StructureClientHandling;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.StructureInfo;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TreeClientHandling
extends BaseClientHandling {
    public static final int TREE_MAX_NODES = 20000;
    public static final int TREE_MAX_DEPTH = 20;
    public static int CHUNKSIZE = 50;
    private ClientTreeSettings currentSettings;
    private GUID userAccountId;
    private Locale locale;
    private TimeZone clientZone;
    private AssetTreeListener listener;
    private String clientId;
    private InternalTreeNode currentTree;
    private InternalTreeNode newTree;
    private SearchCommand searchCommand;
    private IndexSearchEngine<GUID> engine;
    private AssetManager manager;
    private AssetClientHandlingImpl clientHandling;

    public TreeClientHandling(ClientTreeSettings settings, AssetTreeListener listener, String clientId, Map<AssetNodeIdentifier, Integer> openNodes, AssetManager manager, AssetClientHandlingImpl clientHandling) {
        this.newTree = this.currentTree = new InternalTreeNode(AssetNodeIdentifier.ROOT);
        this.manager = manager;
        this.clientHandling = clientHandling;
        this.userAccountId = UserManager.getInstance().getCurrentUserAccountID();
        this.listener = listener;
        this.clientId = clientId;
        this.engine = AssetManager.getInstance().getSearchEngine();
        this.currentSettings = settings;
        this.locale = ClientLocale.getThreadLocale();
        this.clientZone = ClientTimezone.getTimeZone();
        this.createSearchCommand();
        this.eventDispatcher.dispatchEvent(() -> this.buildNewTreeAndUpdateClient(Collections.emptySet(), openNodes, null, true));
    }

    public TreeClientHandling(ClientTreeSettings settings, AssetManager manager, AssetClientHandlingImpl clientHandling) {
        this.newTree = this.currentTree = new InternalTreeNode(AssetNodeIdentifier.ROOT);
        this.manager = manager;
        this.clientHandling = clientHandling;
        this.userAccountId = UserManager.getInstance().getCurrentUserAccountID();
        this.engine = AssetManager.getInstance().getSearchEngine();
        this.currentSettings = settings;
        this.locale = ClientLocale.getThreadLocale();
        this.clientZone = ClientTimezone.getTimeZone();
        this.createSearchCommand();
    }

    public void assetChanged(GUID id) {
        InventoryServerPlugin.LOGGER.debug((Object)"asset changed");
        this.checkForVisibleChanges(id);
    }

    public void settingsChanged(ClientTreeSettings newSettings) {
        if (newSettings.equals(this.currentSettings)) {
            return;
        }
        this.currentSettings = newSettings;
        this.createSearchCommand();
        this.eventDispatcher.dispatchEvent(() -> this.checkForVisibleChangesImpl(Collections.emptySet()));
    }

    @Override
    protected void checkForVisibleChangesImpl(@Nonnull Set<GUID> ids) {
        this.buildNewTreeAndUpdateClient(ids, Collections.emptyMap(), null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildNewTreeAndUpdateClient(Set<GUID> changedAssetIds, Map<AssetNodeIdentifier, Integer> initiallyOpenNodes, @Nullable AssetNodeIdentifier nodeToExpandTo, boolean structuralChange) {
        InventoryServerPlugin.LOGGER.debug((Object)"Build new Tree");
        Locale origLoc = ClientLocale.getThreadLocale();
        TimeZone origTZ = ClientTimezone.getTimeZone();
        try (UserAccountScope s = UserAccountScope.create((GUID)this.userAccountId);){
            ClientLocale.setThreadLocale((Locale)this.locale);
            ClientTimezone.setTimeZone((TimeZone)this.clientZone);
            InternalTreeNode root = new InternalTreeNode(AssetNodeIdentifier.ROOT);
            root.openNode();
            this.main_addChildren(0, root, null, null, initiallyOpenNodes, new StructureInfo(20, StructureInfo.TYPE.Tree, 20000, this.currentSettings, null), nodeToExpandTo, structuralChange);
            this.newTree = root;
            InventoryServerPlugin.LOGGER.debug((Object)("new Tree= " + String.valueOf(this.newTree)));
            this.main_sendChangesIfDifferent(this.currentTree, this.newTree, changedAssetIds, initiallyOpenNodes, this.newTree, event -> {
                InventoryServerPlugin.LOGGER.debug((Object)("[Tree] Send event: " + event.toString()));
                this.listener.sendChanges(this.clientId, (AssetTreeUpdateEvent)event);
            });
            this.currentTree = this.newTree;
        }
        catch (Throwable error) {
            InventoryServerPlugin.LOGGER.debug((Object)error);
            this.listener.sendError(this.clientId, error);
        }
        finally {
            ClientLocale.setThreadLocale((Locale)origLoc);
            ClientTimezone.setTimeZone((TimeZone)origTZ);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void main_sendChangesIfDifferent(@Nullable InternalTreeNode oldNode, @Nonnull InternalTreeNode newNode, Set<GUID> changedIds, Map<AssetNodeIdentifier, Integer> initiallyOpenNodes, @Nonnull InternalTreeNode rootNode, Consumer<AssetTreeUpdateEvent> eventSender) {
        if (oldNode != null && oldNode.isOpened()) {
            if (!newNode.isOpened()) {
                AssetTreeUpdateEvent event = new AssetTreeUpdateEvent(oldNode.getId(), 0, oldNode.getChildren().size(), 0, Collections.emptyList(), Collections.emptySet(), false, false);
                eventSender.accept(event);
                return;
            }
            this.sendChangeForNode(oldNode, newNode, changedIds, rootNode, eventSender);
            Iterator<InternalTreeNode> iterator = newNode.getChildren().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                InternalTreeNode newOne = iterator.next();
                InternalTreeNode node = oldNode.find(newOne.getId());
                this.main_sendChangesIfDifferent(node, newOne, changedIds, initiallyOpenNodes, rootNode, eventSender);
            }
        }
        if (!newNode.isOpened()) {
            return;
        }
        List<AssetNodeIdentifier> allAdded = newNode.getChildren().stream().map(InternalTreeNode::getId).collect(Collectors.toList());
        AssetTreeUpdateEvent event = new AssetTreeUpdateEvent(newNode.getId(), 0, 0, 0, allAdded, new HashSet<AssetNodeIdentifier>(allAdded), oldNode == null || newNode.getId().isRoot() || initiallyOpenNodes.containsKey(newNode.getId()), newNode.hasMoreNodes());
        eventSender.accept(event);
        Iterator<InternalTreeNode> iterator = newNode.getChildren().iterator();
        while (iterator.hasNext()) {
            InternalTreeNode node = iterator.next();
            this.main_sendChangesIfDifferent(null, node, changedIds, initiallyOpenNodes, rootNode, eventSender);
        }
        return;
    }

    private void sendChangeForNode(InternalTreeNode oldNode, InternalTreeNode newNode, Set<GUID> changedIds, InternalTreeNode rootNode, Consumer<AssetTreeUpdateEvent> eventSender) {
        InternalTreeNode newSubNode;
        int newEnd;
        int removeOffset;
        List<InternalTreeNode> oldList = oldNode.getChildren();
        List<InternalTreeNode> newList = newNode.getChildren();
        int oldEnd = Math.min(oldList.size(), newList.size());
        for (removeOffset = 0; removeOffset < oldEnd; ++removeOffset) {
            InternalTreeNode oldId = oldList.get(removeOffset);
            InternalTreeNode newId = newList.get(removeOffset);
            if (!oldId.getId().equals(newId.getId())) break;
        }
        oldEnd = oldList.size();
        for (newEnd = newList.size(); oldEnd > removeOffset && newEnd > removeOffset; --oldEnd, --newEnd) {
            InternalTreeNode oldId = oldList.get(oldEnd - 1);
            InternalTreeNode newId = newList.get(newEnd - 1);
            if (!oldId.getId().equals(newId.getId())) break;
        }
        HashSet<AssetNodeIdentifier> changedAssetIds = new HashSet<AssetNodeIdentifier>();
        for (int i = removeOffset; i < newEnd; ++i) {
            newSubNode = newList.get(i);
            if (oldNode.contains(newSubNode.getId())) continue;
            changedAssetIds.add(newSubNode.getId());
        }
        for (GUID id : changedIds) {
            AssetNodeIdentifier changedIdentifier = new AssetNodeIdentifier(id);
            if (!newNode.contains(changedIdentifier)) continue;
            changedAssetIds.add(changedIdentifier);
        }
        for (int i = 0; i < newList.size(); ++i) {
            InternalTreeNode oldSubNode;
            newSubNode = newList.get(i);
            if (!oldNode.contains(newSubNode.getId()) || (oldSubNode = oldNode.getChildren().stream().filter(n -> n.getId().equals(newSubNode.getId())).findFirst().get()).isSearchDummy() == newSubNode.isSearchDummy() && oldSubNode.getHasChildren() == newSubNode.getHasChildren() && oldSubNode.getNumOfMoreNodes() == newSubNode.getNumOfMoreNodes()) continue;
            changedAssetIds.add(newSubNode.getId());
        }
        boolean hasMoreNodesFlagChanged = oldNode.hasMoreNodes() != newNode.hasMoreNodes();
        boolean rootWasChanged = rootNode.getId().isDevice() && changedIds.contains(rootNode.getId().getDeviceId());
        int insertOffset = removeOffset;
        int insertLength = newEnd - insertOffset;
        int removeLength = oldEnd - removeOffset;
        if (removeLength == 0 && insertLength == 0 && changedAssetIds.size() == 0 && !hasMoreNodesFlagChanged && !rootWasChanged) {
            return;
        }
        if (insertLength > 0 && removeLength > 0) {
            int identicalLength;
            int firstNewIdx = oldList.indexOf(newList.get(insertOffset));
            int firstOldIdx = newList.indexOf(oldList.get(removeOffset));
            if (firstNewIdx >= 0 && (firstNewIdx < firstOldIdx || firstOldIdx < 0)) {
                int identicalLength2 = oldEnd - firstNewIdx;
                if (identicalLength2 <= insertLength && oldList.subList(firstNewIdx, oldEnd).equals(newList.subList(removeOffset, removeOffset + identicalLength2))) {
                    removeLength -= identicalLength2;
                    insertLength -= identicalLength2;
                    insertOffset += identicalLength2;
                }
            } else if (firstOldIdx >= 0 && (identicalLength = newEnd - firstOldIdx) <= removeLength && newList.subList(firstOldIdx, newEnd).equals(oldList.subList(insertOffset, insertOffset + identicalLength))) {
                removeLength -= identicalLength;
                insertLength -= identicalLength;
                removeOffset += identicalLength;
            }
        }
        if (this.stopped) {
            InventoryServerPlugin.LOGGER.debug((Object)"TreeHandling Update event not send because stopped.");
            return;
        }
        AssetTreeUpdateEvent event = new AssetTreeUpdateEvent(oldNode.getId(), removeOffset, removeLength, insertOffset, newList.subList(insertOffset, insertOffset + insertLength).stream().map(InternalTreeNode::getId).collect(Collectors.toList()), changedAssetIds, false, newNode.hasMoreNodes());
        eventSender.accept(event);
    }

    void main_addChildren(int level, InternalTreeNode currentNode, Set<GUID> devicesOfParent, @Nullable InternalTreeNode deviceSubTree, Map<AssetNodeIdentifier, Integer> initiallyOpenNodes, @Nonnull StructureInfo structureInfo, @Nullable AssetNodeIdentifier nodeToExpandTo, boolean structuralChange) {
        ClientTreeSettings settings = structureInfo.getSettings();
        BiPredicate<InternalTreeNode, InternalTreeNode> processChildNode = (node, deviceSubTreeX) -> {
            if (this.nodeIsOpen(node.getId(), initiallyOpenNodes, structureInfo, nodeToExpandTo)) {
                node.openNode();
                this.main_addChildren(-1, (InternalTreeNode)node, null, (InternalTreeNode)deviceSubTreeX, initiallyOpenNodes, structureInfo.deeper(), nodeToExpandTo, structuralChange);
                if (this.mustStop(structureInfo)) {
                    return false;
                }
                node.setHasChildren(!node.getChildren().isEmpty());
            }
            return true;
        };
        if (currentNode.getId().isDevice()) {
            if (deviceSubTree != null) {
                this.initComparator(Collections.singleton(currentNode.getId().getDeviceId()), structureInfo, initiallyOpenNodes);
                InternalTreeNode thisNode = deviceSubTree.find(currentNode.getId());
                this.addNewChildNodesFromSubTreeSortedWindowed(currentNode, thisNode, initiallyOpenNodes, structureInfo, deviceSubTree, processChildNode);
            } else {
                command = new SearchCommand(this.locale, new SearchExpression[0]);
                command.getSearchExpression().addAll((Collection)this.searchCommand.getSearchExpression());
                this.searchAndAddChildNodesSortedWindowed(command, currentNode, initiallyOpenNodes, structureInfo, processChildNode);
            }
        } else {
            if (level == 0) {
                command = new SearchCommand(this.locale, new SearchExpression[0]);
                command.getSearchExpression().addAll((Collection)this.searchCommand.getSearchExpression());
            } else {
                command = new SearchCommand(this.locale, new SearchExpression[]{new PrefilteredSearchExpression(devicesOfParent)});
                command.getSearchExpression().addAll((Collection)this.searchCommand.getSearchExpression());
                AssetFieldWithDefinition fieldFor = (AssetFieldWithDefinition)AssetFields.getFieldFor(currentNode.getId().getLastFieldKey());
                command.getSearchExpression().add((SearchExpression)fieldFor.createCondition(currentNode.getId().getLastFieldValue()));
            }
            if (settings.getGrouping().getGroupBy().size() <= level) {
                if (settings.getGrouping().getGroupBy().isEmpty() && StringFunctions.isEmpty((String)settings.getFilter()) && settings.getTreeVisibility() == ClientTreeSettings.TreeVisibility.all && settings.getTreeFilter() != ClientTreeSettings.TreeFilter.archived) {
                    this.searchAndAddChildNodesSortedWindowed(command, currentNode, initiallyOpenNodes, structureInfo, processChildNode);
                } else {
                    Set machingNodes = this.engine.simpleSearch(command);
                    this.initComparator(machingNodes, structureInfo, initiallyOpenNodes);
                    deviceSubTree = this.createFilteredDeviceTree(currentNode, machingNodes, structuralChange, structureInfo, null);
                    this.addNewChildNodesFromSubTreeSortedWindowed(currentNode, deviceSubTree, initiallyOpenNodes, structureInfo, deviceSubTree, processChildNode);
                }
            } else {
                Set devicesOfCurrentNode = this.engine.simpleSearch(command);
                AssetFieldWithDefinition<?> field = settings.getGrouping().getGroupBy().get(level);
                DisplayNameIterator iter = new DisplayNameIterator(this.engine, field.getEntrySearchTag(), field, id -> devicesOfCurrentNode.contains(id));
                int windowSize = this.getWindowSize(currentNode.getId(), initiallyOpenNodes, structureInfo);
                HashSet<String> duplicates = new HashSet<String>();
                while (iter.hasNext() && currentNode.getChildren().size() < windowSize) {
                    String value = (String)iter.next();
                    if (!duplicates.add(value)) continue;
                    InternalTreeNode groupingNode = new InternalTreeNode(new AssetNodeIdentifier(currentNode.getId(), field.getKey(), value));
                    currentNode.getChildren().add(groupingNode);
                    structureInfo.addedNode();
                    if (this.mustStop(structureInfo)) break;
                    if (!this.nodeIsOpen(groupingNode.getId(), initiallyOpenNodes, structureInfo, nodeToExpandTo)) continue;
                    groupingNode.openNode();
                    this.main_addChildren(level + 1, groupingNode, devicesOfCurrentNode, deviceSubTree, initiallyOpenNodes, structureInfo.deeper(), nodeToExpandTo, structuralChange);
                    if (!this.mustStop(structureInfo)) continue;
                    break;
                }
                this.setHasMoreNodes(currentNode, structureInfo, iter, g -> true);
            }
        }
        for (InternalTreeNode node2 : currentNode.getChildren()) {
            Boolean hasChildNodes = node2.getHasChildren();
            if (hasChildNodes != null) continue;
            if (!StringFunctions.isEmpty((String)settings.getFilter()) || !settings.getGrouping().getGroupBy().isEmpty()) {
                InventoryServerPlugin.LOGGER.debug((Object)new IllegalStateException("with grouping and/or filterung tree should know if node has children"));
                node2.setHasChildren(Boolean.TRUE);
                continue;
            }
            SearchCommand command = new SearchCommand(this.locale, new SearchExpression[0]);
            command.getSearchExpression().addAll((Collection)this.searchCommand.getSearchExpression());
            command.getSearchExpression().add(0, (Object)new SearchCondition(AssetFields.FIELD_PARENT.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)node2.getId().getDeviceId()));
            hasChildNodes = !this.engine.simpleSearch(command).isEmpty();
            node2.setHasChildren(hasChildNodes);
        }
    }

    private boolean mustStop(StructureInfo structureInfo) {
        if (structureInfo.limitReached()) {
            return true;
        }
        if (this.stopped) {
            return true;
        }
        AtomicBoolean structureStop = StructureClientHandling.STRUCTURE_STOPPED.get();
        return structureStop != null && structureStop.get();
    }

    private void searchAndAddChildNodesSortedWindowed(SearchCommand command, InternalTreeNode currentNode, Map<AssetNodeIdentifier, Integer> initiallyOpenNodes, StructureInfo structureInfo, BiPredicate<InternalTreeNode, InternalTreeNode> processChildNode) {
        AssetNodeIdentifier nodeId = currentNode.getId();
        GUID rootId = nodeId.isDevice() ? nodeId.getDeviceId() : null;
        command.getSearchExpression().add(0, (Object)new SearchCondition(AssetFields.FIELD_PARENT.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)rootId));
        Set childIds = this.engine.simpleSearch(command);
        this.initComparator(childIds, structureInfo, initiallyOpenNodes);
        this.addChildNodesFromSearchResultSortedWindowed(childIds, currentNode, initiallyOpenNodes, structureInfo, processChildNode);
    }

    private void addChildNodesFromSearchResultSortedWindowed(Set<GUID> childIds, InternalTreeNode currentNode, Map<AssetNodeIdentifier, Integer> initiallyOpenNodes, StructureInfo structureInfo, BiPredicate<InternalTreeNode, InternalTreeNode> processChildNode) {
        Iterator<GUID> iterator;
        int windowSize = this.getWindowSize(currentNode.getId(), initiallyOpenNodes, structureInfo);
        if (childIds.size() <= 1) {
            iterator = childIds.iterator();
        } else {
            ArrayList<GUID> list = new ArrayList<GUID>(childIds);
            list.sort(Objects.requireNonNull(structureInfo.getComparator()));
            iterator = list.iterator();
        }
        while (iterator.hasNext()) {
            GUID id = iterator.next();
            InternalTreeNode childNode = new InternalTreeNode(new AssetNodeIdentifier(id));
            currentNode.getChildren().add(childNode);
            structureInfo.addedNode();
            if (!this.mustStop(structureInfo) && processChildNode.test(childNode, null) && currentNode.getChildren().size() < windowSize) continue;
            break;
        }
        this.setHasMoreNodes(currentNode, structureInfo, iterator, g -> childIds.contains(g));
    }

    private void addNewChildNodesFromSubTreeSortedWindowed(InternalTreeNode currentNode, InternalTreeNode nodeToCopyFrom, Map<AssetNodeIdentifier, Integer> initiallyOpenNodes, StructureInfo structureInfo, @Nullable InternalTreeNode deviceSubTree, BiPredicate<InternalTreeNode, InternalTreeNode> processChildNode) {
        Iterator iterator;
        int windowSize = this.getWindowSize(currentNode.getId(), initiallyOpenNodes, structureInfo);
        List<InternalTreeNode> children = nodeToCopyFrom.getChildren();
        HashSet<GUID> childIds = new HashSet<GUID>(children.size());
        for (InternalTreeNode c : children) {
            childIds.add(c.getId().getDeviceId());
        }
        if (childIds.size() <= 1) {
            iterator = childIds.iterator();
        } else {
            ArrayList<GUID> list = new ArrayList<GUID>(childIds);
            list.sort(Objects.requireNonNull(structureInfo.getComparator()));
            iterator = list.iterator();
        }
        while (iterator.hasNext()) {
            GUID id = (GUID)iterator.next();
            InternalTreeNode node = nodeToCopyFrom.findDirectChild(new AssetNodeIdentifier(id));
            InternalTreeNode internalTreeNode = new InternalTreeNode(node.getId());
            internalTreeNode.setSearchDummy(node.isSearchDummy());
            internalTreeNode.setHasChildren(node.getHasChildren());
            currentNode.getChildren().add(internalTreeNode);
            structureInfo.addedNode();
            if (!this.mustStop(structureInfo) && processChildNode.test(internalTreeNode, deviceSubTree) && currentNode.getChildren().size() < windowSize) continue;
            break;
        }
        this.setHasMoreNodes(currentNode, structureInfo, iterator, g -> nodeToCopyFrom.contains(new AssetNodeIdentifier((GUID)g)));
    }

    private void initComparator(@Nonnull Set<GUID> rootIds, @Nonnull StructureInfo structureInfo, @Nonnull Map<AssetNodeIdentifier, Integer> initiallyOpenNodes) {
        int maxDepth;
        if (structureInfo.getComparator() != null) {
            return;
        }
        int n = maxDepth = structureInfo.getType() == StructureInfo.TYPE.Tree && this.currentTree.getChildren() == null && !initiallyOpenNodes.containsKey(null) ? 1 : structureInfo.getMaxDepth();
        if (maxDepth > 1) {
            HashSet<GUID> neededIds = new HashSet<GUID>(rootIds);
            for (int i = maxDepth - 1; i > 0 && !(rootIds = this.engine.simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition(AssetFields.FIELD_PARENT.getKey(), SearchCondition.SearchTermOperator.IN, rootIds)}))).isEmpty(); --i) {
                neededIds.addAll(rootIds);
            }
            rootIds = neededIds;
        }
        structureInfo.setComparator(this.createFieldNameComparator(rootIds));
    }

    @Nonnull
    private Comparator<GUID> createFieldNameComparator(@Nonnull Set<GUID> childIds) {
        Iterator createValuesIterator = this.engine.createEntryIterator(AssetFields.FIELD_NAME.getEntrySearchTag(), null, id -> childIds.contains(id));
        HashMap<GUID, String> displayValues = new HashMap<GUID, String>(childIds.size());
        while (createValuesIterator.hasNext()) {
            Map.Entry e = (Map.Entry)createValuesIterator.next();
            String displayValue = (String)e.getKey();
            if (displayValue == null) {
                displayValue = "";
            }
            for (GUID guid : (Set)e.getValue()) {
                displayValues.put(guid, displayValue);
            }
        }
        Collator collator = Collator.getInstance(this.locale);
        return (deviceId1, deviceId2) -> {
            String s1 = (String)displayValues.get(deviceId1);
            String s2 = (String)displayValues.get(deviceId2);
            if (s1 == null) {
                if (s2 == null) {
                    return deviceId1.compareTo(deviceId2);
                }
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            int compare = collator.compare(s1, s2);
            if (compare != 0) {
                return compare;
            }
            return deviceId1.compareTo(deviceId2);
        };
    }

    private <T> void setHasMoreNodes(InternalTreeNode currentNode, StructureInfo structureInfo, Iterator<T> iterator, Predicate<T> filter) {
        int moreNodes = 0;
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (filter.test(next)) {
                if (structureInfo.getType() == StructureInfo.TYPE.Tree) {
                    currentNode.setHasMoreNodes(true);
                    return;
                }
                if (++moreNodes == 1 && structureInfo.getType() == StructureInfo.TYPE.Structure && !structureInfo.limitReached()) {
                    currentNode.setChildren(currentNode.getChildren().subList(0, Math.max(0, currentNode.getChildren().size() - StructureClientHandling.STRUCTURE_MORE_NODES_THRESHOLD)));
                    moreNodes += StructureClientHandling.STRUCTURE_MORE_NODES_THRESHOLD;
                }
            }
            if (moreNodes < 100) continue;
            break;
        }
        currentNode.setHasMoreNodes(moreNodes > 0);
        currentNode.setNumOfMoreNodes(moreNodes);
    }

    @Nonnull
    private InternalTreeNode createFilteredDeviceTree(InternalTreeNode currentNode, Set<GUID> matchesOfSearch, boolean structuralChange, StructureInfo structureInfo, List<AssetNodeIdentifier.Grouping> currentNodeGroupingValues) {
        InternalTreeNode rootDummy = null;
        if (!structuralChange) {
            List<InternalTreeNode> oldOne = this.currentTree.getPathTo(currentNode.getId());
            if (oldOne != null) {
                for (int i = oldOne.size() - 1; i >= 0; --i) {
                    if (oldOne.get(i).getTempSubTree() == null) continue;
                    rootDummy = oldOne.get(i).getTempSubTree();
                    break;
                }
            }
            InternalTreeNode currentStructure = structureInfo.getCurrentStructure();
            if (rootDummy == null && currentStructure != null && (oldOne = currentStructure.getPathTo(currentNode.getId())) != null) {
                for (int i = oldOne.size() - 1; i >= 0; --i) {
                    if (oldOne.get(i).getTempSubTree() == null) continue;
                    rootDummy = oldOne.get(i).getTempSubTree();
                    break;
                }
            }
        }
        if (rootDummy == null) {
            rootDummy = new InternalTreeNode(AssetNodeIdentifier.ROOT);
            rootDummy.openNode();
            Set possibleParentsInNode = Collections.emptySet();
            if (StringFunctions.isEmpty((String)structureInfo.getSettings().getFilter())) {
                possibleParentsInNode = matchesOfSearch;
            } else {
                SearchCommand command = this.createSearchCommandForDummyParentNodes();
                if (currentNodeGroupingValues == null) {
                    if (currentNode.getId().isDevice()) {
                        throw new IllegalStateException("cannot be device, then must pass groupings");
                    }
                    currentNodeGroupingValues = currentNode.getId().getGrouping();
                }
                for (AssetNodeIdentifier.Grouping g : currentNodeGroupingValues) {
                    AssetFieldWithDefinition fieldFor = (AssetFieldWithDefinition)AssetFields.getFieldFor(g.getFieldKey());
                    command.getSearchExpression().add((SearchExpression)fieldFor.createCondition(g.getFieldValue()));
                }
                possibleParentsInNode = this.engine.simpleSearch(command);
            }
            HashMap<GUID, InternalTreeNode> lookupMap = new HashMap<GUID, InternalTreeNode>();
            for (GUID guid : matchesOfSearch) {
                this.addParentDevice(guid, null, rootDummy, matchesOfSearch, possibleParentsInNode, lookupMap);
            }
        }
        currentNode.setTempSubTree(rootDummy);
        return rootDummy;
    }

    private void addParentDevice(GUID device, InternalTreeNode child, InternalTreeNode rootDummy, Set<GUID> matchingDevices, Set<GUID> possibleParentsInNode, Map<GUID, InternalTreeNode> lookupMap) {
        boolean exists;
        boolean validNode = matchingDevices.contains(device) || possibleParentsInNode.contains(device);
        InternalTreeNode node = lookupMap.get(device);
        boolean bl = exists = node != null;
        if (validNode) {
            if (!exists) {
                node = new InternalTreeNode(new AssetNodeIdentifier(device));
                node.openNode();
                node.setHasChildren(Boolean.FALSE);
                lookupMap.put(device, node);
                if (!matchingDevices.contains(device)) {
                    node.setSearchDummy(true);
                }
            }
            if (child != null) {
                node.getChildren().add(child);
                node.setHasChildren(Boolean.TRUE);
            }
        }
        if (!exists) {
            Set parents = this.engine.simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition("children", SearchCondition.SearchTermOperator.Equals, (Object)device)}));
            if (parents.isEmpty()) {
                if (validNode) {
                    rootDummy.getChildren().add(node);
                } else {
                    rootDummy.getChildren().add(child);
                }
            } else {
                GUID parent = (GUID)parents.iterator().next();
                if (validNode) {
                    this.addParentDevice(parent, node, rootDummy, matchingDevices, possibleParentsInNode, lookupMap);
                } else {
                    this.addParentDevice(parent, child, rootDummy, matchingDevices, possibleParentsInNode, lookupMap);
                }
            }
        }
    }

    private boolean nodeIsOpen(AssetNodeIdentifier id, Map<AssetNodeIdentifier, Integer> initiallyOpenNodes, @Nonnull StructureInfo structureInfo, @Nullable AssetNodeIdentifier nodeToExpandTo) {
        if (structureInfo.getCurrentDepth() + 1 >= structureInfo.getMaxDepth()) {
            return false;
        }
        if (initiallyOpenNodes.containsKey(id)) {
            return true;
        }
        if (structureInfo.getType() == StructureInfo.TYPE.Structure) {
            return true;
        }
        InternalTreeNode old = this.currentTree.find(id);
        if (old != null && old.isOpened()) {
            return true;
        }
        return nodeToExpandTo != null && this.nodeIsSubNodeOfOrSameAs(nodeToExpandTo, id, structureInfo.getSettings());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean nodeIsSubNodeOfOrSameAs(AssetNodeIdentifier nodeToExpandTo, AssetNodeIdentifier id, ClientTreeSettings settings) {
        if (nodeToExpandTo.isRoot()) {
            return false;
        }
        if (nodeToExpandTo.isDevice()) {
            AssetView deviceToOpen = AssetManager.getInstance().getAsset(nodeToExpandTo.getDeviceId());
            if (deviceToOpen == null) {
                return false;
            }
            if (id.isDevice()) {
                if (!this.isSubDeviceOfOrSameAs(deviceToOpen.getId(), id.getDeviceId())) return false;
                AssetView cmpDevice = AssetManager.getInstance().getAsset(id.getDeviceId());
                for (AssetField assetField : settings.getGrouping().getGroupBy()) {
                    if (Objects.equals(cmpDevice.getValue(assetField), deviceToOpen.getValue(assetField))) continue;
                    return false;
                }
                return true;
            }
            for (AssetNodeIdentifier.Grouping g : id.getGrouping()) {
                AssetFieldWithDefinition assetFieldWithDefinition = (AssetFieldWithDefinition)AssetFields.getFieldFor(g.getFieldKey());
                Object valueOf = assetFieldWithDefinition.valueOf(g.getFieldValue());
                if (Objects.equals(valueOf, deviceToOpen.getValue(assetFieldWithDefinition))) continue;
                return false;
            }
            return true;
        }
        if (id.isDevice()) {
            return false;
        }
        if (!id.equals(nodeToExpandTo)) return nodeToExpandTo.getGrouping().containsAll(id.getGrouping());
        return true;
    }

    private boolean isSubDeviceOfOrSameAs(GUID deviceToOpen, GUID cmpDevice) {
        if (deviceToOpen.equals((Object)cmpDevice)) {
            return true;
        }
        Set parents = this.engine.simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition("children", SearchCondition.SearchTermOperator.Equals, (Object)deviceToOpen)}));
        if (parents.isEmpty()) {
            return false;
        }
        GUID parent = (GUID)parents.iterator().next();
        return this.isSubDeviceOfOrSameAs(parent, cmpDevice);
    }

    public AssetNodeIdentifier main_addChildrenInExistingNode(InternalTreeNode currentNode, @Nonnull StructureInfo structureInfo, boolean structuralChange, Map<AssetNodeIdentifier, Integer> initiallyOpenNodes) {
        AssetNodeIdentifier structureRoot = currentNode.getId();
        int level = 0;
        Set parentDevices = null;
        InternalTreeNode subTree = null;
        SearchCommand command = new SearchCommand(new SearchExpression[0]);
        command.getSearchExpression().addAll((Collection)this.searchCommand.getSearchExpression());
        TreeGrouping grouping = structureInfo.getSettings().getGrouping();
        AssetNodeIdentifier nodeParent = AssetNodeIdentifier.ROOT;
        if (grouping.getGroupBy().isEmpty()) {
            GUID gUID;
            Object asset;
            if (!structureRoot.isDevice() && !structureRoot.isRoot()) {
                InventoryServerPlugin.LOGGER.warn((Object)("[AddChildNodes] node does not exist:" + structureRoot.toString()));
                return null;
            }
            if (!StringFunctions.isEmpty((String)structureInfo.getSettings().getFilter())) {
                Set machingNodes = this.engine.simpleSearch(command);
                subTree = this.createFilteredDeviceTree(currentNode, machingNodes, structuralChange, structureInfo, Collections.emptyList());
            } else if (!currentNode.getId().isRoot() && (asset = this.manager.getAsset(currentNode.getId().getDeviceId())) != null && (gUID = asset.getParentID()) != null) {
                nodeParent = new AssetNodeIdentifier(gUID);
            }
        } else if (!structureRoot.isDevice()) {
            for (AssetField assetField : grouping.getGroupBy()) {
                Optional<AssetNodeIdentifier.Grouping> match = structureRoot.getGrouping().stream().filter(g -> g.getFieldKey().equals(groupField.getKey())).findFirst();
                if (!match.isPresent()) continue;
                AssetFieldWithDefinition fieldFor = (AssetFieldWithDefinition)AssetFields.getFieldFor(match.get().getFieldKey());
                command.getSearchExpression().add((SearchExpression)fieldFor.createCondition(match.get().getFieldValue()));
                ++level;
            }
            parentDevices = this.engine.simpleSearch(command);
            nodeParent = currentNode.makeParentNode();
        } else {
            AssetView device = this.manager.getAsset(structureRoot.getDeviceId());
            if (device == null) {
                InventoryServerPlugin.LOGGER.warn((Object)("Device does not exist: " + String.valueOf(structureRoot.getDeviceId())));
                return null;
            }
            level = -1;
            ArrayList<AssetNodeIdentifier.Grouping> arrayList = new ArrayList<AssetNodeIdentifier.Grouping>();
            for (AssetFieldWithDefinition<?> groupField : grouping.getGroupBy()) {
                command.getSearchExpression().add((SearchExpression)new SearchCondition(groupField.getEntrySearchKey(), SearchCondition.SearchTermOperator.Equals, device.getValue(groupField)));
                arrayList.add(new AssetNodeIdentifier.Grouping(groupField.getKey(), this.extracted(device, groupField)));
            }
            Set matches = this.engine.simpleSearch(command);
            subTree = this.createFilteredDeviceTree(currentNode, matches, structuralChange, structureInfo, arrayList);
            nodeParent = new AssetNodeIdentifier(arrayList);
        }
        if (subTree == null || subTree.find(structureRoot) != null) {
            AssetNodeIdentifier parent;
            this.main_addChildren(level, currentNode, parentDevices, subTree, initiallyOpenNodes, structureInfo, null, structuralChange);
            if (subTree != null && (parent = subTree.findWithParent(structureRoot, null).getParent()) != null && !parent.isRoot()) {
                nodeParent = parent;
            }
        }
        currentNode.setHasChildren(currentNode.getChildren().size() > 0);
        return nodeParent;
    }

    private <T> String extracted(AssetView device, AssetFieldWithDefinition<T> groupField) {
        return groupField.asString(device.getValue(groupField));
    }

    void createSearchCommand() {
        SearchCommand command;
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)UserManager.getInstance().getUserAccount(this.userAccountId), (Permission[])new Permission[]{InventoryServerPlugin.INVENTORY_READ})) {
            InventoryServerPlugin.LOGGER.warn((Object)String.format("User %s has no access to inventory", this.userAccountId));
            this.searchCommand = new SearchCommand(new SearchExpression[0]);
            return;
        }
        ClientTreeSettings settings = this.currentSettings;
        if (StringFunctions.isEmpty((String)settings.getFilter())) {
            command = new SearchCommand(new SearchExpression[0]);
        } else {
            TextSearchCommandBuilder builder = new TextSearchCommandBuilder(AssetManager.getInstance().getSearchEngine(), settings.getFilter());
            command = builder.build(this.locale);
        }
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)UserManager.getInstance().getUserAccount(this.userAccountId), (Permission[])new Permission[]{InventoryServerPlugin.INVENTORY_ALL}) || settings.getTreeVisibility() == ClientTreeSettings.TreeVisibility.mine) {
            settings.setTreeVisibility(ClientTreeSettings.TreeVisibility.mine);
            command.getSearchExpression().add((SearchExpression)new SearchCondition(AssetFields.FIELD_OWNER.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)this.userAccountId));
        }
        switch (settings.getTreeFilter()) {
            case active: {
                command.getSearchExpression().add((SearchExpression)new SearchCondition("archived", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagArchived.FALSE));
                break;
            }
            case archived: {
                command.getSearchExpression().add((SearchExpression)new SearchCondition("archived", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagArchived.TRUE));
                break;
            }
            case all: {
                break;
            }
        }
        if (command.getSearchExpression().isEmpty()) {
            command.getSearchExpression().add((SearchExpression)new SearchCondition(AssetFields.FIELD_TYPE.getKey(), SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        }
        this.searchCommand = command;
    }

    private SearchCommand createSearchCommandForDummyParentNodes() {
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)UserManager.getInstance().getUserAccount(this.userAccountId), (Permission[])new Permission[]{InventoryServerPlugin.INVENTORY_READ})) {
            InventoryServerPlugin.LOGGER.warn((Object)String.format("User %s has no access to inventory", this.userAccountId));
            return this.searchCommand;
        }
        ClientTreeSettings settings = this.currentSettings;
        SearchCommand command = new SearchCommand(new SearchExpression[0]);
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)UserManager.getInstance().getUserAccount(this.userAccountId), (Permission[])new Permission[]{InventoryServerPlugin.INVENTORY_ALL}) || settings.getTreeVisibility() == ClientTreeSettings.TreeVisibility.mine) {
            command.getSearchExpression().add((SearchExpression)new SearchCondition(AssetFields.FIELD_OWNER.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)this.userAccountId));
        }
        switch (settings.getTreeFilter()) {
            case active: {
                command.getSearchExpression().add((SearchExpression)new SearchCondition("archived", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagArchived.FALSE));
                break;
            }
            case archived: {
                command.getSearchExpression().add((SearchExpression)new SearchCondition("archived", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagArchived.TRUE));
                break;
            }
            case all: {
                break;
            }
        }
        if (command.getSearchExpression().isEmpty()) {
            command.getSearchExpression().add((SearchExpression)new SearchCondition(AssetFields.FIELD_TYPE.getKey(), SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        }
        return command;
    }

    @Override
    protected SearchID createSearchID() {
        return new SearchID((Object)("deviceTree_" + this.clientId));
    }

    public void nodesOpenedOrClosed(Set<AssetNodeIdentifier> nodesOpened, Set<AssetNodeIdentifier> nodesClosed) {
        InventoryServerPlugin.LOGGER.debug((Object)"Nodes opened or closed");
        this.eventDispatcher.dispatchEvent(() -> {
            Locale origLoc = ClientLocale.getThreadLocale();
            TimeZone origTZ = ClientTimezone.getTimeZone();
            try (UserAccountScope s = UserAccountScope.create((GUID)this.userAccountId);){
                InternalTreeNode node;
                ClientLocale.setThreadLocale((Locale)this.locale);
                ClientTimezone.setTimeZone((TimeZone)this.clientZone);
                InternalTreeNode copy = this.currentTree.copyDeep();
                for (AssetNodeIdentifier id : nodesOpened) {
                    node = copy.find(id);
                    if (node == null) continue;
                    node.openNode();
                    this.main_addChildrenInExistingNode(node, new StructureInfo(20, StructureInfo.TYPE.Tree, 20000, this.currentSettings, null), false, Collections.emptyMap());
                }
                for (AssetNodeIdentifier id : nodesClosed) {
                    node = copy.find(id);
                    if (node == null) continue;
                    node.closeNode();
                }
                this.newTree = copy;
                InventoryServerPlugin.LOGGER.debug((Object)("new Tree= " + String.valueOf(this.newTree)));
                this.main_sendChangesIfDifferent(this.currentTree, this.newTree, Collections.emptySet(), Collections.emptyMap(), this.newTree, event -> {
                    InventoryServerPlugin.LOGGER.debug((Object)("[Tree] Send event: " + event.toString()));
                    this.listener.sendChanges(this.clientId, (AssetTreeUpdateEvent)event);
                });
                this.currentTree = this.newTree;
            }
            catch (Throwable error) {
                InventoryServerPlugin.LOGGER.debug((Object)error);
                this.listener.sendError(this.clientId, error);
            }
            finally {
                ClientLocale.setThreadLocale((Locale)origLoc);
                ClientTimezone.setTimeZone((TimeZone)origTZ);
            }
        });
    }

    private int getWindowSize(AssetNodeIdentifier nodeId, Map<AssetNodeIdentifier, Integer> initiallyOpenNodes, @Nonnull StructureInfo structureInfo) {
        if (structureInfo.getType() == StructureInfo.TYPE.Structure && structureInfo.getCurrentDepth() > 0) {
            return StructureClientHandling.STRUCTURE_NUM_OF_SUB_ELEMENTS.get(structureInfo.getCurrentDepth() - 1) + StructureClientHandling.STRUCTURE_MORE_NODES_THRESHOLD;
        }
        if (structureInfo.getType() == StructureInfo.TYPE.Structure || structureInfo.getType() == StructureInfo.TYPE.Tree) {
            Integer windowSize = initiallyOpenNodes.get(nodeId);
            if (windowSize != null) {
                return Math.max(windowSize, CHUNKSIZE);
            }
            if (structureInfo.getType() == StructureInfo.TYPE.Structure) {
                InternalTreeNode node;
                if (structureInfo.getCurrentStructure() != null && (node = structureInfo.getCurrentStructure().find(nodeId)) != null && node.isOpened()) {
                    return Math.max(node.getChildren().size() + StructureClientHandling.STRUCTURE_MORE_NODES_THRESHOLD, CHUNKSIZE + StructureClientHandling.STRUCTURE_MORE_NODES_THRESHOLD);
                }
                return CHUNKSIZE + StructureClientHandling.STRUCTURE_MORE_NODES_THRESHOLD;
            }
            InternalTreeNode node = this.currentTree.find(nodeId);
            if (node != null && node.isOpened()) {
                return Math.max(node.getChildren().size(), CHUNKSIZE);
            }
        } else {
            return structureInfo.getNodeLimit();
        }
        return CHUNKSIZE;
    }

    public void loadMoreNodes(AssetNodeIdentifier parentNode) {
        InternalTreeNode node = this.currentTree.find(parentNode);
        if (node != null) {
            if (!node.isOpened()) {
                InventoryServerPlugin.LOGGER.warn((Object)("Cannot load more nodes for an unopened node: " + String.valueOf(parentNode)));
                return;
            }
            int oldSize = node.getChildren().size();
            int newSize = oldSize + CHUNKSIZE;
            if (newSize % CHUNKSIZE != 0) {
                newSize = (newSize / CHUNKSIZE + 1) * CHUNKSIZE;
            }
            Map<AssetNodeIdentifier, Integer> map = Collections.singletonMap(parentNode, newSize);
            this.eventDispatcher.dispatchEvent(() -> this.buildNewTreeAndUpdateClient(Collections.emptySet(), map, null, false));
        }
    }

    public TreeNodeInfo getNodeInfo(AssetNodeIdentifier key) {
        NodeWithParent node = this.newTree.findWithParent(key, null);
        if (node == null) {
            return null;
        }
        TreeNodeInfo nodeInfo = this.clientHandling.getNodeInfo(key, node);
        return nodeInfo;
    }

    void expandTreeToNode(AssetNodeIdentifier node) {
        this.eventDispatcher.dispatchEvent(() -> {
            if (this.currentTree != null && this.currentTree.find(node) != null && this.currentTree.find(node).isOpened()) {
                return;
            }
            this.buildNewTreeAndUpdateClient(Collections.emptySet(), Collections.emptyMap(), node, false);
        });
    }

    @Nonnull
    SearchCommand getSearchCommand() {
        return this.searchCommand;
    }

    TreeGrouping getGrouping() {
        return this.currentSettings.getGrouping();
    }

    @Nonnull
    public ClientTreeSettings getSettings() {
        return this.currentSettings;
    }
}

