/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal.search;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.search.SearchTagArchived;
import com.inet.helpdesk.plugins.inventory.server.api.search.SearchTagImportFlag;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetDataCache;
import com.inet.helpdesk.plugins.inventory.server.internal.search.AssetVetoPower;
import com.inet.helpdesk.plugins.inventory.server.internal.search.SearchTagAssetId;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.usersandgroups.HelpDeskReindexKeyGenerator;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.search.SearchDataCache;
import com.inet.search.SearchTag;
import com.inet.search.command.JoinTokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.tokenizers.CollectionSearchTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class AssetSearchEngine {
    private IndexSearchEngine<GUID> searchEngine;
    public static final String KEY_CHILDREN = "children";
    private AssetDataCache searchDataCache;
    private boolean initializationDone = false;

    private IndexSearchEngine<GUID> createSearchEngine() {
        return new IndexSearchEngine("inventorysearch", this.createReindexKey(), false, GUID.class, false);
    }

    protected String createReindexKey() {
        return HelpDeskReindexKeyGenerator.createReindexKey((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AssetDataCache cache, AssetVetoPower vetoPower) throws IOException {
        if (cache == null) {
            throw new IllegalArgumentException("search data cache must not be null");
        }
        if (this.searchDataCache != null) {
            throw new IllegalStateException("search data cache is already set");
        }
        this.searchDataCache = cache;
        this.searchEngine = this.createSearchEngine();
        DynamicExtensionManager.getInstance().get(AssetField.class).stream().map(f -> f.getSearchTag()).filter(Objects::nonNull).forEach(tag -> {
            try {
                this.searchEngine.addTag(tag);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        DynamicExtensionManager.getInstance().get(AssetField.class).stream().filter(AssetField::hasEntrySearchTag).map(AssetField::getEntrySearchTag).forEach(tag -> {
            try {
                this.searchEngine.addTag(tag);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        SearchTagAssetId idTag = new SearchTagAssetId();
        this.searchEngine.addTag((SearchTag)idTag);
        this.searchEngine.setPrimaryTag((SearchTag)idTag);
        this.searchEngine.addTag(new SearchTag(KEY_CHILDREN, (SearchTokenizer)new CollectionSearchTokenizer(), 0));
        this.searchEngine.addTag((SearchTag)new SearchTagArchived());
        this.searchEngine.addTag((SearchTag)new SearchTagImportFlag());
        Set userFields = UserManager.getInstance().getSearchEngine().getTags().stream().filter(tag -> tag.isSuggestedTag()).map(tag -> tag.getTag()).collect(Collectors.toSet());
        userFields.remove("allowedactions");
        JoinTokenMatcher.addToIndex(this.searchEngine, (String)AssetFields.FIELD_OWNER.getKey(), (IndexSearchEngine)UserManager.getInstance().getSearchEngine(), userFields, (boolean)true);
        try {
            vetoPower.getIndexVeto().setStatusToStartingInitOfIndex(this.searchEngine);
            this.searchEngine.setData((SearchDataCache)cache, 4);
            vetoPower.getIndexVeto().setStatusToFinishedInitOfIndex();
        }
        catch (Throwable ex) {
            vetoPower.getIndexVeto().setStatusToFailedInitOfIndex();
            InventoryServerPlugin.LOGGER.fatal((Object)ex);
        }
        finally {
            AssetSearchEngine assetSearchEngine = this;
            synchronized (assetSearchEngine) {
                this.initializationDone = true;
                this.notifyAll();
            }
        }
        IndexSearchEngine parentSearchEngine = TicketManager.getReaderForSystem().getSearchEngine();
        Set childTags = this.searchEngine.getTags().stream().filter(tag -> tag.isSuggestedTag()).map(tag -> tag.getTag()).collect(Collectors.toSet());
        JoinTokenMatcher.addToIndex((IndexSearchEngine)parentSearchEngine, (String)"affectedassets", this.searchEngine, childTags, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public IndexSearchEngine<GUID> getSearchEngine() {
        if (!this.initializationDone) {
            AssetSearchEngine assetSearchEngine = this;
            synchronized (assetSearchEngine) {
                if (!this.initializationDone) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
        return this.searchEngine;
    }
}

