/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.search;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.ClientTreeSettings;
import com.inet.helpdesk.plugins.inventory.server.api.search.SearchTagArchived;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.SearchTag;
import com.inet.search.SuggestedValue;
import com.inet.search.SuggestedValuesFilter;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class SearchAssets {
    public static List<SuggestedValue> loadSuggestions(String term, final ClientTreeSettings.TreeFilter treeFilter) {
        final GUID userAccountId = UserManager.getInstance().getCurrentUserAccountID();
        final boolean canAccessAll = SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_ALL);
        final IndexSearchEngine searchEngine = AssetManager.getInstance().getSearchEngine();
        SuggestedValuesFilter<GUID> filter = new SuggestedValuesFilter<GUID>(){

            public Collection<SearchTag> getSearchTags() {
                return super.getSearchTags();
            }

            @Nonnull
            public Predicate<GUID> getCondition() {
                if (canAccessAll && treeFilter == ClientTreeSettings.TreeFilter.all) {
                    return super.getCondition();
                }
                return new Predicate<GUID>(){
                    private Set<GUID> allowedAssets;

                    @Override
                    public boolean test(GUID t) {
                        if (this.allowedAssets == null) {
                            SearchCommand command = new SearchCommand(new SearchExpression[0]);
                            if (!canAccessAll) {
                                command.getSearchExpression().add((SearchExpression)new SearchCondition(AssetFields.FIELD_OWNER.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)userAccountId));
                            }
                            switch (treeFilter) {
                                case active: {
                                    command.getSearchExpression().add((SearchExpression)new SearchCondition("archived", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagArchived.FALSE));
                                    break;
                                }
                                case archived: {
                                    command.getSearchExpression().add((SearchExpression)new SearchCondition("archived", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagArchived.TRUE));
                                    break;
                                }
                            }
                            this.allowedAssets = searchEngine.simpleSearch(command);
                        }
                        return this.allowedAssets.contains(t);
                    }
                };
            }
        };
        List suggestedValues = searchEngine.getSuggestedValues(term, (SuggestedValuesFilter)filter);
        return suggestedValues;
    }
}

