/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.ticketpageextension;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.inventory.client.data.AssetDetails;
import com.inet.helpdesk.plugins.inventory.client.event.InitInventoryDetails;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.AssetListener;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RegisterAffectedAssets
extends AbstractInventoryHandler<RegisterAffectedAssetsRequest, AffectedAssetDetails>
implements TicketEventListener,
AssetListener {
    private ConcurrentHashMap<String, Integer> ticketPerClient = new ConcurrentHashMap();

    public RegisterAffectedAssets() {
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            public void connectionOpened(String clientId) {
            }

            public void connectionClosed(String clientId) {
                RegisterAffectedAssets.this.ticketPerClient.remove(clientId);
            }
        });
    }

    public String getMethodName() {
        return "inventory.register.affected.assets";
    }

    private AffectedAssetDetails createUpdateData(@Nonnull String clientId) {
        Integer ticketId = this.ticketPerClient.get(clientId);
        if (ticketId == null) {
            return new AffectedAssetDetails(ticketId, this.getTagDisplayNames());
        }
        TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
        if (ticket == null) {
            return new AffectedAssetDetails(ticketId, this.getTagDisplayNames());
        }
        List affectedAssetIds = (List)ticket.getValue((TicketField)AssetFields.TICKET_FIELD_AFFECTED_ASSETS);
        if (affectedAssetIds == null) {
            return new AffectedAssetDetails(ticketId, this.getTagDisplayNames());
        }
        ArrayList<GUID> accessibleAffectedAssetIds = new ArrayList<GUID>();
        HashMap<GUID, AssetDetails> details = new HashMap<GUID, AssetDetails>();
        for (GUID affectedAssetId : affectedAssetIds) {
            try {
                AssetView asset = AssetManager.getInstance().getAsset(affectedAssetId);
                if (asset == null) continue;
                details.put(affectedAssetId, InitInventoryDetails.createAssetDetails(asset));
                accessibleAffectedAssetIds.add(affectedAssetId);
            }
            catch (AccessDeniedException accessDeniedException) {}
        }
        return new AffectedAssetDetails(ticketId, accessibleAffectedAssetIds, details, this.getTagDisplayNames());
    }

    @Override
    public AffectedAssetDetails handle(HttpServletRequest req, HttpServletResponse resp, RegisterAffectedAssetsRequest payload) throws IOException {
        String clientId = payload.getClientId();
        Integer ticketId = payload.getTicketId();
        if (ticketId == null) {
            this.ticketPerClient.remove(clientId);
            return new AffectedAssetDetails(ticketId, this.getTagDisplayNames());
        }
        this.ticketPerClient.put(clientId, ticketId);
        return this.createUpdateData(clientId);
    }

    private HashMap<String, String> getTagDisplayNames() {
        HashMap<String, String> tagDisplayNames = new HashMap<String, String>();
        tagDisplayNames.put("ownerid", AssetFields.FIELD_OWNER.getSearchTag().getDisplayName());
        tagDisplayNames.put("location", AssetFields.FIELD_LOCATION.getSearchTag().getDisplayName());
        tagDisplayNames.put("usergroup", HDUsersAndGroups.FIELD_CLASS_ID.getSearchTag().getDisplayName() + "-(" + AssetFields.FIELD_OWNER.getSearchTag().getDisplayName() + ")");
        return tagDisplayNames;
    }

    private void sendUpdateEvent(String clientId) {
        Supplier<WebSocketEventData> eventFactory = () -> {
            AffectedAssetDetails updateData = this.createUpdateData(clientId);
            return new WebSocketEventData("inventory.affected.assets", (Object)updateData);
        };
        WebSocketEventHandler.getInstance().sendEvent(clientId, eventFactory);
    }

    public void handleEvent(TicketEvent event) {
        List changedTickets = event.getChangedTickets();
        for (ChangedTicketVO changedTicket : changedTickets) {
            Integer ticketId = changedTicket.getTicketID();
            List oldAffected = null;
            List newAffected = null;
            TicketVO oldTicket = changedTicket.getOldTicket();
            TicketVO newTicket = changedTicket.getNewTicket();
            if (oldTicket != null) {
                oldAffected = (List)oldTicket.getValue((TicketField)AssetFields.TICKET_FIELD_AFFECTED_ASSETS);
            }
            if (newTicket != null) {
                newAffected = (List)newTicket.getValue((TicketField)AssetFields.TICKET_FIELD_AFFECTED_ASSETS);
            }
            if (Objects.equals(oldAffected, newAffected) || !this.ticketPerClient.containsValue(ticketId)) continue;
            for (Map.Entry<String, Integer> entry : this.ticketPerClient.entrySet()) {
                if (!ticketId.equals(entry.getValue())) continue;
                this.sendUpdateEvent(entry.getKey());
            }
        }
    }

    @Override
    public void assetChanged(@Nullable AssetView oldState, @Nullable AssetView newState) {
        for (Map.Entry<String, Integer> entry : this.ticketPerClient.entrySet()) {
            List affectedAssetIds;
            TicketVO ticket = TicketManager.getReader().getTicket(entry.getValue().intValue());
            if (ticket == null || (affectedAssetIds = (List)ticket.getValue((TicketField)AssetFields.TICKET_FIELD_AFFECTED_ASSETS)) == null) continue;
            if (newState != null && affectedAssetIds.contains(newState.getId())) {
                this.sendUpdateEvent(entry.getKey());
                continue;
            }
            if (oldState == null || !affectedAssetIds.contains(oldState.getId())) continue;
            this.sendUpdateEvent(entry.getKey());
        }
    }

    @JsonData
    public static class AffectedAssetDetails {
        private Integer ticketId;
        private List<GUID> affectedAssets;
        private HashMap<GUID, AssetDetails> details;
        private HashMap<String, String> tagDisplayNames;

        public AffectedAssetDetails(Integer ticketId, List<GUID> affectedAssets, HashMap<GUID, AssetDetails> details, HashMap<String, String> tagDisplayNames) {
            this.ticketId = ticketId;
            this.affectedAssets = affectedAssets;
            this.details = details;
            this.tagDisplayNames = tagDisplayNames;
        }

        public AffectedAssetDetails(Integer ticketId, HashMap<String, String> tagDisplayNames) {
            this.ticketId = ticketId;
            this.tagDisplayNames = tagDisplayNames;
        }
    }

    @JsonData
    public static class RegisterAffectedAssetsRequest {
        private String clientId;
        private Integer ticketId;

        private RegisterAffectedAssetsRequest() {
        }

        public String getClientId() {
            return this.clientId;
        }

        public Integer getTicketId() {
            return this.ticketId;
        }
    }
}

