/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.ticketpageextension;

import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import java.net.URL;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InventoryTicketPageExtension
implements TicketPageExtension {
    public static final String EXTENSION_KEY = "inventory";

    @Nonnull
    public String getExtensionName() {
        return EXTENSION_KEY;
    }

    public String getDisplayName() {
        return InventoryServerPlugin.CLIENT_MSG.getMsg("inventory.integration.ticketlist.displayname", new Object[0]);
    }

    public String getDescription() {
        return InventoryServerPlugin.CLIENT_MSG.getMsg("inventory.integration.ticketlist.description", new Object[0]);
    }

    public URL getTemplateURL() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/inventory/client/ticketpageextension/inventoryextension.html");
    }

    public boolean isDefaultVisible() {
        return true;
    }

    public boolean isVisibleForTicket(int ticketID) {
        return true;
    }

    public boolean isAvailable(UserAccount userAccount) {
        return SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{InventoryServerPlugin.INVENTORY_READ});
    }

    @Nullable
    public String getCountPreview(UserAccount userAccount, TicketVO ticket) {
        List affectedAssets = (List)ticket.getValue((TicketField)AssetFields.TICKET_FIELD_AFFECTED_ASSETS);
        if (affectedAssets == null || affectedAssets.isEmpty()) {
            return null;
        }
        return "" + affectedAssets.size();
    }
}

