/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.inventory.client.InventoryAttachments;
import com.inet.helpdesk.plugins.inventory.client.data.DeviceFieldDescription;
import com.inet.helpdesk.plugins.inventory.client.data.GetAssetFieldsRequest;
import com.inet.helpdesk.plugins.inventory.client.data.GetAssetFieldsResponse;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryAttachment;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.client.handler.InitialData;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GetAssetFields
extends AbstractInventoryHandler<GetAssetFieldsRequest, GetAssetFieldsResponse> {
    public String getMethodName() {
        return "inventory.getassetfields";
    }

    @Override
    public GetAssetFieldsResponse handle(HttpServletRequest req, HttpServletResponse resp, GetAssetFieldsRequest payload) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
        }
        List<GUID> ids = payload.getIds().stream().map(GUID::new).collect(Collectors.toList());
        Set assetTypes = ids.stream().map(id -> AssetManager.getInstance().getAsset((GUID)id).getType()).collect(Collectors.toSet());
        ArrayList<DeviceFieldDescription> fields = new ArrayList<DeviceFieldDescription>();
        HashMap<String, String> values = new HashMap<String, String>();
        ArrayList<String> differentValueKeys = new ArrayList<String>();
        HashMap<String, AssetView.ValueSource> inheritedFields = new HashMap<String, AssetView.ValueSource>();
        Map<Integer, List<DeviceFieldDescription>> deviceFieldsByTypeId = InitialData.getDeviceFieldsByTypeId();
        HashSet commonFieldKeys = null;
        for (Integer assetType : assetTypes) {
            List<DeviceFieldDescription> fieldDescriptions = deviceFieldsByTypeId.get(assetType);
            HashSet<String> currentFieldKeys = new HashSet<String>();
            for (DeviceFieldDescription fieldDescription : fieldDescriptions) {
                currentFieldKeys.add(fieldDescription.getKey());
            }
            if (commonFieldKeys == null) {
                commonFieldKeys = new HashSet(currentFieldKeys);
            } else {
                commonFieldKeys.retainAll(currentFieldKeys);
            }
            if (!commonFieldKeys.isEmpty()) continue;
            break;
        }
        List<AssetView> assets = AssetManager.getInstance().getAssets(ids);
        if (commonFieldKeys != null && !commonFieldKeys.isEmpty()) {
            List definitions = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
            ArrayList<AssetFieldDefinition> commonFieldDefinitions = new ArrayList<AssetFieldDefinition>();
            for (AssetFieldDefinition fieldDefinition : definitions) {
                if (!commonFieldKeys.contains(fieldDefinition.getFieldKey())) continue;
                commonFieldDefinitions.add(fieldDefinition);
            }
            commonFieldDefinitions.sort((a, b) -> {
                int compare = Integer.compare(a.getPriority(), b.getPriority());
                if (compare == 0) {
                    compare = String.CASE_INSENSITIVE_ORDER.compare(a.getLabel(), b.getLabel());
                }
                return compare;
            });
            for (AssetView assetView : assets) {
                for (AssetFieldDefinition fieldDefinition : commonFieldDefinitions) {
                    DeviceFieldDescription deviceFieldDescription;
                    FieldEditInformation<?> editInformation;
                    String fieldKey = fieldDefinition.getFieldKey();
                    if (differentValueKeys.contains(fieldKey)) continue;
                    LocalizedKey fieldGroup = null;
                    if (fieldDefinition instanceof AssetFieldWithFieldGroup) {
                        AssetFieldWithFieldGroup fieldGroupDefinition = (AssetFieldWithFieldGroup)((Object)fieldDefinition);
                        fieldGroup = fieldGroupDefinition.getFieldGroup();
                    }
                    if ((editInformation = fieldDefinition.getEditInformation()) == null) continue;
                    String serializedValue = editInformation.serializeValue(assetView);
                    if (values.containsKey(fieldKey)) {
                        String existingValue = (String)values.get(fieldKey);
                        if (existingValue == null && serializedValue != null || existingValue != null && !existingValue.equals(serializedValue)) {
                            differentValueKeys.add(fieldKey);
                            continue;
                        }
                    } else {
                        values.put(fieldKey, serializedValue);
                    }
                    AssetField field = AssetFields.getFieldFor(fieldKey);
                    AssetView.ValueSource inherited = assetView.isInherited(field);
                    if (inherited != AssetView.ValueSource.Asset) {
                        inheritedFields.put(fieldKey, inherited);
                    }
                    if (fields.contains(deviceFieldDescription = new DeviceFieldDescription(fieldDefinition.getFieldKey(), fieldDefinition.getDisplayType().toString(), fieldDefinition.getLabel(), fieldDefinition.getDescription(), null, fieldGroup, false))) continue;
                    fields.add(deviceFieldDescription);
                }
            }
        }
        GetAssetFieldsResponse response = new GetAssetFieldsResponse(values, fields, differentValueKeys, inheritedFields);
        response.setAttachments(this.getCommonAttachment(assets));
        return response;
    }

    private List<InventoryAttachment> getCommonAttachment(List<AssetView> assetsView) {
        if (assetsView.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<InventoryAttachment> common = new HashSet<InventoryAttachment>(InventoryAttachments.getAttachments(assetsView.get(0).getId()));
        for (int i = 1; i < assetsView.size(); ++i) {
            common.retainAll(InventoryAttachments.getAttachments(assetsView.get(i).getId()));
        }
        return new ArrayList<InventoryAttachment>(common);
    }
}

