/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.angular.AngularContentService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import javax.imageio.ImageIO;

public class DeviceFieldValueIcon
extends AbstractInventoryHandler<Void, Void> {
    private static URL fallBackImageURL = null;
    private static final int DEFAULT_SIZE = 32;

    public DeviceFieldValueIcon() {
        try {
            BufferedImage img = new BufferedImage(16, 16, 2);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "PNG", baos);
            fallBackImageURL = new URL("data:image/png;base64," + Base64.getEncoder().encodeToString(baos.toByteArray()));
        }
        catch (Throwable t) {
            InventoryServerPlugin.LOGGER.error(t);
        }
    }

    public String getMethodName() {
        return "inventory.devicefieldvalueicon";
    }

    @Override
    public short getMethodType() {
        return 2;
    }

    @Override
    public Void handle(HttpServletRequest req, HttpServletResponse resp, Void payload) throws IOException {
        String value = req.getParameter("value");
        String field = req.getParameter("field");
        String requestedSize = req.getParameter("size");
        int requestedSizeInt = 32;
        try {
            requestedSizeInt = Integer.parseInt(requestedSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (StringFunctions.isEmpty((String)field)) {
            try {
                AngularContentService.serveStaticContent((HttpServletRequest)req, (HttpServletResponse)resp, (URL)fallBackImageURL, null, (String)"", (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        AssetFieldDefinition fieldDefinition = AssetFields.getFieldDefinitionFor(field);
        if (fieldDefinition != null) {
            URL icon = fieldDefinition.getIcon(value, requestedSizeInt);
            if (icon == null) {
                icon = fallBackImageURL;
            }
            try {
                AngularContentService.serveStaticContent((HttpServletRequest)req, (HttpServletResponse)resp, (URL)icon, null, (String)"", (boolean)true);
            }
            catch (IOException e) {
                InventoryServerPlugin.LOGGER.error((Throwable)e);
                try {
                    AngularContentService.serveStaticContent((HttpServletRequest)req, (HttpServletResponse)resp, (URL)fallBackImageURL, null, (String)"", (boolean)true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

