/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.plugins.inventory.client.data.AdditionalDetailsRequest;
import com.inet.helpdesk.plugins.inventory.client.data.AdditionalDetailsResponse;
import com.inet.helpdesk.plugins.inventory.client.data.DeviceFieldDescription;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AdditionalDetails
extends AbstractInventoryHandler<AdditionalDetailsRequest, AdditionalDetailsResponse> {
    public String getMethodName() {
        return "inventory.additionaldetails";
    }

    @Override
    public AdditionalDetailsResponse handle(HttpServletRequest req, HttpServletResponse resp, AdditionalDetailsRequest payload) throws IOException {
        AssetFieldWithFieldGroup fieldGroupAsset;
        List<AssetFieldWithFieldGroup.AdditionalDetailField> additionalFields;
        ArrayList<DeviceFieldDescription> fields = new ArrayList<DeviceFieldDescription>();
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, String> hyperlinks = new HashMap<String, String>();
        String key = payload.getKey();
        String value = payload.getValue();
        AssetFieldDefinition fieldDefinition = AssetFields.getFieldDefinitionFor(key);
        if (fieldDefinition != null && fieldDefinition instanceof AssetFieldWithFieldGroup && (additionalFields = (fieldGroupAsset = (AssetFieldWithFieldGroup)((Object)fieldDefinition)).getAdditionalFields(value)) != null) {
            additionalFields.sort((a, b) -> {
                int compare = Integer.compare(a.getPriority(), b.getPriority());
                if (compare == 0) {
                    compare = String.CASE_INSENSITIVE_ORDER.compare(a.getLabel(), b.getLabel());
                }
                return compare;
            });
            for (AssetFieldWithFieldGroup.AdditionalDetailField field : additionalFields) {
                DeviceFieldDescription deviceFieldDescription = new DeviceFieldDescription(field.getFieldKey(), field.getDisplayType().toString(), field.getLabel(), field.getDescription(), null, null, true);
                deviceFieldDescription.setAdditionalGroupField(true);
                fields.add(deviceFieldDescription);
                values.put(field.getFieldKey(), field.getDisplayValue((String)null));
                if (!FieldSettingsType.TYPE_LINK.equals((Object)field.getDisplayType())) continue;
                hyperlinks.put(field.getFieldKey(), field.getHyperlink());
            }
        }
        return new AdditionalDetailsResponse(fields, values, hyperlinks);
    }
}

